----------------------------------------------

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[FactorsLog]') AND type in (N'U'))
DROP TABLE [dbo].[FactorsLog]
GO

CREATE TABLE [dbo].[FactorsLog](
	[key] [int] IDENTITY(1,1) NOT NULL,
	[Action] [char](1) NULL,
	[DateAct] [datetime] NULL,
	[UserAct] [int] NULL,

	[ID] [int] NOT NULL,
	[Date] [datetime2](7) NOT NULL,
	[CustomerRef] [int] NOT NULL,
	[TypeRef] [tinyint] NOT NULL,
	[ProductSumPrice] [money] NOT NULL,
	[DiscountPercent] [decimal](5, 2) NOT NULL,
	[DiscountPrice] [money] NOT NULL,
	[RealSum] [money] NOT NULL,
	[Profit] [money] NOT NULL,
	[Description] [nvarchar](max) NULL,
	[DeductionsSum] [money] NOT NULL,
	[IsTemp] [bit] NOT NULL,
	[DefrayDate] [datetime] NULL,
	[AdditionsSum] [money] NOT NULL,
	[OrginalFactorID] [int] NULL,
	[RecPayAmount] [money] NOT NULL,
	[Tax] [money] NOT NULL,
	[RemainAmount] [money] NOT NULL,
	[Serial] [int] NULL,
	[Settlement] [bit] NOT NULL,
	[VisitorRef] [int] NULL,
	[VisitorAmount] [money] NOT NULL,
	[Attachment] [nvarchar](50) NULL,
	[ItemGroupRef] [int] NULL,
	[OwnerRef] [int] NOT NULL,
	[Flag] [int] NULL,
	[VisitorPercent] [decimal](5, 2) NOT NULL,
	[TaxPercent] [decimal](5, 2) NOT NULL,
	[DocID] [int] NULL,
	[CurrencyRef] [int] NOT NULL,
	[CurrencyRatioM] [decimal](18, 6) NOT NULL,
	[BaseProductSumPrice] [money] NOT NULL,
	[BaseDiscountPrice] [money] NOT NULL,
	[BaseRealSum] [money] NOT NULL,
	[BaseProfit] [money] NOT NULL,
	[BaseDeductionsSum] [money] NOT NULL,
	[BaseAdditionsSum] [money] NOT NULL,
	[BaseRecPayAmount] [money] NOT NULL,
	[BaseTax] [money] NOT NULL,
	[BaseRemainAmount] [money] NOT NULL,
	[BaseVisitorAmount] [money] NOT NULL,
	[CurrencyRatioD] [decimal](18, 6) NOT NULL,
 CONSTRAINT [PK_FactorsLog] PRIMARY KEY CLUSTERED 
(
	[key] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
GO

-------------------------------------------------

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[ProductItemsLog]') AND type in (N'U'))
DROP TABLE [dbo].[ProductItemsLog]
GO

CREATE TABLE [dbo].[ProductItemsLog](
	[key] [int] IDENTITY(1,1) NOT NULL,
	[Action] [char](1) NULL,
	[DateAct] [datetime] NULL,
	[UserAct] [int] NULL,

	[ID] [int]  NOT NULL,
	[FactorRef] [int] NOT NULL,
	[ProductRef] [int] NOT NULL,
	[Value] [money] NOT NULL,
	[Fee] [money] NOT NULL,
	[UnitName] [nvarchar](50) NOT NULL,
	[UnitRatio] [money] NOT NULL,
	[TotalPrice] [money] NOT NULL,
	[Profit] [money] NOT NULL,
	[SellPrice] [money] NOT NULL,
	[DiscountPercent] [decimal](5, 2) NOT NULL,
	[DiscountPrice] [money] NOT NULL,
	[Description] [nvarchar](max) NULL,
	[VisitorPercent] [decimal](5, 2) NOT NULL,
	[TaxPercent] [decimal](5, 2) NOT NULL,
	[VisitorPrice] [money] NOT NULL,
	[TaxPrice] [money] NOT NULL,
	[ExpireDate] [datetime2](7) NULL,
	[Row] [int] NOT NULL,
	[CompanyName] [nvarchar](200) NULL,
	[BaseFee] [money] NOT NULL,
	[BaseTotalPrice] [money] NOT NULL,
	[BaseProfit] [money] NOT NULL,
	[BaseSellPrice] [money] NOT NULL,
	[BaseDiscountPrice] [money] NOT NULL,
	[BaseVisitorPrice] [money] NOT NULL,
	[BaseTaxPrice] [money] NOT NULL,

 CONSTRAINT [PK_ProductItemsLog] PRIMARY KEY CLUSTERED 
(
	[key] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
GO

----------------------------------------------

BEGIN TRANSACTION
SET QUOTED_IDENTIFIER ON
SET ARITHABORT ON
SET NUMERIC_ROUNDABORT OFF
SET CONCAT_NULL_YIELDS_NULL ON
SET ANSI_NULLS ON
SET ANSI_PADDING ON
SET ANSI_WARNINGS ON
COMMIT
BEGIN TRANSACTION
GO
ALTER TABLE dbo.Users ADD CONSTRAINT
	IX_Users_1 UNIQUE NONCLUSTERED 
	(
	UserName
	) WITH( STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]

GO
ALTER TABLE dbo.Users SET (LOCK_ESCALATION = TABLE)
GO
COMMIT
select Has_Perms_By_Name(N'dbo.Users', 'Object', 'ALTER') as ALT_Per, Has_Perms_By_Name(N'dbo.Users', 'Object', 'VIEW DEFINITION') as View_def_Per, Has_Perms_By_Name(N'dbo.Users', 'Object', 'CONTROL') as Contr_Per 

----------------------------------------------

UPDATE [dbo].[Cache]   SET [value] = '2.1.5'  Where name='VersionDatabase'