
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[Tracking]') AND type in (N'U'))
DROP TABLE [dbo].[Tracking]
GO


CREATE TABLE [dbo].[Tracking](
	[ID] [int] IDENTITY(1,1) NOT NULL,
	[VisitorRef] [int] NOT NULL,
	[Date] [datetime] NOT NULL,
	[Latitudes] [decimal](8, 6) NOT NULL,
	[Longitudes] [decimal](9, 6) NOT NULL,
	[TypeRef] [int] NOT NULL,
	[Distance] [int] NOT NULL,
	[Description] [nvarchar](500) NULL,
 CONSTRAINT [PK_Tracking] PRIMARY KEY CLUSTERED 
(
	[ID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]
GO

ALTER TABLE [dbo].[Tracking] ADD  CONSTRAINT [DF_Tracking_Latitudes]  DEFAULT ((0)) FOR [Latitudes]
GO

ALTER TABLE [dbo].[Tracking] ADD  CONSTRAINT [DF_Tracking_Longitudes]  DEFAULT ((0)) FOR [Longitudes]
GO

ALTER TABLE [dbo].[Tracking] ADD  CONSTRAINT [DF_Tracking_Distance]  DEFAULT ((0)) FOR [Distance]
GO

ALTER TABLE [dbo].[Tracking]  WITH CHECK ADD  CONSTRAINT [FK_Tracking_Customers] FOREIGN KEY([VisitorRef])
REFERENCES [dbo].[Customers] ([ID])
GO

ALTER TABLE [dbo].[Tracking] CHECK CONSTRAINT [FK_Tracking_Customers]
GO

----------------------------------------------

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[TransactionLog]') AND type in (N'U'))
DROP TABLE [dbo].[TransactionLog]
GO


CREATE TABLE [dbo].[TransactionLog](
	[key] [int] IDENTITY(1,1) NOT NULL,
	[Action] [char](1) NULL,
	[DateAct] [datetime] NULL,
	[UserAct] [int] NULL,

	[ID] [int] NOT NULL,
	[Date] [datetime2](7) NOT NULL,
	[TypeRef] [tinyint] NOT NULL,
	[DocRef] [int] NOT NULL,
	[IDRef] [int] NOT NULL,
	[CodingRef] [int] NOT NULL,
	[AccountRef] [int] NOT NULL,
	[CurrencyRef] [int] NOT NULL,
	[Creditor] [money] NOT NULL,
	[Debtor] [money] NOT NULL,
	[CreditorRemain] [money] NOT NULL,
	[DebtorRemain] [money] NOT NULL,
	[CurrencyRatioM] [money] NOT NULL,
	[Description] [nvarchar](max) NULL,
	[CurrencyRatioD] [money] NOT NULL,
	[CreditorReserved] [money] NOT NULL,
	[DebtorReserved] [money] NOT NULL,
	[OwnerRef] [int] NULL,
 CONSTRAINT [PK_TransactionLog] PRIMARY KEY CLUSTERED 
(
	[key] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
GO

----------------------------------------------

UPDATE [dbo].[Cache]   SET [value] = '2.0.97'  Where name='VersionDatabase'