
BEGIN TRANSACTION
SET QUOTED_IDENTIFIER ON
SET ARITHABORT ON
SET NUMERIC_ROUNDABORT OFF
SET CONCAT_NULL_YIELDS_NULL ON
SET ANSI_NULLS ON
SET ANSI_PADDING ON
SET ANSI_WARNINGS ON
COMMIT
BEGIN TRANSACTION
GO
ALTER TABLE dbo.[Transaction]
	DROP CONSTRAINT FK_Transaction_DetailAccounts
GO
ALTER TABLE dbo.DetailAccounts SET (LOCK_ESCALATION = TABLE)
GO
COMMIT
select Has_Perms_By_Name(N'dbo.DetailAccounts', 'Object', 'ALTER') as ALT_Per, Has_Perms_By_Name(N'dbo.DetailAccounts', 'Object', 'VIEW DEFINITION') as View_def_Per, Has_Perms_By_Name(N'dbo.DetailAccounts', 'Object', 'CONTROL') as Contr_Per BEGIN TRANSACTION
GO
ALTER TABLE dbo.[Transaction] ADD CONSTRAINT
	FK_Transaction_DetailAccounts FOREIGN KEY
	(
	AccountRef
	) REFERENCES dbo.DetailAccounts
	(
	ID
	) ON UPDATE  NO ACTION 
	 ON DELETE  NO ACTION 
	
GO
ALTER TABLE dbo.[Transaction] SET (LOCK_ESCALATION = TABLE)
GO
COMMIT
select Has_Perms_By_Name(N'dbo.[Transaction]', 'Object', 'ALTER') as ALT_Per, Has_Perms_By_Name(N'dbo.[Transaction]', 'Object', 'VIEW DEFINITION') as View_def_Per, Has_Perms_By_Name(N'dbo.[Transaction]', 'Object', 'CONTROL') as Contr_Per 
Go

-----===========================================================================================================
	DISABLE Trigger ALL ON DetailAccounts ;  
GO  

	--resolve detail account with docid null
	DECLARE @Id int,@docid int,@RefTable tinyint


	DECLARE MY_CURSOR CURSOR 
		LOCAL STATIC READ_ONLY FORWARD_ONLY
	FOR 
		SELECT ID,DOCID FROM DetailAccounts WHERE DetailAccounts.[DocID] is NULL AND ID < 900000000

	OPEN MY_CURSOR
	FETCH NEXT FROM MY_CURSOR INTO @Id,@docid
	WHILE @@FETCH_STATUS = 0
	BEGIN 
		PRINT @Id

		IF @docid IS NULL
		BEGIN
			SET @docid = (NEXT VALUE FOR DocIdSequence)
			PRINT CONVERT(VARCHAR, @Id) +' '+ CONVERT(VARCHAR, @docid) 

			INSERT INTO [dbo].[DocHeader] ([ID],[RefTable],[RefID],[Date],[Subject],[Bed],[Bes])
							SELECT @docid, [RefTable] ,[RefID],'2022-01-01','',0,0 FROM DetailAccounts WHERE ID=@Id

			UPDATE DetailAccounts SET DOCID = @docid WHERE ID=@ID OR (ID>@ID*10 AND ID<@ID*10+9)

			FETCH NEXT FROM MY_CURSOR INTO @Id,@docid
		END
	END
	CLOSE MY_CURSOR
	DEALLOCATE MY_CURSOR


	
GO  

	ENABLE Trigger ALL ON DetailAccounts ;  
GO  
-----===========================================================================================================

UPDATE [dbo].[Transaction]
   SET [Date] = '2022-01-01'
 WHERE   ((CodingRef = 310105) OR
                  (TypeRef = 44) )
GO

DECLARE @ID int
DECLARE cursor_DetailAccounts  CURSOR LOCAL FOR  
SELECT ID FROM DetailAccounts
OPEN cursor_DetailAccounts
FETCH NEXT FROM cursor_DetailAccounts INTO @ID
WHILE @@FETCH_STATUS = 0   
BEGIN  

	IF @ID > 110300000 AND @ID < 110399999
	BEGIN
		DECLARE @CurrencyRef int
		DECLARE @AccountID int
		DECLARE CRN_CURSOR CURSOR 
		LOCAL STATIC READ_ONLY FORWARD_ONLY
		FOR 
		SELECT ID FROM Currencies
		OPEN CRN_CURSOR
		FETCH NEXT FROM CRN_CURSOR INTO @CurrencyRef
		WHILE @@FETCH_STATUS = 0
		BEGIN 

			SET @AccountID = @ID * 10 + @CurrencyRef
			--checkExistAccount
			IF NOT EXISTS (SELECT TOP 1 1 FROM DetailAccounts WHERE ID = @AccountID ) AND  @AccountID > 1103000000 AND @AccountID < 1103999999
			BEGIN
				PRINT 'add account: '+CONVERT(VARCHAR, @AccountID)
				INSERT INTO [dbo].[DetailAccounts]
					([ID],[CodingRef],[RefTable],[RefID],[GroupRef],[Name],[First],[Creditor],[Debtor],[Remain],[CurrencyRef],[DocID])
					SELECT @AccountID
						,DetailAccounts.CodingRef
						,DetailAccounts.RefTable
						,DetailAccounts.RefID
						,DetailAccounts.GroupRef
						,DetailAccounts.Name +' '+(SELECT NAME FROM Currencies WHERE ID = @CurrencyRef)
						,0--<First, money,>
						,0--<Creditor, money,>
						,0--<Debtor, money,>
						,0--<Remain, money,>
						,@CurrencyRef--<CurrencyRef, int,>
						,DetailAccounts.DocID--<DocID, int,>
				FROM DetailAccounts WHERE ID = @AccountID / 10
			END
  
		FETCH NEXT FROM CRN_CURSOR INTO @CurrencyRef
	  END
	  CLOSE CRN_CURSOR
	  DEALLOCATE CRN_CURSOR
	END
    
  PRINT @ID
    FETCH NEXT FROM cursor_DetailAccounts INTO @ID
END   

CLOSE cursor_DetailAccounts
DEALLOCATE cursor_DetailAccounts

---------------------------------------------------


UPDATE [dbo].[Cache]   SET [value] = '2.0.90'  Where name='VersionDatabase'