
IF (OBJECT_ID('[Visit].[FK_Visit_ItemGroup]') IS NOT NULL)
ALTER TABLE [dbo].[Visit] DROP CONSTRAINT [FK_Visit_ItemGroup]
GO

IF (OBJECT_ID('[Visit].[FK_Visit_ItemGroup]') IS NOT NULL)
ALTER TABLE [dbo].[Visit] DROP CONSTRAINT [FK_Visit_Customers]
GO

IF (OBJECT_ID('[Visit].[FK_Visit_ItemGroup]') IS NOT NULL)
ALTER TABLE [dbo].[Visit] DROP CONSTRAINT [FK_Visit_Visitors]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[Visit]') AND type in (N'U'))
DROP TABLE [dbo].[Visit]
GO

SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

CREATE TABLE [dbo].[Visit](
	[ID] [int] IDENTITY(1,1) NOT NULL,
	[VisitorRef] [int] NOT NULL,
	[CustomerRef] [int] NOT NULL,
	[Date] [datetime] NOT NULL,
	[DateNext] [datetime] NULL,
	[StayingTime] [int] NOT NULL,
	[TypeRef] [int] NOT NULL,
	[Description] [nvarchar](500) NULL,
	[Latitudes] decimal(8, 6) NOT NULL CONSTRAINT DF_Visit_Latitudes DEFAULT 0,
	[Longitudes] decimal(9, 6) NOT NULL CONSTRAINT DF_Visit_Longitudes DEFAULT 0,
	[position] nvarchar(1000) NULL,
 CONSTRAINT [PK_Visit] PRIMARY KEY CLUSTERED 
(
	[ID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]
GO

ALTER TABLE [dbo].[Visit]  WITH CHECK ADD  CONSTRAINT [FK_Visit_Visitors] FOREIGN KEY([VisitorRef])
REFERENCES [dbo].[Customers] ([ID])
GO

ALTER TABLE [dbo].[Visit] CHECK CONSTRAINT [FK_Visit_Visitors]
GO

ALTER TABLE [dbo].[Visit]  WITH CHECK ADD  CONSTRAINT [FK_Visit_Customers] FOREIGN KEY([CustomerRef])
REFERENCES [dbo].[Customers] ([ID])
GO

ALTER TABLE [dbo].[Visit] CHECK CONSTRAINT [FK_Visit_Customers]
GO

ALTER TABLE [dbo].[Visit]  WITH CHECK ADD  CONSTRAINT [FK_Visit_ItemGroup] FOREIGN KEY([TypeRef])
REFERENCES [dbo].[ItemGroup] ([ID])
GO

ALTER TABLE [dbo].[Visit] CHECK CONSTRAINT [FK_Visit_ItemGroup]
GO


UPDATE [dbo].[Cache]   SET [value] = '2.0.89'  Where name='VersionDatabase'