	 
 ----=================================================================
 ---Drop Transactions

 ALTER TABLE Cashs  DROP CONSTRAINT  FK_CashBox_Transactions;
 ALTER TABLE Cashs  DROP COLUMN CashBoxTransactionRef;
 
 ALTER TABLE Cashs  DROP CONSTRAINT  FK_Customer_Transaction;
 ALTER TABLE Cashs  DROP COLUMN CustomerTransactionRef;

 ALTER TABLE CashBox  DROP CONSTRAINT  FK_CashBox_Transaction;
 ALTER TABLE CashBox  DROP COLUMN FirstTransactionRef;

 ALTER TABLE Customers  DROP CONSTRAINT  FK_Customers_Transaction;
 ALTER TABLE Customers  DROP COLUMN FirstTransactionRef;

 ALTER TABLE InOuts  DROP CONSTRAINT  FK_InOuts_Transaction1;
 ALTER TABLE InOuts  DROP COLUMN CustomerTransactionRef;

 ALTER TABLE Factors  DROP CONSTRAINT  FK_Factors_Transaction;
 ALTER TABLE Factors  DROP COLUMN CustomerTransactionRef;

 ALTER TABLE Factors  DROP CONSTRAINT  FK_Factors_Transaction1;
 ALTER TABLE Factors  DROP COLUMN VisitorTransactionRef;

 GO
  ----=================================================================
  ---- OnDeleteProductitemCascade
BEGIN TRANSACTION
SET QUOTED_IDENTIFIER ON
SET ARITHABORT ON
SET NUMERIC_ROUNDABORT OFF
SET CONCAT_NULL_YIELDS_NULL ON
SET ANSI_NULLS ON
SET ANSI_PADDING ON
SET ANSI_WARNINGS ON
COMMIT
BEGIN TRANSACTION
GO
ALTER TABLE dbo.ProductCardex
	DROP CONSTRAINT FK_ProductCardex_ProductItems
GO
ALTER TABLE dbo.ProductItems SET (LOCK_ESCALATION = TABLE)
GO
COMMIT
select Has_Perms_By_Name(N'dbo.ProductItems', 'Object', 'ALTER') as ALT_Per, Has_Perms_By_Name(N'dbo.ProductItems', 'Object', 'VIEW DEFINITION') as View_def_Per, Has_Perms_By_Name(N'dbo.ProductItems', 'Object', 'CONTROL') as Contr_Per BEGIN TRANSACTION
GO
ALTER TABLE dbo.ProductCardex ADD CONSTRAINT
	FK_ProductCardex_ProductItems FOREIGN KEY
	(
	ProductItemRef
	) REFERENCES dbo.ProductItems
	(
	ID
	) ON UPDATE  NO ACTION 
	 ON DELETE  CASCADE 
	
GO
ALTER TABLE dbo.ProductCardex SET (LOCK_ESCALATION = TABLE)
GO
COMMIT


----=================================================================
--- CashsAddCurrencyref

IF NOT EXISTS (
  SELECT * 
  FROM   sys.columns 
  WHERE  object_id = OBJECT_ID(N'[dbo].[Cashs]') AND name = 'CurrencyRef'
)
BEGIN
 ALTER TABLE Cashs  ADD CurrencyRef INT
END
 Go
 
 UPDATE Cashs SET CurrencyRef = (SELECT TOP 1 CurrencyRef FROM CashBox WHERE CashBox.ID=CashboxRef)
 Go
----=================================================================
--- DetailAccountsAddDocID
BEGIN TRANSACTION
SET QUOTED_IDENTIFIER ON
SET ARITHABORT ON
SET NUMERIC_ROUNDABORT OFF
SET CONCAT_NULL_YIELDS_NULL ON
SET ANSI_NULLS ON
SET ANSI_PADDING ON
SET ANSI_WARNINGS ON
COMMIT
BEGIN TRANSACTION
GO
ALTER TABLE dbo.DocHeader SET (LOCK_ESCALATION = TABLE)
GO
COMMIT
select Has_Perms_By_Name(N'dbo.DocHeader', 'Object', 'ALTER') as ALT_Per, Has_Perms_By_Name(N'dbo.DocHeader', 'Object', 'VIEW DEFINITION') as View_def_Per, Has_Perms_By_Name(N'dbo.DocHeader', 'Object', 'CONTROL') as Contr_Per BEGIN TRANSACTION
GO
ALTER TABLE dbo.DetailAccounts ADD
	DocID int NULL
GO
ALTER TABLE dbo.DetailAccounts ADD CONSTRAINT
	FK_DetailAccounts_DocHeader FOREIGN KEY
	(
	DocID
	) REFERENCES dbo.DocHeader
	(
	ID
	) ON UPDATE  NO ACTION 
	 ON DELETE  NO ACTION 
	
GO
ALTER TABLE dbo.DetailAccounts SET (LOCK_ESCALATION = TABLE)
GO
COMMIT

----=================================================================
--- GroupsNameTypeChange

BEGIN TRANSACTION
SET QUOTED_IDENTIFIER ON
SET ARITHABORT ON
SET NUMERIC_ROUNDABORT OFF
SET CONCAT_NULL_YIELDS_NULL ON
SET ANSI_NULLS ON
SET ANSI_PADDING ON
SET ANSI_WARNINGS ON
COMMIT
BEGIN TRANSACTION
GO
CREATE TABLE dbo.Tmp_Groups
	(
	ID int NOT NULL,
	Name varchar(50) NOT NULL,
	Description nvarchar(MAX) NULL
	)  ON [PRIMARY]
	 TEXTIMAGE_ON [PRIMARY]
GO
ALTER TABLE dbo.Tmp_Groups SET (LOCK_ESCALATION = TABLE)
GO
IF EXISTS(SELECT * FROM dbo.Groups)
	 EXEC('INSERT INTO dbo.Tmp_Groups (ID, Name, Description)
		SELECT ID, CONVERT(varchar(50), Name), Description FROM dbo.Groups WITH (HOLDLOCK TABLOCKX)')
GO
ALTER TABLE dbo.GroupPermission
	DROP CONSTRAINT FK_GroupPermission_Groups
GO
ALTER TABLE dbo.UserGroups
	DROP CONSTRAINT FK_UserGroups_Groups
GO
ALTER TABLE dbo.Currencies
	DROP CONSTRAINT FK_Symbols_Groups
GO
DROP TABLE dbo.Groups
GO
EXECUTE sp_rename N'dbo.Tmp_Groups', N'Groups', 'OBJECT' 
GO
ALTER TABLE dbo.Groups ADD CONSTRAINT
	PK_Groups PRIMARY KEY CLUSTERED 
	(
	ID
	) WITH( STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]

GO
CREATE UNIQUE NONCLUSTERED INDEX IX_Groups ON dbo.Groups
	(
	Name
	) WITH( STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
COMMIT
select Has_Perms_By_Name(N'dbo.Groups', 'Object', 'ALTER') as ALT_Per, Has_Perms_By_Name(N'dbo.Groups', 'Object', 'VIEW DEFINITION') as View_def_Per, Has_Perms_By_Name(N'dbo.Groups', 'Object', 'CONTROL') as Contr_Per BEGIN TRANSACTION
GO
ALTER TABLE dbo.Currencies SET (LOCK_ESCALATION = TABLE)
GO
COMMIT
select Has_Perms_By_Name(N'dbo.Currencies', 'Object', 'ALTER') as ALT_Per, Has_Perms_By_Name(N'dbo.Currencies', 'Object', 'VIEW DEFINITION') as View_def_Per, Has_Perms_By_Name(N'dbo.Currencies', 'Object', 'CONTROL') as Contr_Per BEGIN TRANSACTION
GO
ALTER TABLE dbo.UserGroups ADD CONSTRAINT
	FK_UserGroups_Groups FOREIGN KEY
	(
	GroupRef
	) REFERENCES dbo.Groups
	(
	ID
	) ON UPDATE  NO ACTION 
	 ON DELETE  NO ACTION 
	
GO
ALTER TABLE dbo.UserGroups SET (LOCK_ESCALATION = TABLE)
GO
COMMIT
select Has_Perms_By_Name(N'dbo.UserGroups', 'Object', 'ALTER') as ALT_Per, Has_Perms_By_Name(N'dbo.UserGroups', 'Object', 'VIEW DEFINITION') as View_def_Per, Has_Perms_By_Name(N'dbo.UserGroups', 'Object', 'CONTROL') as Contr_Per BEGIN TRANSACTION
GO
ALTER TABLE dbo.GroupPermission ADD CONSTRAINT
	FK_GroupPermission_Groups FOREIGN KEY
	(
	GroupRef
	) REFERENCES dbo.Groups
	(
	ID
	) ON UPDATE  NO ACTION 
	 ON DELETE  NO ACTION 
	
GO
ALTER TABLE dbo.GroupPermission SET (LOCK_ESCALATION = TABLE)
GO
COMMIT
select Has_Perms_By_Name(N'dbo.GroupPermission', 'Object', 'ALTER') as ALT_Per, Has_Perms_By_Name(N'dbo.GroupPermission', 'Object', 'VIEW DEFINITION') as View_def_Per, Has_Perms_By_Name(N'dbo.GroupPermission', 'Object', 'CONTROL') as Contr_Per 


UPDATE [dbo].[Groups] SET [Name] = 'GUEST' WHERE ID=1
UPDATE [dbo].[Groups] SET [Name] = 'CUSTOMER' WHERE ID=2
UPDATE [dbo].[Groups] SET [Name] = 'VISITOR' WHERE ID=3
UPDATE [dbo].[Groups] SET [Name] = 'STOREKEEPER' WHERE ID=4

IF EXISTS(SELECT ID FROM [dbo].[Groups] WHERE ID=5)
BEGIN
UPDATE [dbo].[Groups] SET [Name]='CASHER' WHERE ID=5
END
ELSE
BEGIN
IF(SELECT columnproperty(object_id('[dbo].[Groups]'),'ID','IsIdentity')) = 1
BEGIN
SET IDENTITY_INSERT [dbo].[Groups] ON
INSERT INTO [dbo].[Groups] ([ID],[Name]) VALUES (5 ,'CASHER')
SET IDENTITY_INSERT [dbo].[Groups] OFF
END
ELSE
BEGIN
INSERT INTO [dbo].[Groups] ([ID],[Name]) VALUES (5 ,'CASHER')
END
END

IF EXISTS(SELECT ID FROM [dbo].[Groups] WHERE ID=6)
BEGIN
UPDATE [dbo].[Groups] SET [Name]='MANAGER' WHERE ID=6
END
ELSE
BEGIN
IF(SELECT columnproperty(object_id('[dbo].[Groups]'),'ID','IsIdentity')) = 1
BEGIN
SET IDENTITY_INSERT [dbo].[Groups] ON
INSERT INTO [dbo].[Groups] ([ID],[Name]) VALUES (6 ,'MANAGER')
SET IDENTITY_INSERT [dbo].[Groups] OFF
END
ELSE
BEGIN
INSERT INTO [dbo].[Groups] ([ID],[Name]) VALUES (6 ,'MANAGER')
END
END

IF EXISTS(SELECT ID FROM [dbo].[Groups] WHERE ID=7)
BEGIN
UPDATE [dbo].[Groups] SET [Name]='ADMIN' WHERE ID=7
END
ELSE
BEGIN
IF(SELECT columnproperty(object_id('[dbo].[Groups]'),'ID','IsIdentity')) = 1
BEGIN
SET IDENTITY_INSERT [dbo].[Groups] ON
INSERT INTO [dbo].[Groups] ([ID],[Name]) VALUES (7 ,'ADMIN')
SET IDENTITY_INSERT [dbo].[Groups] OFF
END
ELSE
BEGIN
INSERT INTO [dbo].[Groups] ([ID],[Name]) VALUES (7 ,'ADMIN')
END
END

DECLARE @PartRef int = 1
WHILE @PartRef < 21
BEGIN
	DECLARE @GroupRef int = 5
	WHILE @GroupRef < 8
	BEGIN
		INSERT INTO [dbo].[GroupPermission] ([GroupRef],[PartRef],[View],[Edit],[Del],[New],[Archive],[ViewOwner],[EditOwner],[DelOwner],[ArchiveOwner]) VALUES (@GroupRef,@PartRef,1,1,1,1,1,1,1,1,1)
		SET @GroupRef = @GroupRef + 1
	END
	SET @PartRef = @PartRef + 1
END
GO

----=================================================================
--- AddGroupToUsers
BEGIN TRANSACTION
SET QUOTED_IDENTIFIER ON
SET ARITHABORT ON
SET NUMERIC_ROUNDABORT OFF
SET CONCAT_NULL_YIELDS_NULL ON
SET ANSI_NULLS ON
SET ANSI_PADDING ON
SET ANSI_WARNINGS ON
COMMIT
BEGIN TRANSACTION
GO
ALTER TABLE dbo.Groups SET (LOCK_ESCALATION = TABLE)
GO
COMMIT

GO
ALTER TABLE dbo.roles
	DROP CONSTRAINT FK_roles_Users
GO
ALTER TABLE dbo.UserGroups
	DROP CONSTRAINT FK_UserGroups_Users
GO
ALTER TABLE dbo.Users ADD
	groupRef int NOT NULL CONSTRAINT DF_Users_groupRef_1 DEFAULT ((1)),
	role varchar(50) NULL
GO
ALTER TABLE dbo.Users ADD CONSTRAINT
	FK_Users_Groups FOREIGN KEY
	(
	groupRef
	) REFERENCES dbo.Groups
	(
	ID
	) ON UPDATE  NO ACTION 
	 ON DELETE  NO ACTION 
	
GO
ALTER TABLE dbo.Users ADD CONSTRAINT
	FK_Users_Groups1 FOREIGN KEY
	(
	role
	) REFERENCES dbo.Groups
	(
	Name
	) ON UPDATE  NO ACTION 
	 ON DELETE  NO ACTION 
	
GO
ALTER TABLE dbo.Users SET (LOCK_ESCALATION = TABLE)
GO


select Has_Perms_By_Name(N'dbo.Users', 'Object', 'ALTER') as ALT_Per, Has_Perms_By_Name(N'dbo.Users', 'Object', 'VIEW DEFINITION') as View_def_Per, Has_Perms_By_Name(N'dbo.Users', 'Object', 'CONTROL') as Contr_Per BEGIN TRANSACTION
GO
ALTER TABLE dbo.UserGroups SET (LOCK_ESCALATION = TABLE)
GO
COMMIT
select Has_Perms_By_Name(N'dbo.UserGroups', 'Object', 'ALTER') as ALT_Per, Has_Perms_By_Name(N'dbo.UserGroups', 'Object', 'VIEW DEFINITION') as View_def_Per, Has_Perms_By_Name(N'dbo.UserGroups', 'Object', 'CONTROL') as Contr_Per BEGIN TRANSACTION
GO
ALTER TABLE dbo.roles SET (LOCK_ESCALATION = TABLE)
GO
COMMIT
select Has_Perms_By_Name(N'dbo.roles', 'Object', 'ALTER') as ALT_Per, Has_Perms_By_Name(N'dbo.roles', 'Object', 'VIEW DEFINITION') as View_def_Per, Has_Perms_By_Name(N'dbo.roles', 'Object', 'CONTROL') as Contr_Per 


IF EXISTS (SELECT * FROM INFORMATION_SCHEMA.TABLES WHERE TABLE_NAME = N'UserGroups')
BEGIN
    UPDATE dbo.Users SET groupRef = ISNULL((SELECT TOP 1 GroupRef FROM UserGroups WHERE Users.ID=UserGroups.UserRef),1)
	UPDATE dbo.Users SET groupRef = 7 WHERE groupRef = 1
	UPDATE dbo.Users SET [role]	  = (SELECT TOP 1 [Name] FROM Groups WHERE Groups.ID=Users.groupRef)
END


----=================================================================
--- DelRoleTableUsergroupsTable

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[roles]') AND type in (N'U'))
DROP TABLE [dbo].[roles]
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[UserGroups]') AND type in (N'U'))
DROP TABLE [dbo].[UserGroups]
GO

----=================================================================
ALTER TABLE dbo.InOuts ADD
	OwnerRef int NULL
GO
ALTER TABLE dbo.InOuts ADD CONSTRAINT
	FK_InOuts_Users FOREIGN KEY
	(
	OwnerRef
	) REFERENCES dbo.Users
	(
	ID
	) ON UPDATE  NO ACTION 
	 ON DELETE  NO ACTION 
	
---============================================================
ALTER TABLE dbo.[Transaction] ADD
	OwnerRef int NULL
GO
ALTER TABLE dbo.[Transaction] ADD CONSTRAINT
	FK_Transaction_Users FOREIGN KEY
	(
	OwnerRef
	) REFERENCES dbo.Users
	(
	ID
	) ON UPDATE  NO ACTION 
	 ON DELETE  NO ACTION 
	
---============================================================
ALTER TABLE dbo.Cashs ADD
	OwnerRef int NULL
GO
ALTER TABLE dbo.Cashs ADD CONSTRAINT
	FK_Cashs_Users FOREIGN KEY
	(
	OwnerRef
	) REFERENCES dbo.Users
	(
	ID
	) ON UPDATE  NO ACTION 
	 ON DELETE  NO ACTION 
----=================================================================
GO

DISABLE TRIGGER ALL ON  [dbo].ProductCardex
 Go
UPDATE [dbo].[ProductCardex]   SET       [CurrencyRatioM] = 1 WHERE [CurrencyRatioM] = 0
GO
UPDATE [dbo].[ProductCardex]   SET       [CurrencyRatioD] = 1 WHERE [CurrencyRatioD] = 0
GO
ENABLE TRIGGER ALL ON  [dbo].ProductCardex
 GO

UPDATE [dbo].[Transaction]   SET       [CurrencyRatioM] = 1 WHERE [CurrencyRatioM] = 0
GO
UPDATE [dbo].[Transaction]   SET       [CurrencyRatioD] = 1 WHERE [CurrencyRatioD] = 0
GO


UPDATE [dbo].InOuts   SET       [CurrencyRatioM] = 1 WHERE [CurrencyRatioM] = 0
GO
UPDATE [dbo].InOuts   SET       [CurrencyRatioD] = 1 WHERE [CurrencyRatioD] = 0
GO


UPDATE [dbo].Factors   SET       [CurrencyRatioM] = 1 WHERE [CurrencyRatioM] = 0
GO
UPDATE [dbo].Factors   SET       [CurrencyRatioD] = 1 WHERE [CurrencyRatioD] = 0
GO


UPDATE [dbo].Cashs   SET       [CurrencyRatioM] = 1 WHERE [CurrencyRatioM] = 0
GO
UPDATE [dbo].Cashs   SET       [CurrencyRatioD] = 1 WHERE [CurrencyRatioD] = 0
GO


UPDATE [dbo].Wastages   SET       [CurrencyRatioM] = 1 WHERE [CurrencyRatioM] = 0
GO
UPDATE [dbo].Wastages   SET       [CurrencyRatioD] = 1 WHERE [CurrencyRatioD] = 0
GO

UPDATE [dbo].CurrencyHistory   SET       [CurrencyRatioM] = 1 WHERE [CurrencyRatioM] = 0
GO
UPDATE [dbo].CurrencyHistory   SET       [CurrencyRatioD] = 1 WHERE [CurrencyRatioD] = 0
GO


UPDATE [dbo].Wastages   SET       [CurrencyRatioM] = 1 WHERE [CurrencyRatioM] = 0
GO
UPDATE [dbo].Wastages   SET       [CurrencyRatioD] = 1 WHERE [CurrencyRatioD] = 0
GO


UPDATE [dbo].Markets   SET       [CurrencyRatioM] = 1 WHERE [CurrencyRatioM] = 0
GO
UPDATE [dbo].Markets   SET       [CurrencyRatioD] = 1 WHERE [CurrencyRatioD] = 0
GO

UPDATE [dbo].Assets   SET       [CurrencyRatioM] = 1 WHERE [CurrencyRatioM] = 0
GO
UPDATE [dbo].Assets   SET       [CurrencyRatioD] = 1 WHERE [CurrencyRatioD] = 0
GO


UPDATE [dbo].Assets   SET       BuyCurrencyRatioD = 1 WHERE BuyCurrencyRatioD = 0
GO
UPDATE [dbo].Assets   SET       BuyCurrencyRatioM = 1 WHERE BuyCurrencyRatioM = 0
GO

UPDATE [dbo].Assets   SET       SellCurrencyRatioM = 1 WHERE SellCurrencyRatioM = 0
GO
UPDATE [dbo].Assets   SET       SellCurrencyRatioD = 1 WHERE SellCurrencyRatioD = 0
GO


UPDATE [dbo].[Cache]   SET [value] = '2.0.88'  Where name='VersionDatabase'