﻿-- Assets اصلاح جدول    

EXEC sp_rename 'dbo.Assets.CurrencyRatio', 'CurrencyRatioM', 'COLUMN'
ALTER TABLE dbo.Assets ADD CurrencyRatioD money NULL
GO
UPDATE dbo.Assets SET CurrencyRatioD=1
GO
ALTER TABLE dbo.Assets ALTER COLUMN CurrencyRatioD money NOT NULL
GO
ALTER TABLE dbo.Assets DROP CONSTRAINT DF_Assets_CurrencyRatio
ALTER TABLE dbo.Assets ADD CONSTRAINT DF_Assets_CurrencyRatioM DEFAULT ((1)) FOR CurrencyRatioM
ALTER TABLE dbo.Assets ADD CONSTRAINT DF_Assets_CurrencyRatioD DEFAULT ((1)) FOR CurrencyRatioD

EXEC sp_rename 'dbo.Assets.BuyCurrencyRatio', 'BuyCurrencyRatioM', 'COLUMN'
GO
ALTER TABLE dbo.Assets ADD BuyCurrencyRatioD money NULL
GO
UPDATE dbo.Assets SET BuyCurrencyRatioD=1
GO
ALTER TABLE dbo.Assets ALTER COLUMN BuyCurrencyRatioD money NOT NULL
GO
ALTER TABLE dbo.Assets DROP CONSTRAINT DF_Assets_BuyCurrencyRatio
ALTER TABLE dbo.Assets ADD CONSTRAINT DF_Assets_BuyCurrencyRatioM DEFAULT ((1)) FOR BuyCurrencyRatioM
ALTER TABLE dbo.Assets ADD CONSTRAINT DF_Assets_BuyCurrencyRatioD DEFAULT ((1)) FOR BuyCurrencyRatioD

GO

EXEC sp_rename 'dbo.Assets.SellCurrencyRatio', 'SellCurrencyRatioM', 'COLUMN'
GO
ALTER TABLE dbo.Assets ADD SellCurrencyRatioD money NULL
GO
UPDATE dbo.Assets SET SellCurrencyRatioD=1
GO
ALTER TABLE dbo.Assets ALTER COLUMN SellCurrencyRatioD money NOT NULL
GO
ALTER TABLE dbo.Assets DROP CONSTRAINT DF_Assets_SellCurrencyRatio
ALTER TABLE dbo.Assets ADD CONSTRAINT DF_Assets_SellCurrencyRatioM DEFAULT ((1)) FOR SellCurrencyRatioM
ALTER TABLE dbo.Assets ADD CONSTRAINT DF_Assets_SellCurrencyRatioD DEFAULT ((1)) FOR SellCurrencyRatioD

GO

-- product cardex

EXEC sp_rename 'dbo.ProductCardex.CurrencyRefRatio', 'CurrencyRatioM', 'COLUMN'
GO
ALTER TABLE dbo.ProductCardex ADD CurrencyRatioD money not null DEFAULT ((1))
GO

-- Cashs اصلاح جدول   

EXEC sp_rename 'dbo.Cashs.CurrencyRatio', 'CurrencyRatioM', 'COLUMN'
GO
ALTER TABLE dbo.Cashs ADD CurrencyRatioD money NULL
GO
UPDATE dbo.Cashs SET CurrencyRatioD=1
GO
ALTER TABLE dbo.Cashs ALTER COLUMN CurrencyRatioD money NOT NULL
GO
ALTER TABLE dbo.Cashs DROP CONSTRAINT DF_Cashs_CurrencyRatio
ALTER TABLE dbo.Cashs ADD CONSTRAINT DF_Cashs_CurrencyRatioM DEFAULT ((1)) FOR CurrencyRatioM
ALTER TABLE dbo.Cashs ADD CONSTRAINT DF_Cashs_CurrencyRatioD DEFAULT ((1)) FOR CurrencyRatioD

GO

-- CurrencyHistory اصلاح جدول   

EXEC sp_rename 'dbo.CurrencyHistory.Ratio', 'CurrencyRatioM', 'COLUMN'
GO
ALTER TABLE dbo.CurrencyHistory ADD CurrencyRatioD money NULL
GO
UPDATE dbo.CurrencyHistory SET CurrencyRatioD=1
GO
ALTER TABLE dbo.CurrencyHistory ALTER COLUMN CurrencyRatioD money NOT NULL
GO
ALTER TABLE dbo.CurrencyHistory DROP CONSTRAINT DF_CurrencyHistory_Ratio
ALTER TABLE dbo.CurrencyHistory ADD CONSTRAINT DF_CurrencyHistory_CurrencyRatioM DEFAULT ((1)) FOR CurrencyRatioM
ALTER TABLE dbo.CurrencyHistory ADD CONSTRAINT DF_CurrencyHistory_CurrencyRatioD DEFAULT ((1)) FOR CurrencyRatioD

GO

-- Factors اصلاح جدول   

EXEC sp_rename 'dbo.Factors.CurrencyRatio', 'CurrencyRatioM', 'COLUMN'
GO
ALTER TABLE dbo.Factors DROP CONSTRAINT DF_Factors_CurrencyRatio
GO
ALTER TABLE dbo.Factors ALTER COLUMN CurrencyRatioM money NOT NULL
GO
ALTER TABLE dbo.Factors ADD CurrencyRatioD money NULL
GO
UPDATE dbo.Factors SET CurrencyRatioD=1
GO
ALTER TABLE dbo.Factors ALTER COLUMN CurrencyRatioD money NOT NULL
GO
ALTER TABLE dbo.Factors ADD CONSTRAINT DF_Factors_CurrencyRatioM DEFAULT ((1)) FOR CurrencyRatioM
ALTER TABLE dbo.Factors ADD CONSTRAINT DF_Factors_CurrencyRatioD DEFAULT ((1)) FOR CurrencyRatioD


GO

-- InOuts اصلاح جدول   


EXEC sp_rename 'dbo.InOuts.CurrencyRatio', 'CurrencyRatioM', 'COLUMN'
GO
ALTER TABLE dbo.InOuts ALTER COLUMN CurrencyRatioM money NOT NULL
GO
ALTER TABLE dbo.InOuts ADD CurrencyRatioD money NULL
GO
UPDATE dbo.InOuts SET CurrencyRatioD=1
GO
ALTER TABLE dbo.InOuts ALTER COLUMN CurrencyRatioD money NOT NULL
GO
ALTER TABLE dbo.InOuts DROP CONSTRAINT DF_InOuts_CurrencyRatio
ALTER TABLE dbo.InOuts ADD CONSTRAINT DF_InOuts_CurrencyRatioM DEFAULT ((1)) FOR CurrencyRatioM
ALTER TABLE dbo.InOuts ADD CONSTRAINT DF_InOuts_CurrencyRatioD DEFAULT ((1)) FOR CurrencyRatioD


GO

-- Markets اصلاح جدول   
BEGIN TRANSACTION
SET QUOTED_IDENTIFIER ON
SET ARITHABORT ON
SET NUMERIC_ROUNDABORT OFF
SET CONCAT_NULL_YIELDS_NULL ON
SET ANSI_NULLS ON
SET ANSI_PADDING ON
SET ANSI_WARNINGS ON
COMMIT
BEGIN TRANSACTION
GO
EXECUTE sp_rename N'dbo.Markets.Buy', N'Tmp_CurrencyRatioD', 'COLUMN' 
GO
EXECUTE sp_rename N'dbo.Markets.Sell', N'Tmp_CurrencyRatioM_1', 'COLUMN' 
GO
EXECUTE sp_rename N'dbo.Markets.Tmp_CurrencyRatioD', N'CurrencyRatioD', 'COLUMN' 
GO
EXECUTE sp_rename N'dbo.Markets.Tmp_CurrencyRatioM_1', N'CurrencyRatioM', 'COLUMN' 
GO
ALTER TABLE dbo.Markets
	DROP CONSTRAINT DF_Markets_Buy
GO
ALTER TABLE dbo.Markets
	DROP CONSTRAINT DF_Markets_Sell
GO
ALTER TABLE dbo.Markets ADD CONSTRAINT
	DF_Markets_Buy DEFAULT ((1)) FOR CurrencyRatioD
GO
ALTER TABLE dbo.Markets ADD CONSTRAINT
	DF_Markets_Sell DEFAULT ((1)) FOR CurrencyRatioM
GO
ALTER TABLE dbo.Markets SET (LOCK_ESCALATION = TABLE)
GO
COMMIT
select Has_Perms_By_Name(N'dbo.Markets', 'Object', 'ALTER') as ALT_Per, Has_Perms_By_Name(N'dbo.Markets', 'Object', 'VIEW DEFINITION') as View_def_Per, Has_Perms_By_Name(N'dbo.Markets', 'Object', 'CONTROL') as Contr_Per 

GO

-- Matching اصلاح جدول   
BEGIN TRANSACTION
SET QUOTED_IDENTIFIER ON
SET ARITHABORT ON
SET NUMERIC_ROUNDABORT OFF
SET CONCAT_NULL_YIELDS_NULL ON
SET ANSI_NULLS ON
SET ANSI_PADDING ON
SET ANSI_WARNINGS ON
COMMIT
BEGIN TRANSACTION
GO
CREATE TABLE dbo.Tmp_Matching
	(
	ID int NOT NULL IDENTITY (1, 1),
	ProductRef int NOT NULL,
	BuyDate datetime2(7) NOT NULL,
	SellDate datetime2(7) NOT NULL,
	BuyRef int NOT NULL,
	SellRef int NOT NULL,
	Matched decimal(15, 2) NOT NULL,
	BuyRemain decimal(15, 2) NOT NULL,
	SellRemain decimal(15, 2) NOT NULL,
	Fee decimal(21, 6) NOT NULL
	)  ON [PRIMARY]
GO
ALTER TABLE dbo.Tmp_Matching SET (LOCK_ESCALATION = TABLE)
GO
SET IDENTITY_INSERT dbo.Tmp_Matching ON
GO
IF EXISTS(SELECT * FROM dbo.Matching)
	 EXEC('INSERT INTO dbo.Tmp_Matching (ID, ProductRef, BuyDate, SellDate, BuyRef, SellRef, Matched, BuyRemain, SellRemain, Fee)
		SELECT ID, ProductRef, BuyDate, SellDate, BuyRef, SellRef, Matched, BuyRemain, SellRemain, CONVERT(decimal(21, 6), Fee) FROM dbo.Matching WITH (HOLDLOCK TABLOCKX)')
GO
SET IDENTITY_INSERT dbo.Tmp_Matching OFF
GO
DROP TABLE dbo.Matching
GO
EXECUTE sp_rename N'dbo.Tmp_Matching', N'Matching', 'OBJECT' 
GO
ALTER TABLE dbo.Matching ADD CONSTRAINT
	PK__Matching__3214EC277F141E4C PRIMARY KEY CLUSTERED 
	(
	ID
	) WITH( STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]

GO
CREATE NONCLUSTERED INDEX IX_Matching_1 ON dbo.Matching
	(
	SellDate
	) WITH( STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX IX_Matching ON dbo.Matching
	(
	BuyDate
	) WITH( STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX idxProductRef ON dbo.Matching
	(
	ProductRef
	) WITH( STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX idxSellref ON dbo.Matching
	(
	SellRef
	) WITH( STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX idxBuyref ON dbo.Matching
	(
	BuyRef
	) WITH( STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
COMMIT
select Has_Perms_By_Name(N'dbo.Matching', 'Object', 'ALTER') as ALT_Per, Has_Perms_By_Name(N'dbo.Matching', 'Object', 'VIEW DEFINITION') as View_def_Per, Has_Perms_By_Name(N'dbo.Matching', 'Object', 'CONTROL') as Contr_Per 

GO

-- Transaction اصلاح جدول   

EXEC sp_rename 'dbo.Transaction.ToBaseCurrencyRatio', 'CurrencyRatioM', 'COLUMN'
GO
ALTER TABLE dbo.[Transaction] ADD CurrencyRatioD money NULL
GO
UPDATE dbo.[Transaction] SET CurrencyRatioD=1
GO
ALTER TABLE dbo.[Transaction] ALTER COLUMN CurrencyRatioD money NOT NULL
GO
ALTER TABLE dbo.[Transaction] DROP CONSTRAINT DF_Transaction_ToBaseCurrencyRatio
ALTER TABLE dbo.[Transaction] ADD CONSTRAINT DF_Transaction_CurrencyRatioM DEFAULT ((1)) FOR CurrencyRatioM
ALTER TABLE dbo.[Transaction] ADD CONSTRAINT DF_Transaction_CurrencyRatioD DEFAULT ((1)) FOR CurrencyRatioD
GO
ALTER TABLE dbo.[Transaction] ADD CreditorReserved money NULL
ALTER TABLE dbo.[Transaction] ADD DebtorReserved money NULL
GO
UPDATE dbo.[Transaction] SET CreditorReserved=0,DebtorReserved=0
GO
ALTER TABLE dbo.[Transaction] ALTER COLUMN CreditorReserved money NOT NULL
ALTER TABLE dbo.[Transaction] ALTER COLUMN DebtorReserved money NOT NULL
GO
ALTER TABLE dbo.[Transaction] ADD CONSTRAINT DF_Transaction_CreditorReserved DEFAULT ((0)) FOR CreditorReserved
ALTER TABLE dbo.[Transaction] ADD CONSTRAINT DF_Transaction_DebtorReserved DEFAULT ((0)) FOR DebtorReserved

GO
UPDATE dbo.[Transaction] SET CurrencyRatioM=1 WHERE CurrencyRatioM=0
-- Wastages اصلاح جدول   
BEGIN TRANSACTION
SET QUOTED_IDENTIFIER ON
SET ARITHABORT ON
SET NUMERIC_ROUNDABORT OFF
SET CONCAT_NULL_YIELDS_NULL ON
SET ANSI_NULLS ON
SET ANSI_PADDING ON
SET ANSI_WARNINGS ON
COMMIT
BEGIN TRANSACTION
GO
ALTER TABLE dbo.Wastages
	DROP CONSTRAINT FK_Wastages_DocHeader
GO
ALTER TABLE dbo.DocHeader SET (LOCK_ESCALATION = TABLE)
GO
COMMIT
select Has_Perms_By_Name(N'dbo.DocHeader', 'Object', 'ALTER') as ALT_Per, Has_Perms_By_Name(N'dbo.DocHeader', 'Object', 'VIEW DEFINITION') as View_def_Per, Has_Perms_By_Name(N'dbo.DocHeader', 'Object', 'CONTROL') as Contr_Per BEGIN TRANSACTION
GO
ALTER TABLE dbo.Wastages
	DROP CONSTRAINT FK_Wastages_Currencies
GO
ALTER TABLE dbo.Currencies SET (LOCK_ESCALATION = TABLE)
GO
COMMIT
select Has_Perms_By_Name(N'dbo.Currencies', 'Object', 'ALTER') as ALT_Per, Has_Perms_By_Name(N'dbo.Currencies', 'Object', 'VIEW DEFINITION') as View_def_Per, Has_Perms_By_Name(N'dbo.Currencies', 'Object', 'CONTROL') as Contr_Per BEGIN TRANSACTION
GO
ALTER TABLE dbo.Wastages
	DROP CONSTRAINT FK_Wastage_tbl_Goods_tbl
GO
ALTER TABLE dbo.Products SET (LOCK_ESCALATION = TABLE)
GO
COMMIT
select Has_Perms_By_Name(N'dbo.Products', 'Object', 'ALTER') as ALT_Per, Has_Perms_By_Name(N'dbo.Products', 'Object', 'VIEW DEFINITION') as View_def_Per, Has_Perms_By_Name(N'dbo.Products', 'Object', 'CONTROL') as Contr_Per BEGIN TRANSACTION
GO
ALTER TABLE dbo.Wastages
	DROP CONSTRAINT DF_Wastages_Amount
GO
ALTER TABLE dbo.Wastages
	DROP CONSTRAINT DF_Wastages_UnitRatio
GO
ALTER TABLE dbo.Wastages
	DROP CONSTRAINT DF_Wastages_CurrencyRatio
GO
ALTER TABLE dbo.Wastages
	DROP CONSTRAINT DF__Wastages__BaseAm__51851410
GO
CREATE TABLE dbo.Tmp_Wastages
	(
	ID int NOT NULL,
	ProductRef int NOT NULL,
	Value decimal(15, 2) NOT NULL,
	Date datetime2(7) NOT NULL,
	Description nvarchar(MAX) NULL,
	Type tinyint NOT NULL,
	Amount money NOT NULL,
	RefID int NULL,
	UnitName nvarchar(50) NOT NULL,
	UnitRatio decimal(15, 2) NOT NULL,
	DocID int NULL,
	CurrencyRef int NOT NULL,
	CurrencyRatioM money NOT NULL,
	CurrencyRatioD money NOT NULL,
	BaseAmount money NOT NULL,
	TypeDes nvarchar(255) NULL
	)  ON [PRIMARY]
	 TEXTIMAGE_ON [PRIMARY]
GO
ALTER TABLE dbo.Tmp_Wastages SET (LOCK_ESCALATION = TABLE)
GO
ALTER TABLE dbo.Tmp_Wastages ADD CONSTRAINT
	DF_Wastages_Amount DEFAULT ((0)) FOR Amount
GO
ALTER TABLE dbo.Tmp_Wastages ADD CONSTRAINT
	DF_Wastages_UnitRatio DEFAULT ((1)) FOR UnitRatio
GO
ALTER TABLE dbo.Tmp_Wastages ADD CONSTRAINT
	DF_Wastages_CurrencyRatio DEFAULT ((1)) FOR CurrencyRatioM
GO
ALTER TABLE dbo.Tmp_Wastages ADD CONSTRAINT
	DF_Wastages_CurrencyRatioM1 DEFAULT ((1)) FOR CurrencyRatioD
GO
ALTER TABLE dbo.Tmp_Wastages ADD CONSTRAINT
	DF__Wastages__BaseAm__51851410 DEFAULT ((0)) FOR BaseAmount
GO
IF EXISTS(SELECT * FROM dbo.Wastages)
	 EXEC('INSERT INTO dbo.Tmp_Wastages (ID, ProductRef, Value, Date, Description, Type, Amount, RefID, UnitName, UnitRatio, DocID, CurrencyRef, CurrencyRatioM, BaseAmount, TypeDes)
		SELECT ID, ProductRef, Value, Date, Description, Type, Amount, RefID, UnitName, UnitRatio, DocID, CurrencyRef, CurrencyRatio, BaseAmount, TypeDes FROM dbo.Wastages WITH (HOLDLOCK TABLOCKX)')
GO
DROP TABLE dbo.Wastages
GO
EXECUTE sp_rename N'dbo.Tmp_Wastages', N'Wastages', 'OBJECT' 
GO
ALTER TABLE dbo.Wastages ADD CONSTRAINT
	PK_Wastage_tbl PRIMARY KEY CLUSTERED 
	(
	ID
	) WITH( STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]

GO
CREATE NONCLUSTERED INDEX IX_Wastages ON dbo.Wastages
	(
	Date
	) WITH( STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX DocIDIndex ON dbo.Wastages
	(
	DocID
	) WITH( STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX IX_Wastages_1 ON dbo.Wastages
	(
	ProductRef
	) WITH( STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
ALTER TABLE dbo.Wastages WITH NOCHECK ADD CONSTRAINT
	FK_Wastage_tbl_Goods_tbl FOREIGN KEY
	(
	ProductRef
	) REFERENCES dbo.Products
	(
	ID
	) ON UPDATE  NO ACTION 
	 ON DELETE  NO ACTION 
	
GO
ALTER TABLE dbo.Wastages ADD CONSTRAINT
	FK_Wastages_Currencies FOREIGN KEY
	(
	CurrencyRef
	) REFERENCES dbo.Currencies
	(
	ID
	) ON UPDATE  NO ACTION 
	 ON DELETE  NO ACTION 
	
GO
ALTER TABLE dbo.Wastages ADD CONSTRAINT
	FK_Wastages_DocHeader FOREIGN KEY
	(
	DocID
	) REFERENCES dbo.DocHeader
	(
	ID
	) ON UPDATE  NO ACTION 
	 ON DELETE  NO ACTION 
	
GO
COMMIT
select Has_Perms_By_Name(N'dbo.Wastages', 'Object', 'ALTER') as ALT_Per, Has_Perms_By_Name(N'dbo.Wastages', 'Object', 'VIEW DEFINITION') as View_def_Per, Has_Perms_By_Name(N'dbo.Wastages', 'Object', 'CONTROL') as Contr_Per 


GO

-- Products اصلاح جدول 

ALTER TABLE dbo.Products ADD ReservedValue decimal(15, 2) NULL
GO
UPDATE dbo.Products SET ReservedValue=0
GO
ALTER TABLE dbo.Products ALTER COLUMN ReservedValue decimal(15, 2) NOT NULL
GO
ALTER TABLE dbo.Products ADD CONSTRAINT DF_Products_ReservedValue DEFAULT ((0)) FOR ReservedValue

GO

-- Cache جدول VersionDatabase آپدیت فیلد

UPDATE [dbo].[Cache]   SET [value] = '2.0.87'  Where name='VersionDatabase'

GO

--  اصلاح پروسیجر بستن دوره مالی  

ALTER PROCEDURE [dbo].[FinancialClose]	

@DateStart VARCHAR(10)

WITH ENCRYPTION

AS 

BEGIN
SET NOCOUNT ON;
begin transaction

------------------------------------------------------------

--ALTER TABLE [dbo].[Customers] ALTER COLUMN FirstTransactionRef INT NOT NULL
UPDATE [dbo].[Customers] SET FirstTransactionRef = 1

CREATE TABLE [dbo].[TMPTransaction](
	[ID] [int] IDENTITY(1,1) NOT NULL,
	[Date] [datetime2](7) NOT NULL,
	[TypeRef] [tinyint] NOT NULL,
	[DocRef] [int] NOT NULL,
	[IDRef] [int] NOT NULL,
	[CodingRef] [int] NOT NULL,
	[AccountRef] [int] NOT NULL,
	[CurrencyRef] [int] NOT NULL,
	[Creditor] [money] NOT NULL CONSTRAINT [DF_TMPTransaction_Creditor]  DEFAULT ((0)),
	[Debtor] [money] NOT NULL CONSTRAINT [DF_TMPTransaction_Debtor]  DEFAULT ((0)),
	[CreditorRemain] [money] NOT NULL CONSTRAINT [DF_TMPTransaction_CreditorRemain]  DEFAULT ((0)),
	[DebtorRemain] [money] NOT NULL CONSTRAINT [DF_TMPTransaction_Remain]  DEFAULT ((0)),
	[CurrencyRatioM] [money] NOT NULL CONSTRAINT [DF_TMPTransaction_CurrencyRatioM]  DEFAULT ((1)),	
	[Description] [nvarchar](max) NULL,
	[CurrencyRatioD] [money] NOT NULL CONSTRAINT [DF_TMPTransaction_CurrencyRatioD]  DEFAULT ((1)))


DECLARE @AccountRef int
DECLARE cursor_Customers  CURSOR LOCAL FOR  
SELECT AccountRef FROM Customers
OPEN cursor_Customers
FETCH NEXT FROM cursor_Customers INTO @AccountRef
WHILE @@FETCH_STATUS = 0   
BEGIN  

DECLARE @CurrenciesID int
DECLARE cursor_Currencies  CURSOR LOCAL FOR  
SELECT ID FROM Currencies
OPEN cursor_Currencies
FETCH NEXT FROM cursor_Currencies INTO @CurrenciesID
WHILE @@FETCH_STATUS = 0   
BEGIN  

DECLARE @SumCreditor money
SET @SumCreditor = (select Sum(Creditor) from [dbo].[Transaction]
where AccountRef=@AccountRef and CurrencyRef=@CurrenciesID)

DECLARE @SumDebtor money
SET @SumDebtor = (select Sum(Debtor) from [dbo].[Transaction]
where AccountRef=@AccountRef and CurrencyRef=@CurrenciesID)

DECLARE @Description nvarchar(100)
IF ((SELECT value FROM dbo.Cache WHERE name='software_language')=N'فارسی')
BEGIN
SET @Description = N'موجودی اولیه مشتری'
END
ELSE
BEGIN
SET @Description = N'بونی دەسپێک  کەس/کۆمپانیا'
END

DECLARE @DocHeaderID INT = (NEXT VALUE FOR dbo.DocIdSequence)
INSERT INTO [dbo].[DocHeader]([ID],[RefTable],[RefID],[Date])values(@DocHeaderID,38,(select ID from Customers where AccountRef=@AccountRef),'2022-01-01')

if(@SumCreditor - @SumDebtor) > 0
BEGIN

INSERT INTO [dbo].[TMPTransaction]
           ([Date],[TypeRef],[DocRef],[IDRef],[CodingRef],[AccountRef],[CurrencyRef],[Creditor],[Debtor],[CreditorRemain],[DebtorRemain],[CurrencyRatioM],[Description],[CurrencyRatioD])
Values('2022-01-01',44,@DocHeaderID,(select ID from Customers where AccountRef=@AccountRef),
		310105,@AccountRef,@CurrenciesID,abs(@SumCreditor - @SumDebtor),0,abs(@SumCreditor - @SumDebtor),0,1,@Description,1)
END

if(@SumDebtor - @SumCreditor) > 0
BEGIN

INSERT INTO [dbo].[TMPTransaction]
           ([Date],[TypeRef],[DocRef],[IDRef],[CodingRef],[AccountRef],[CurrencyRef],[Creditor],[Debtor],[CreditorRemain],[DebtorRemain],[CurrencyRatioM],[Description],[CurrencyRatioD])
Values('2022-01-01',44,@DocHeaderID,(select ID from Customers where AccountRef=@AccountRef),
		310105,@AccountRef,@CurrenciesID,0,abs(@SumDebtor - @SumCreditor),0,abs(@SumDebtor - @SumCreditor),1,@Description,1)
END

if(@SumDebtor - @SumCreditor) = 0
BEGIN

INSERT INTO [dbo].[TMPTransaction]
           ([Date],[TypeRef],[DocRef],[IDRef],[CodingRef],[AccountRef],[CurrencyRef],[Creditor],[Debtor],[CreditorRemain],[DebtorRemain],[CurrencyRatioM],[Description],[CurrencyRatioD])
Values('2022-01-01',44,@DocHeaderID,(select ID from Customers where AccountRef=@AccountRef),
		310105,@AccountRef,@CurrenciesID,0,0,0,0,1,@Description,1)
END

FETCH NEXT FROM cursor_Currencies INTO @CurrenciesID
END   

CLOSE cursor_Currencies
DEALLOCATE cursor_Currencies

FETCH NEXT FROM cursor_Customers INTO @AccountRef
END   

CLOSE cursor_Customers
DEALLOCATE cursor_Customers

------------------------------------------------------------

TRUNCATE TABLE dbo.FishPays 
TRUNCATE TABLE dbo.FishRecs 
TRUNCATE TABLE dbo.Cashs 
TRUNCATE TABLE dbo.BankActs
TRUNCATE TABLE dbo.BankMovements
TRUNCATE TABLE dbo.InOuts
TRUNCATE table InformationHistory 
TRUNCATE table dbo.log
TRUNCATE table dbo.Matching
DELETE FROM dbo.Wastages WHERE [Type] NOT IN (23) 
DELETE FROM CostusItems WHERE AmountRecive = Amount 
UPDATE CostusItems set Amount=AmountRecive, AmountRecive=0 WHERE AmountRecive>0  
DELETE FROM Costuses WHERE Completed=1                
DELETE FROM ChequePays where LastActRef <> 3 
DELETE FROM ChequeRecs where LastActRef  not in (7,13) 
UPDATE ChequePays set currentyear=1 where LastActRef=3 
UPDATE ChequeRecs set currentyear=1 where LastActRef in (7,13) 
IF EXISTS (SELECT * FROM sys.foreign_keys  WHERE object_id = OBJECT_ID(N'FK_ProductCardex_ProductItems') AND parent_object_id = OBJECT_ID(N'dbo.ProductCardex')) 
ALTER TABLE dbo.ProductCardex DROP CONSTRAINT FK_ProductCardex_ProductItems 
TRUNCATE TABLE dbo.ProductCardex 
TRUNCATE TABLE dbo.ProductItems 
ALTER TABLE [dbo].[ProductCardex] WITH CHECK ADD CONSTRAINT [FK_ProductCardex_ProductItems] FOREIGN KEY([ProductItemRef]) REFERENCES [dbo].[ProductItems] ([ID]) 
ALTER TABLE [dbo].[ProductCardex] CHECK CONSTRAINT [FK_ProductCardex_ProductItems]
IF EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'FK_FactorDetail_tbl_Fatcor_tbl') AND parent_object_id = OBJECT_ID(N'dbo.ProductItems'))
ALTER TABLE dbo.ProductItems DROP CONSTRAINT FK_FactorDetail_tbl_Fatcor_tbl 
TRUNCATE TABLE dbo.Factors 
ALTER TABLE [dbo].[ProductItems] WITH CHECK ADD CONSTRAINT [FK_FactorDetail_tbl_Fatcor_tbl] FOREIGN KEY([FactorRef]) REFERENCES [dbo].[Factors] ([ID])
ALTER TABLE [dbo].[ProductItems] CHECK CONSTRAINT [FK_FactorDetail_tbl_Fatcor_tbl] 
--DELETE FROM Assets WHERE (HaveBuySell=2 or HaveBuySell=3)
UPDATE Assets SET HaveBuySell=0, Amount=BuyAmount, BaseAmount= BaseBuyAmount, [Date]=BuyDate, DocID=DocIDBuy, 
CurrencyRef=BuyCurrencyRef, CurrencyRatioM=BuyCurrencyRatioM,CurrencyRatioD=BuyCurrencyRatioD,[Description]=BuyDescription
WHERE HaveBuySell=1 
DELETE FROM Assets WHERE HaveBuySell=0 and Name=(SELECT Name FROM Assets WHERE HaveBuySell=2)
DELETE FROM Assets WHERE HaveBuySell=2

--UPDATE dbo.BankAccounts SET FirstSupply=CurrentSupply
UPDATE dbo.Customers SET SumBuy = 0

UPDATE dbo.DetailAccounts SET [First] = Remain + 
            (SELECT ISNULL(SUM(Amount),0) FROM ChequePays WHERE LastActRef = 3 AND CustomerRef = DetailAccounts.RefID) -
            (SELECT ISNULL(SUM(Amount),0) FROM ChequeRecs WHERE LastActRef IN (7,13) AND CustomerRef= DetailAccounts.RefID)
WHERE RefTable=38 

UPDATE dbo.DetailAccounts SET [First] = Remain WHERE RefTable <> 38

UPDATE dbo.Products SET FirstValue=Value,FirstPurchasePrice= PurchasePrice,CurExpireDate=ExpireDate,CurPrice=PurchasePrice,CurValue=Value,ChangedPriceMode=0
--UPDATE dbo.CashBox SET FirstAmount=Amount
UPDATE dbo.Capitals SET CurrentYear=0, CapitalTransactionRef=1, CashBoxOrBankAccountTransactionRef=1
INSERT INTO dbo.ProductCardex ( Date ,RefTable ,RefID ,ProductRef ,IncDec ,Value     ,Fee                                ,Sum ,                                           ValueR ,    FeeR ,                             SumR  , CurrencyRef)
SELECT CONVERT(datetime2, @DateStart),1        ,ID    ,ID        ,1,       FirstValue, CAST(FirstPurchasePrice as money), CAST((FirstValue*FirstPurchasePrice) as money) ,FirstValue ,CAST(FirstPurchasePrice as money), CAST((FirstValue*FirstPurchasePrice) as money) , SellCurrencyRef  FROM dbo.Products Where ([type]=0 or [type] is null)
UPDATE dbo.Products SET CurIDCardex=(SELECT ID From ProductCardex Where  RefTable=1 AND RefID=dbo.Products.ID) Where ([type]=0 or [type] is null)
--UPDATE [dbo].[BankAccounts]  SET      [DocID] = NULL 
--UPDATE [dbo].[CashBox]  SET      [DocID] = NULL 
UPDATE [dbo].[BankMovements]  SET      [DocID] = NULL 
UPDATE [dbo].[BankActs]  SET      [DocID] = NULL 
--UPDATE [dbo].[Capitals]  SET      [DocID] = NULL 
UPDATE [dbo].[Cashs]  SET      [DocID] = NULL 
--UPDATE [dbo].[ChequePays]  SET      [DocID] = NULL 
--UPDATE [dbo].[ChequeRecs]  SET      [DocID2] = NULL 
--UPDATE [dbo].[ChequeRecs]  SET      [DocID] = NULL 
UPDATE [dbo].[ChequePays]  SET      CustomerTransactionRef = 1                                 
UPDATE [dbo].[ChequePays]  SET      BankAccountTransactionRef = NULL                                 
UPDATE [dbo].[ChequeRecs]  SET      CustomerTransactionRef = 1
UPDATE [dbo].[ChequeRecs]  SET      CashBoxTransactionRef = NULL
UPDATE [dbo].[ChequeRecs]  SET      VagozarbeBankTransactionRef = NULL
UPDATE [dbo].[ChequeRecs]  SET      VagozarbeShakhsTransactionRef = NULL
UPDATE [dbo].[FishPays]  SET      [DocID] = NULL 
UPDATE [dbo].[FishRecs]  SET      [DocID] = NULL 
UPDATE [dbo].[Assets]  SET      [DocID] = NULL 
UPDATE [dbo].[Assets]  SET      [DocIDSell] = NULL
UPDATE [dbo].[Assets]  SET      [DocIDBuy] = NULL
UPDATE [dbo].[Factors]  SET      [DocID] = NULL 
UPDATE [dbo].[InOuts]  SET      [DocID] = NULL 
UPDATE [dbo].[Wastages]  SET      [DocID] = NULL 	
					
DELETE FROM [dbo].[Transaction]
WHERE CodingRef NOT IN (310103,310104,310105)									
					               
DELETE FROM [dbo].[DocHeader] 
    WHERE ID NOT IN (SELECT DocID FROM [dbo].[Customers] CostusItems where DocID IS NOT NULL
					UNION SELECT DocID FROM [dbo].[CashBox] where DocID IS NOT NULL
					UNION SELECT DocID FROM [dbo].[BankAccounts] where DocID IS NOT NULL
                    UNION SELECT DocID FROM [dbo].[Costuses] where DocID IS NOT NULL
                    UNION SELECT DocID FROM [dbo].[CostusItems] where DocID IS NOT NULL
					UNION SELECT DocID FROM [dbo].[ChequePays] where LastActRef IN (3,15)
					UNION SELECT DocID FROM [dbo].[ChequeRecs] where LastActRef IN (7,13)
					UNION SELECT DocID FROM [dbo].[Capitals]
					UNION SELECT DocRef FROM [dbo].[Transaction] where CodingRef IN (310103,310104,310105)
					UNION SELECT DocRef FROM [dbo].[TMPTransaction] where TypeRef=44
					UNION SELECT DocRef FROM [dbo].[Transaction] where DocRef IN (SELECT DocID FROM Capitals))                    
                    
--UPDATE DetailAccounts SET [First]=Remain

--UPDATE [Transaction] SET Creditor = CASE WHEN (select DetailAccounts.[First] from DetailAccounts where DetailAccounts.ID=[Transaction].AccountRef)>0  THEN 
--(select DetailAccounts.[First] from DetailAccounts where DetailAccounts.ID=[Transaction].AccountRef) else 0 end
--UPDATE [Transaction] SET Debtor = CASE WHEN (select DetailAccounts.[First] from DetailAccounts where DetailAccounts.ID=[Transaction].AccountRef)<0  THEN 
--(select DetailAccounts.[First] *-1 from DetailAccounts where DetailAccounts.ID=[Transaction].AccountRef) else 0 end	
					
--UPDATE DetailAccounts SET Remain = 0

INSERT INTO [dbo].[Transaction]
        ([Date],[TypeRef],[DocRef],[CodingRef],[AccountRef],[CurrencyRef],[Creditor],[Debtor],[CreditorRemain],[DebtorRemain],[CurrencyRatioM],[Description],IDRef)
SELECT ExportDate,'36',DocID, '1103',CAST('110300000' AS int)+CustomerRef,
(SELECT CurrencyRef from dbo.CashBox where ID=1), 0, Amount, 0, 0, 0, CASE WHEN (select value from Cache where name='software_language')=N'فارسی' THEN N'چک پرداختی' else N'چەکی پێدان' end,ID
from ChequePays WHERE LastActRef IN (3)
                    
Update ChequePays set CustomerTransactionRef = (select ID from [Transaction] where TypeRef=36 AND DocRef=ChequePays.DocID 
AND CodingRef='1103' AND AccountRef='110300000'+ ChequePays.CustomerRef AND [Description]=CASE WHEN (select value from Cache where name='software_language')=N'فارسی' THEN N'چک پرداختی' else N'چەکی پێدان' end AND IDRef=ChequePays.ID)


INSERT INTO [dbo].[Transaction]
        ([Date],[TypeRef],[DocRef],[CodingRef],[AccountRef],[CurrencyRef],[Creditor],[Debtor],[CreditorRemain],[DebtorRemain],[CurrencyRatioM],[Description],IDRef)
SELECT ExportDate,'27',DocID, '1103',CAST('110300000' AS int)+CustomerRef,
(SELECT CurrencyRef from dbo.CashBox where ID=1), Amount, 0, 0, 0, 0, CASE WHEN (select value from Cache where name='software_language')=N'فارسی' THEN N'چک دریافتی' else N'چەکی وەرگیراو' end,ID
from ChequeRecs WHERE LastActRef IN (7)
                    
INSERT INTO [dbo].[Transaction]
        ([Date],[TypeRef],[DocRef],[CodingRef],[AccountRef],[CurrencyRef],[Creditor],[Debtor],[CreditorRemain],[DebtorRemain],[CurrencyRatioM],[Description],IDRef)
SELECT ExportDate,'27',DocID, '1103',CAST('110300000' AS int)+CustomerRef,
(SELECT CurrencyRef from dbo.CashBox where ID=1), Amount, 0, 0, 0, 0, CASE WHEN (select value from Cache where name='software_language')=N'فارسی' THEN N'چک دریافتی' else N'چەکی وەرگیراو' end,ID
from ChequeRecs WHERE LastActRef IN (13)
                    
INSERT INTO [dbo].[Transaction]
        ([Date],[TypeRef],[DocRef],[CodingRef],[AccountRef],[CurrencyRef],[Creditor],[Debtor],[CreditorRemain],[DebtorRemain],[CurrencyRatioM],[Description],IDRef)
SELECT ExportDate,'27',DocID, '1102',CAST('110200000' AS int)+VagozarbeBank,
(SELECT CurrencyRef from dbo.CashBox where ID=1), 0, 0, 0, 0, 0, CASE WHEN (select value from Cache where name='software_language')=N'فارسی' THEN N'چک دریافتی واگذار شده به بانک' else N'چەکی وه‏رگیراوی راسپاردراو به بانک' end, ID
from ChequeRecs WHERE LastActRef IN (13)
                    
Update ChequeRecs set CustomerTransactionRef = (select ID from [Transaction] where TypeRef=27 AND DocRef=ChequeRecs.DocID 
AND CodingRef='1103' AND AccountRef='110300000'+ ChequeRecs.CustomerRef AND [Description]=CASE WHEN (select value from Cache where name='software_language')=N'فارسی' THEN N'چک دریافتی' else N'چەکی وەرگیراو' end AND IDRef=ChequeRecs.ID)
                    
Update ChequeRecs set VagozarbeBankTransactionRef = (select ID from [Transaction] where TypeRef=27 AND DocRef=ChequeRecs.DocID 
AND CodingRef='1102' AND AccountRef='110200000'+ ChequeRecs.VagozarbeBank AND [Description]=CASE WHEN (select value from Cache where name='software_language')=N'فارسی' THEN N'چک دریافتی واگذار شده به بانک' else N'چەکی وه‏رگیراوی راسپاردراو به بانک' end AND IDRef=ChequeRecs.ID)
WHERE LastActRef=13

INSERT INTO [dbo].[Transaction]
([Date],[TypeRef],[DocRef],[CodingRef],[AccountRef],[CurrencyRef],[Creditor],[Debtor],[CreditorRemain],[DebtorRemain],[CurrencyRatioM],[Description],IDRef)
SELECT [Date],'31',DocID, '1101',CAST('110100000' AS int)+CashboxRef,
(SELECT CurrencyRef from dbo.CashBox where ID=CashBoxRef), Amount, 0, 0, 0, 0, CASE WHEN (select value from Cache where name='software_language')=N'فارسی' THEN N'واریز به صندوق' else N'ڕژاندن به سندوق' end, ID
from Capitals where CapitalActionRef=1

INSERT INTO [dbo].[Transaction]
		([Date],[TypeRef],[DocRef],[CodingRef],[AccountRef],[CurrencyRef],[Creditor],[Debtor],[CreditorRemain],[DebtorRemain],[CurrencyRatioM],[Description],IDRef)
SELECT [Date],'31',DocID, '1101',CAST('110100000' AS int)+CashboxRef,
(SELECT CurrencyRef from dbo.CashBox where ID=CashBoxRef), 0, Amount, 0, 0, 0, CASE WHEN (select value from Cache where name='software_language')=N'فارسی' THEN N'برداشت از صندوق' else N'هەڵگرتن له سندوق' end, ID
from Capitals where CapitalActionRef=2

INSERT INTO [dbo].[Transaction]
		([Date],[TypeRef],[DocRef],[CodingRef],[AccountRef],[CurrencyRef],[Creditor],[Debtor],[CreditorRemain],[DebtorRemain],[CurrencyRatioM],[Description],IDRef)
SELECT [Date],'30',DocID, '1102',CAST('110200000' AS int)+AccountRef,
(SELECT CurrencyRef from dbo.CashBox where ID=1), Amount, 0, 0, 0, 0, CASE WHEN (select value from Cache where name='software_language')=N'فارسی' THEN N'واریز به حساب' else N'ڕژاندن به حیساب' end, ID
from Capitals where CapitalActionRef=3

INSERT INTO [dbo].[Transaction]
		([Date],[TypeRef],[DocRef],[CodingRef],[AccountRef],[CurrencyRef],[Creditor],[Debtor],[CreditorRemain],[DebtorRemain],[CurrencyRatioM],[Description],IDRef)
SELECT [Date],'30',DocID, '1102',CAST('110200000' AS int)+AccountRef,
(SELECT CurrencyRef from dbo.CashBox where ID=1), 0, Amount, 0, 0, 0, CASE WHEN (select value from Cache where name='software_language')=N'فارسی' THEN N'برداشت از حساب' else N'هەڵگرتن له حیساب' end, ID
from Capitals where CapitalActionRef=4

Update Capitals set CapitalTransactionRef = (select ID from [Transaction] where TypeRef=31 
AND DocRef=Capitals.DocID AND CodingRef='1101' AND AccountRef='110100000'+ Capitals.CashBoxRef AND IDRef=Capitals.ID)
where CapitalActionRef=1 OR CapitalActionRef=2

Update Capitals set CapitalTransactionRef = (select ID from [Transaction] where TypeRef=30 
AND DocRef=Capitals.DocID AND CodingRef='1102' AND AccountRef='110200000'+ Capitals.AccountRef AND IDRef=Capitals.ID)
where CapitalActionRef=3 OR CapitalActionRef=4
					
Update Capitals set CashBoxOrBankAccountTransactionRef = (select ID from [Transaction] where TypeRef=31 
AND DocRef=Capitals.DocID AND CodingRef='1101' AND AccountRef='110100000'+ Capitals.CashBoxRef AND IDRef=Capitals.ID)
where CapitalActionRef=1 OR CapitalActionRef=2

Update Capitals set CashBoxOrBankAccountTransactionRef = (select ID from [Transaction] where TypeRef=30 
AND DocRef=Capitals.DocID AND CodingRef='1102' AND AccountRef='110200000'+ Capitals.AccountRef AND IDRef=Capitals.ID)
where CapitalActionRef=3 OR CapitalActionRef=4 	

DELETE FROM [dbo].[Transaction]
WHERE TypeRef=44

INSERT INTO [dbo].[Transaction]
           ([Date],[TypeRef],[DocRef],[IDRef],[CodingRef],[AccountRef],[CurrencyRef],[Creditor],[Debtor],[CreditorRemain],[DebtorRemain],[CurrencyRatioM],[Description],[CurrencyRatioD])
SELECT [Date],[TypeRef],[DocRef],[IDRef],[CodingRef],[AccountRef],[CurrencyRef],[Creditor],[Debtor],[CreditorRemain],[DebtorRemain],[CurrencyRatioM],[Description],[CurrencyRatioD] FROM [dbo].[TMPTransaction]

DROP TABLE [dbo].[TMPTransaction] 

UPDATE [dbo].[Customers] SET FirstTransactionRef = 
(SELECT TOP(1) ID FROM [dbo].[Transaction] WHERE TypeRef=44 AND IDRef=[dbo].[Customers].ID
AND (SELECT TOP(1) ID FROM [dbo].[Transaction] WHERE TypeRef=44 AND IDRef=[dbo].[Customers].ID) IS NOT NULL)												


DECLARE @ID int
DECLARE cursor_DetailAccounts  CURSOR LOCAL FOR  
SELECT ID FROM DetailAccounts
OPEN cursor_DetailAccounts
FETCH NEXT FROM cursor_DetailAccounts INTO @ID
WHILE @@FETCH_STATUS = 0   
BEGIN  

EXEC [dbo].[AccountFix]		  
		0
	, '2000-01-01'		
	,  @ID
	,  1
	,  0
	,  0
    

FETCH NEXT FROM cursor_DetailAccounts INTO @ID
END   

CLOSE cursor_DetailAccounts
DEALLOCATE cursor_DetailAccounts

commit transaction


DROP SEQUENCE AssetsIdSequence
DROP SEQUENCE BankAccountsIdSequence
DROP SEQUENCE BankActsIdSequence
DROP SEQUENCE BankMovementsIdSequence
DROP SEQUENCE CapitalsIdSequence
DROP SEQUENCE CashBoxIdSequence
DROP SEQUENCE CashsIdSequence
DROP SEQUENCE ChequePaysIdSequence
DROP SEQUENCE ChequeRecsIdSequence
DROP SEQUENCE CustomerIdSequence
DROP SEQUENCE DocIdSequence
DROP SEQUENCE FactorIdSequence
DROP SEQUENCE FishPaysIdSequence
DROP SEQUENCE FishRecsIdSequence
DROP SEQUENCE InOutsIdSequence
DROP SEQUENCE WastagesIdSequence


DECLARE @max int = 0;
declare @sql varchar(max)

Select @max = ISNULL(Max(ID)+1,1) from Assets
SET @sql ='CREATE SEQUENCE AssetsIdSequence as int START WITH ' + STR(@max) +' MINVALUE 1'
--PRINT @sql
exec(@sql)

Select @max = ISNULL(Max(ID)+1,1) from BankAccounts
SET @sql ='CREATE SEQUENCE BankAccountsIdSequence as int START WITH ' + STR(@max) +' MINVALUE 1'
--PRINT @sql
exec(@sql)

Select @max = ISNULL(Max(ID)+1,1) from BankActs
SET @sql ='CREATE SEQUENCE BankActsIdSequence as int START WITH ' + STR(@max) +' MINVALUE 1'
--PRINT @sql
exec(@sql)

Select @max = ISNULL(Max(ID)+1,1) from BankMovements
SET @sql ='CREATE SEQUENCE BankMovementsIdSequence as int START WITH ' + STR(@max) +' MINVALUE 1'
--PRINT @sql
exec(@sql)

Select @max = ISNULL(Max(ID)+1,1) from Capitals
SET @sql ='CREATE SEQUENCE CapitalsIdSequence as int START WITH ' + STR(@max) +' MINVALUE 1'
--PRINT @sql
exec(@sql)

Select @max = ISNULL(Max(ID)+1,1) from CashBox
SET @sql ='CREATE SEQUENCE CashBoxIdSequence as int START WITH ' + STR(@max) +' MINVALUE 1'
--PRINT @sql
exec(@sql)

Select @max = ISNULL(Max(ID)+1,1) from Cashs
SET @sql ='CREATE SEQUENCE CashsIdSequence as int START WITH ' + STR(@max) +' MINVALUE 1'
--PRINT @sql
exec(@sql)

Select @max = ISNULL(Max(ID)+1,1) from ChequePays
SET @sql ='CREATE SEQUENCE ChequePaysIdSequence as int START WITH ' + STR(@max) +' MINVALUE 1'
--PRINT @sql
exec(@sql)

Select @max = ISNULL(Max(ID)+1,1) from ChequeRecs
SET @sql ='CREATE SEQUENCE ChequeRecsIdSequence as int START WITH ' + STR(@max) +' MINVALUE 1'
--PRINT @sql
exec(@sql)

Select @max = ISNULL(Max(ID)+1,1) from Customers
SET @sql ='CREATE SEQUENCE CustomerIdSequence as int START WITH ' + STR(@max) +' MINVALUE 1'
--PRINT @sql
exec(@sql)

Select @max = ISNULL(Max(ID)+1,1) from DocHeader
SET @sql ='CREATE SEQUENCE DocIdSequence as int START WITH ' + STR(@max) +' MINVALUE 1'
--PRINT @sql
exec(@sql)

Select @max = ISNULL(Max(ID)+1,1) from Factors
SET @sql ='CREATE SEQUENCE FactorIdSequence as int START WITH ' + STR(@max) +' MINVALUE 1'
--PRINT @sql
exec(@sql)

Select @max = ISNULL(Max(ID)+1,1) from FishPays
SET @sql ='CREATE SEQUENCE FishPaysIdSequence as int START WITH ' + STR(@max) +' MINVALUE 1'
--PRINT @sql
exec(@sql)

Select @max = ISNULL(Max(ID)+1,1) from FishRecs
SET @sql ='CREATE SEQUENCE FishRecsIdSequence as int START WITH ' + STR(@max) +' MINVALUE 1'
--PRINT @sql
exec(@sql)

Select @max = ISNULL(Max(ID)+1,1) from InOuts
SET @sql ='CREATE SEQUENCE InOutsIdSequence as int START WITH ' + STR(@max) +' MINVALUE 1'
--PRINT @sql
exec(@sql)

Select @max = ISNULL(Max(ID)+1,1) from Wastages
SET @sql ='CREATE SEQUENCE WastagesIdSequence as int START WITH ' + STR(@max) +' MINVALUE 1'
--PRINT @sql
exec(@sql)

END

GO



UPDATE [dbo].[Cache]   SET [value] = '2.0.87'  Where name='VersionDatabase'