
----------------------------------------------------------

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[refresh_token]') AND type in (N'U'))
DROP TABLE [dbo].[refresh_token]
GO

----------------------------------------------------------

ALTER TABLE [dbo].[media] DROP CONSTRAINT [FK_138d7762e76b7fee9de6db0f8eb]
GO

----------------------------------------------------------

SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

CREATE TABLE [dbo].[roles](
	[id] [int] IDENTITY(1,1) NOT NULL,
	[role] [nvarchar](255) NOT NULL,
	[profileId] [int] NULL,
 CONSTRAINT [PK_c1433d71a4838793a49dcad46ab] PRIMARY KEY CLUSTERED 
(
	[id] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]
GO

ALTER TABLE [dbo].[roles] ADD  CONSTRAINT [DF_ccc7c1489f3a6b3c9b47d4537c5]  DEFAULT (N'ADMIN') FOR [role]
GO

ALTER TABLE [dbo].[roles]  WITH CHECK ADD  CONSTRAINT [FK_roles_Users] FOREIGN KEY([profileId])
REFERENCES [dbo].[Users] ([ID])
GO

ALTER TABLE [dbo].[roles] CHECK CONSTRAINT [FK_roles_Users]
GO

ALTER TABLE [dbo].[roles]  WITH CHECK ADD  CONSTRAINT [CHK_73c133adb37e71ee0432750852_ENUM] CHECK  (([role]='GUEST' OR [role]='ADMIN' OR [role]='MANAGER' OR [role]='CASHER' OR [role]='STOREKEEPER' OR [role]='VISITOR' OR [role]='CUSTOMER'))
GO

ALTER TABLE [dbo].[roles] CHECK CONSTRAINT [CHK_73c133adb37e71ee0432750852_ENUM]
GO

----------------------------------------------------------

BEGIN TRANSACTION
SET QUOTED_IDENTIFIER ON
SET ARITHABORT ON
SET NUMERIC_ROUNDABORT OFF
SET CONCAT_NULL_YIELDS_NULL ON
SET ANSI_NULLS ON
SET ANSI_PADDING ON
SET ANSI_WARNINGS ON
COMMIT
BEGIN TRANSACTION
GO
ALTER TABLE dbo.Users ADD
	name nvarchar(255) NOT NULL CONSTRAINT DF_Users_name_1 DEFAULT (''),
	email nvarchar(255) NOT NULL CONSTRAINT DF_Users_email_1 DEFAULT (''),
	avatar nvarchar(255) NULL,
	customerId int NULL
GO
ALTER TABLE dbo.Users SET (LOCK_ESCALATION = TABLE)
GO
COMMIT
select Has_Perms_By_Name(N'dbo.Users', 'Object', 'ALTER') as ALT_Per, Has_Perms_By_Name(N'dbo.Users', 'Object', 'VIEW DEFINITION') as View_def_Per, Has_Perms_By_Name(N'dbo.Users', 'Object', 'CONTROL') as Contr_Per 

----------------------------------------------------------

BEGIN TRANSACTION
SET QUOTED_IDENTIFIER ON
SET ARITHABORT ON
SET NUMERIC_ROUNDABORT OFF
SET CONCAT_NULL_YIELDS_NULL ON
SET ANSI_NULLS ON
SET ANSI_PADDING ON
SET ANSI_WARNINGS ON
COMMIT
BEGIN TRANSACTION
GO
ALTER TABLE dbo.media ADD
	idx int NULL,
	type varchar(50) NULL
GO
ALTER TABLE dbo.media SET (LOCK_ESCALATION = TABLE)
GO
COMMIT
select Has_Perms_By_Name(N'dbo.media', 'Object', 'ALTER') as ALT_Per, Has_Perms_By_Name(N'dbo.media', 'Object', 'VIEW DEFINITION') as View_def_Per, Has_Perms_By_Name(N'dbo.media', 'Object', 'CONTROL') as Contr_Per 

----------------------------------------------------------
INSERT INTO [dbo].[Users]
           ([UserName]
           ,[Password]
           ,[Active]
           ,[name]
           ,[email]
           ,[customerId])
SELECT 
      [email],[password],1,[username],[email],[customerID]
FROM [dbo].[user]

----------------------------------------------------------

INSERT INTO [dbo].[roles]
           ([role]
           ,[profileId])
     SELECT 
      'VISITOR',[ID]
FROM [dbo].[users] WHERE CustomerID is not null
GO

----------------------------------------------------------
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[user]') AND type in (N'U'))
 DROP TABLE [dbo].[user]
GO


SET IDENTITY_INSERT [dbo].[Users] ON

INSERT INTO [dbo].[Users]
           ([ID]
		   ,[UserName]
           ,[Password]
           ,[Description]
           ,[Active])
     VALUES
           (99,'visitor','','',0)

SET IDENTITY_INSERT [dbo].[Users] OFF
GO



UPDATE [dbo].[Cache]   SET [value] = '2.0.83'  Where name='VersionDatabase'
