﻿-- ProductCardex و Wastages جداول  CurrencyRef مقدار دهی ستون  

UPDATE dbo.ProductCardex SET RefTable=(SELECT TypeRef FROM dbo.Factors WHERE ProductCardex.RefID=ID)
WHERE ID IN(SELECT ID FROM ProductCardex
WHERE RefTable IN(2,3,4,5) AND NOT EXISTS (SELECT CurrencyRef FROM dbo.Factors WHERE dbo.ProductCardex.RefID = ID
AND  dbo.ProductCardex.RefTable = TypeRef))

GO

UPDATE dbo.Wastages SET CurrencyRef = 
(SELECT CurrencyRef FROM dbo.CashBox WHERE ID = 1)
WHERE CurrencyRef = 0 OR CurrencyRef IS NULL

GO

UPDATE dbo.ProductCardex SET CurrencyRef = 
(SELECT CurrencyRef FROM Wastages WHERE dbo.ProductCardex.RefID = ID
AND  dbo.ProductCardex.RefTable = [Type])
WHERE RefTable IN(20,21,22,23,24,25,26)

GO

UPDATE dbo.ProductCardex SET CurrencyRef = 
(SELECT CurrencyRef FROM dbo.CashBox WHERE ID = 1)
WHERE RefTable IN(1)

GO

UPDATE dbo.ProductCardex SET CurrencyRef = 
(SELECT CurrencyRef FROM factors WHERE dbo.ProductCardex.RefID = ID
AND  dbo.ProductCardex.RefTable = TypeRef)
WHERE RefTable IN(2,3,4,5,15,29)

GO

-- NULL مقدار دهی پیشفرض ستونهای 

-- BankAccounts اصلاح جدول 

ALTER TABLE dbo.BankAccounts ALTER COLUMN [Date] datetime2(7) NOT NULL

-- Cashs اصلاح جدول
GO

DECLARE @sql nvarchar(max)
SELECT @sql = 'ALTER TABLE Cashs DROP CONSTRAINT ' + df.NAME 
FROM sys.default_constraints df
  INNER JOIN sys.tables t ON df.parent_object_id = t.object_id
  INNER JOIN sys.columns c ON df.parent_object_id = c.object_id AND df.parent_column_id = c.column_id
where t.name = 'Cashs' and c.name = 'CashboxRef'
EXEC sp_executeSql @sql
--ALTER TABLE dbo.Cashs DROP CONSTRAINT DF__Cashs__CashboxRe__286302EC


-- ChequeRecs اصلاح جدول
GO
ALTER TABLE dbo.ChequeRecs DROP CONSTRAINT DF_ChequeRecs_CashBoxRef


-- Matching اصلاح جدول 
GO
DROP INDEX IX_Matching ON Matching
ALTER TABLE dbo.Matching ALTER COLUMN BuyDate datetime2(7) NOT NULL
CREATE INDEX IX_Matching ON Matching (BuyDate)
GO
DROP INDEX IX_Matching_1 ON Matching
ALTER TABLE dbo.Matching ALTER COLUMN SellDate datetime2(7) NOT NULL
CREATE INDEX IX_Matching_1 ON Matching (SellDate)
GO
ALTER TABLE dbo.Matching ALTER COLUMN [Matched] decimal(15, 2) NOT NULL
GO
ALTER TABLE dbo.Matching ALTER COLUMN BuyRemain decimal(15, 2) NOT NULL
GO
ALTER TABLE dbo.Matching ALTER COLUMN SellRemain decimal(15, 2) NOT NULL
GO
ALTER TABLE dbo.Matching ALTER COLUMN Fee money NOT NULL	


-- Costuses اصلاح جدول 
GO
DROP INDEX IX_Costuses ON Costuses
ALTER TABLE dbo.Costuses ALTER COLUMN StartDate datetime2(7) NOT NULL
CREATE INDEX IX_Costuses ON Costuses (StartDate)


-- CostusItems اصلاح جدول 
GO
ALTER TABLE dbo.CostusItems ALTER COLUMN ExpireDate datetime2(7) NOT NULL


-- FishPays اصلاح جدول 
GO

DECLARE @sql nvarchar(max)
SELECT @sql = 'ALTER TABLE FishPays DROP CONSTRAINT ' + df.NAME 
FROM sys.default_constraints df
  INNER JOIN sys.tables t ON df.parent_object_id = t.object_id
  INNER JOIN sys.columns c ON df.parent_object_id = c.object_id AND df.parent_column_id = c.column_id
where t.name = 'FishPays' and c.name = 'CashBoxRef'
EXEC sp_executeSql @sql

--ALTER TABLE dbo.FishPays DROP CONSTRAINT DF__FishPays__CashBo__451F3D2B


-- FishRecs اصلاح جدول 
GO
ALTER TABLE dbo.FishRecs ALTER COLUMN [Type] tinyint NOT NULL


-- InOuts اصلاح جدول 
GO
ALTER TABLE dbo.InOuts ALTER COLUMN CustomerTransactionRef INT NOT NULL
GO
UPDATE dbo.InOuts SET CurrencyRatio=1 WHERE CurrencyRatio IS NULL OR CurrencyRatio=0
GO
ALTER TABLE dbo.InOuts ALTER COLUMN CurrencyRatio money NOT NULL


-- ProductCardex اصلاح جدول 
GO
UPDATE dbo.ProductCardex SET CurrencyRef=(SELECT TOP(1) CurrencyRef FROM dbo.CashBox) WHERE CurrencyRef IS NULL
GO
ALTER TABLE dbo.ProductCardex ALTER COLUMN CurrencyRef INT NOT NULL
GO
ALTER TABLE dbo.ProductCardex ALTER COLUMN RefTable tinyint NOT NULL
GO
UPDATE dbo.ProductCardex SET CurrencyRefRatio=1 WHERE CurrencyRefRatio IS NULL
GO
ALTER TABLE dbo.ProductCardex ALTER COLUMN CurrencyRefRatio money NOT NULL
GO
DECLARE @sql nvarchar(max)
SELECT @sql = 'ALTER TABLE ProductCardex DROP CONSTRAINT ' + df.NAME 
FROM sys.default_constraints df
  INNER JOIN sys.tables t ON df.parent_object_id = t.object_id
  INNER JOIN sys.columns c ON df.parent_object_id = c.object_id AND df.parent_column_id = c.column_id
where t.name = 'ProductCardex' and c.name = 'CurrencyRefRatio'
EXEC sp_executeSql @sql
GO
ALTER TABLE dbo.ProductCardex ADD CONSTRAINT DF_ProductCardex_CurrencyRefRatio DEFAULT 1 FOR CurrencyRefRatio
GO
ALTER TABLE ProductCardex ADD CONSTRAINT FK_ProductCardex_Currencies FOREIGN KEY (CurrencyRef) REFERENCES Currencies(ID)


-- Wastages اصلاح جدول 
GO
ALTER TABLE dbo.Wastages ALTER COLUMN [Type] tinyint NOT NULL
GO
ALTER TABLE dbo.Wastages ALTER COLUMN CurrencyRef INT NOT NULL
GO
UPDATE dbo.Wastages SET CurrencyRatio=1 WHERE CurrencyRatio IS NULL OR CurrencyRatio=0
GO
ALTER TABLE dbo.Wastages ALTER COLUMN CurrencyRatio money NOT NULL
GO
DECLARE @sql nvarchar(max)
SELECT @sql = 'ALTER TABLE Wastages DROP CONSTRAINT ' + df.NAME 
FROM sys.default_constraints df
  INNER JOIN sys.tables t ON df.parent_object_id = t.object_id
  INNER JOIN sys.columns c ON df.parent_object_id = c.object_id AND df.parent_column_id = c.column_id
where t.name = 'Wastages' and c.name = 'Value'
EXEC sp_executeSql @sql
--ALTER TABLE dbo.Wastages DROP CONSTRAINT DF_Wastages_ThirdUnitValueGO

-- Products اصلاح جدول 
GO
ALTER TABLE dbo.Products ADD CONSTRAINT DF_Products_Rank DEFAULT 0 FOR [Rank]
GO
ALTER TABLE dbo.Products ADD CONSTRAINT DF_Products_ChangedPrice DEFAULT 0 FOR ChangedPrice
GO
ALTER TABLE dbo.Products ALTER COLUMN CurrencyRef INT NOT NULL


-- Factors اصلاح جدول 
GO
ALTER TABLE dbo.Factors ALTER COLUMN DeductionsSum money NOT NULL
GO
ALTER TABLE dbo.Factors ALTER COLUMN AdditionsSum money NOT NULL


-- CashBox اصلاح جدول 
GO
ALTER TABLE dbo.CashBox ALTER COLUMN [Date] datetime2(7) NOT NULL


-- Users اصلاح جدول 
UPDATE dbo.Users SET Active=0 WHERE Active IS NULL
GO
ALTER TABLE dbo.Users ALTER COLUMN Active INT NOT NULL
GO
ALTER TABLE dbo.Users ADD CONSTRAINT DF_Users_Active DEFAULT 0 FOR Active


-- DocHeader اصلاح جدول 
GO
ALTER TABLE dbo.DocHeader ALTER COLUMN [Date] datetime2(7) NOT NULL

GO

-- ChequePayActs اصلاح جدول 

ALTER TABLE dbo.ChequePayActs ALTER COLUMN [Date] datetime2(7) NOT NULL

GO

-- ChequeRecActs اصلاح جدول 

ALTER TABLE dbo.ChequeRecActs ALTER COLUMN [Date] datetime2(7) NOT NULL
GO
ALTER TABLE dbo.ChequeRecActs ALTER COLUMN ChequeActRef INT NOT NULL

GO

-- Products اصلاح نام واحد بر اساس ضریب واحد کالا در جدول

INSERT INTO dbo.ProductUnits(ProductRef,UnitName,UnitRatio,SalePrice)
SELECT ID,(SELECT TOP(1) Name FROM dbo.Units WHERE UnitRatio=1),(SELECT TOP(1) Ratio FROM dbo.Units WHERE UnitRatio=1),SalePrice FROM dbo.Products
WHERE dbo.Products.ID NOT IN (SELECT ProductRef FROM dbo.ProductUnits)

GO

UPDATE dbo.Products SET UnitRatio = 
(SELECT MIN(UnitRatio) FROM dbo.ProductUnits 
 WHERE dbo.Products.ID=dbo.ProductUnits.ProductRef)
 GO
UPDATE dbo.Products SET UnitName=
(SELECT TOP(1) UnitName FROM dbo.ProductUnits 
 WHERE dbo.Products.ID=dbo.ProductUnits.ProductRef AND dbo.Products.UnitRatio=dbo.ProductUnits.UnitRatio)

GO

--  مقدار دهی ارز پیشفرض در تنظیمات

IF ((SELECT value FROM dbo.Cache WHERE name='CurrencyDefualtID') IS NULL OR (SELECT value FROM dbo.Cache WHERE name='CurrencyDefualtID') = '0')
BEGIN
	INSERT INTO dbo.Cache Values('CurrencyDefualtID', (SELECT TOP(1) CurrencyRef FROM dbo.CashBox)) 
	INSERT INTO dbo.Cache Values('CurrencyDefualt', (SELECT Name FROM Currencies WHERE id=(SELECT TOP(1) CurrencyRef FROM dbo.CashBox)))
END

GO

UPDATE [dbo].[ProductCardex]
   SET [Date] = '2000-01-01 00:00:00.0000000'
 WHERE [RefTable]=1


GO

-- Cache جدول VersionDatabase آپدیت فیلد

UPDATE [dbo].[Cache]   SET [value] = '2.0.79'  Where name='VersionDatabase'