﻿

-- NULL مقدار دهی پیشفرض ستونهای 

-- Assets اصلاح جدول 

ALTER TABLE dbo.Assets ADD CONSTRAINT DF_Assets_CurrencyRatio DEFAULT 1 FOR CurrencyRatio
GO
ALTER TABLE dbo.Assets ADD CONSTRAINT DF_Assets_BuyCurrencyRatio DEFAULT 1 FOR BuyCurrencyRatio
GO
ALTER TABLE dbo.Assets ADD CONSTRAINT DF_Assets_SellCurrencyRatio DEFAULT 1 FOR SellCurrencyRatio

GO

UPDATE dbo.Assets SET HaveBuySell=0 WHERE HaveBuySell IS NULL
GO
ALTER TABLE dbo.Assets ALTER COLUMN HaveBuySell INT NOT NULL

GO

-- CurrencyHistory اصلاح جدول 

ALTER TABLE dbo.CurrencyHistory ADD CONSTRAINT DF_CurrencyHistory_Ratio DEFAULT 1 FOR Ratio

GO

-- InformationHistory اصلاح جدول 

DECLARE @sql nvarchar(max)
SELECT @sql = 'ALTER TABLE InformationHistory DROP CONSTRAINT ' + df.NAME 
FROM sys.default_constraints df
  INNER JOIN sys.tables t ON df.parent_object_id = t.object_id
  INNER JOIN sys.columns c ON df.parent_object_id = c.object_id AND df.parent_column_id = c.column_id
where t.name = 'InformationHistory' and c.name = 'Income'
EXEC sp_executeSql @sql
GO
ALTER TABLE dbo.InformationHistory ADD CONSTRAINT DF_InformationHistory_Income DEFAULT 0 FOR Income
GO
DECLARE @sql nvarchar(max)
SELECT @sql = 'ALTER TABLE InformationHistory DROP CONSTRAINT ' + df.NAME 
FROM sys.default_constraints df
  INNER JOIN sys.tables t ON df.parent_object_id = t.object_id
  INNER JOIN sys.columns c ON df.parent_object_id = c.object_id AND df.parent_column_id = c.column_id
where t.name = 'InformationHistory' and c.name = 'Outgo'
EXEC sp_executeSql @sql 
GO
ALTER TABLE dbo.InformationHistory ADD CONSTRAINT DF_InformationHistory_Outgo DEFAULT 0 FOR Outgo

GO

-- BankActs اصلاح جدول 

ALTER TABLE dbo.BankActs ADD CONSTRAINT DF_BankActs_Amount DEFAULT 0 FOR Amount
--DROP INDEX DocIDIndex ON BankActs
--ALTER TABLE dbo.BankActs ALTER COLUMN DocID INT NOT NULL
--CREATE INDEX DocIDIndex ON BankActs (DocID)

GO

-- BankAccounts اصلاح جدول 

--DROP INDEX DocIDIndex ON BankAccounts
--ALTER TABLE dbo.BankAccounts ALTER COLUMN DocID INT NOT NULL
--CREATE INDEX DocIDIndex ON BankAccounts (DocID)

GO

-- BankMovements اصلاح جدول 

ALTER TABLE dbo.BankMovements ADD CONSTRAINT DF_BankMovements_Amount DEFAULT 0 FOR Amount
--DROP INDEX DocIDIndex ON BankMovements
--ALTER TABLE dbo.BankMovements ALTER COLUMN DocID INT NOT NULL
--CREATE INDEX DocIDIndex ON BankMovements (DocID)

GO

-- Capitals اصلاح جدول 

ALTER TABLE dbo.Capitals ADD CONSTRAINT DF_Capitals_Amount DEFAULT 0 FOR Amount

GO

UPDATE dbo.Capitals SET CurrentYear=1 WHERE CurrentYear IS NULL
GO
ALTER TABLE dbo.Capitals ALTER COLUMN CurrentYear BIT NOT NULL

--DROP INDEX DocIDIndex ON Capitals
--ALTER TABLE dbo.Capitals ALTER COLUMN DocID INT NOT NULL
--CREATE INDEX DocIDIndex ON Capitals (DocID)

GO

-- Cashs اصلاح جدول 

ALTER TABLE dbo.Cashs ADD CONSTRAINT DF_Cashs_Amount DEFAULT 0 FOR Amount

GO

ALTER TABLE dbo.Cashs ADD CONSTRAINT DF_Cashs_CurrencyRatio DEFAULT 1 FOR CurrencyRatio

GO

UPDATE dbo.Cashs SET [type]=0 WHERE [type] IS NULL
GO
ALTER TABLE dbo.Cashs ALTER COLUMN [type] BIT NOT NULL

--DROP INDEX DocIDIndex ON Cashs
--ALTER TABLE dbo.Cashs ALTER COLUMN DocID INT NOT NULL
--CREATE INDEX DocIDIndex ON Cashs (DocID)

GO

-- ChequeActs اصلاح جدول 

UPDATE dbo.ChequeActs SET [Type]=1 WHERE [Type] IS NULL
GO
ALTER TABLE dbo.ChequeActs ALTER COLUMN [Type] BIT NOT NULL

GO

-- ChequePays اصلاح جدول 

ALTER TABLE dbo.ChequePays ADD CONSTRAINT DF_ChequePays_Amount DEFAULT 0 FOR Amount

GO

UPDATE dbo.ChequePays SET CurrentYear=1 WHERE CurrentYear IS NULL
GO
ALTER TABLE dbo.ChequePays ALTER COLUMN CurrentYear BIT NOT NULL

--DROP INDEX DocIDIndex ON ChequePays
--ALTER TABLE dbo.ChequePays ALTER COLUMN DocID INT NOT NULL
--CREATE INDEX DocIDIndex ON ChequePays (DocID)

GO

-- ChequeRecs اصلاح جدول 

ALTER TABLE dbo.ChequeRecs ADD CONSTRAINT DF_ChequeRecs_Amount DEFAULT 0 FOR Amount

GO

UPDATE dbo.ChequeRecs SET CurrentYear=1 WHERE CurrentYear IS NULL
GO
ALTER TABLE dbo.ChequeRecs ALTER COLUMN CurrentYear BIT NOT NULL

--DROP INDEX DocIDIndex ON ChequeRecs
--ALTER TABLE dbo.ChequeRecs ALTER COLUMN DocID INT NOT NULL
--CREATE INDEX DocIDIndex ON ChequeRecs (DocID)

GO

-- Matching اصلاح جدول 

DROP INDEX IX_Matching_2 ON Matching
ALTER TABLE dbo.Matching ALTER COLUMN ProductRef INT NOT NULL
CREATE INDEX IX_Matching_2 ON Matching (ProductRef)DROP INDEX IX_Matching_2 ON Matching
GO
ALTER TABLE dbo.Matching ALTER COLUMN BuyRef INT NOT NULL
GO
ALTER TABLE dbo.Matching ALTER COLUMN SellRef INT NOT NULL

GO

-- Costuses اصلاح جدول 

ALTER TABLE dbo.Costuses ADD CONSTRAINT DF_Costuses_Amount DEFAULT 0 FOR Amount

GO

UPDATE dbo.Costuses SET PeriodCount=1 WHERE PeriodCount IS NULL
GO
ALTER TABLE dbo.Costuses ALTER COLUMN PeriodCount INT NOT NULL
GO
ALTER TABLE dbo.Costuses ADD CONSTRAINT DF_Costuses_PeriodCount DEFAULT 1 FOR PeriodCount

--DROP INDEX DocIDIndex ON Costuses
--ALTER TABLE dbo.Costuses ALTER COLUMN DocID INT NOT NULL
--CREATE INDEX DocIDIndex ON Costuses (DocID)

GO

-- CostusItems اصلاح جدول 

ALTER TABLE dbo.CostusItems ADD CONSTRAINT DF_CostusItems_Amount DEFAULT 0 FOR Amount

GO

UPDATE dbo.CostusItems SET Recive=0 WHERE Recive IS NULL
GO
ALTER TABLE dbo.CostusItems ALTER COLUMN Recive BIT NOT NULL

--DROP INDEX DocIDIndex ON CostusItems
--ALTER TABLE dbo.CostusItems ALTER COLUMN DocID INT NOT NULL
--CREATE INDEX DocIDIndex ON CostusItems (DocID)

GO

-- Customers اصلاح جدول 

UPDATE dbo.Customers SET Active=1 WHERE Active IS NULL
GO
ALTER TABLE dbo.Customers ALTER COLUMN Active BIT NOT NULL
GO
ALTER TABLE dbo.Customers ADD CONSTRAINT DF_Customers_Active DEFAULT 1 FOR Active

GO

UPDATE dbo.Customers SET PerDayFactor=0 WHERE PerDayFactor IS NULL
GO
ALTER TABLE dbo.Customers ALTER COLUMN PerDayFactor BIT NOT NULL
GO
ALTER TABLE dbo.Customers ADD CONSTRAINT DF_Customers_PerDayFactor DEFAULT 0 FOR PerDayFactor

--ALTER TABLE dbo.Customers ALTER COLUMN DocID INT NOT NULL

GO

-- DetailAccounts اصلاح جدول 

ALTER TABLE dbo.DetailAccounts ADD CONSTRAINT DF_DetailAccounts_Creditor DEFAULT 0 FOR Creditor
GO
ALTER TABLE dbo.DetailAccounts ADD CONSTRAINT DF_DetailAccounts_Debtor DEFAULT 0 FOR Debtor

GO

-- FishPays اصلاح جدول 

ALTER TABLE dbo.FishPays ADD CONSTRAINT DF_FishPays_Amount DEFAULT 0 FOR Amount
--DROP INDEX DocIDIndex ON FishPays
--ALTER TABLE dbo.FishPays ALTER COLUMN DocID INT NOT NULL
--CREATE INDEX DocIDIndex ON FishPays (DocID)

GO

-- Markets اصلاح جدول 

ALTER TABLE dbo.Markets ADD CONSTRAINT DF_Markets_Buy DEFAULT 0 FOR Buy
ALTER TABLE dbo.Markets ADD CONSTRAINT DF_Markets_Sell DEFAULT 0 FOR Sell
ALTER TABLE dbo.Markets ALTER COLUMN [Auto] BIT NOT NULL

GO

-- FishRecs اصلاح جدول 

ALTER TABLE dbo.FishRecs ADD CONSTRAINT DF_FishRecs_Amount DEFAULT 0 FOR Amount
--DROP INDEX DocIDIndex ON FishRecs
--ALTER TABLE dbo.FishRecs ALTER COLUMN DocID INT NOT NULL
--CREATE INDEX DocIDIndex ON FishRecs (DocID)

GO

-- Transaction اصلاح جدول 

ALTER TABLE dbo.[Transaction] ADD CONSTRAINT DF_Transaction_Creditor DEFAULT 0 FOR Creditor
GO
ALTER TABLE dbo.[Transaction] ADD CONSTRAINT DF_Transaction_Debtor DEFAULT 0 FOR Debtor

GO

-- InOuts اصلاح جدول 

ALTER TABLE dbo.InOuts ADD CONSTRAINT DF_InOuts_Amount DEFAULT 0 FOR Amount

GO

ALTER TABLE dbo.InOuts ADD CONSTRAINT DF_InOuts_CurrencyRatio DEFAULT 1 FOR CurrencyRatio

GO

UPDATE dbo.InOuts SET SubRef=1 WHERE SubRef IS NULL
GO
ALTER TABLE dbo.InOuts ALTER COLUMN SubRef INT NOT NULL

GO

UPDATE dbo.InOuts SET [type]=1 WHERE [type] IS NULL
GO
ALTER TABLE dbo.InOuts ALTER COLUMN [type] BIT NOT NULL

--DROP INDEX DocIDIndex ON InOuts
--ALTER TABLE dbo.InOuts ALTER COLUMN DocID INT NOT NULL
--CREATE INDEX DocIDIndex ON InOuts (DocID)

GO

-- ProductItems اصلاح جدول 

ALTER TABLE dbo.ProductItems ADD CONSTRAINT DF_ProductItems_Value DEFAULT 0 FOR Value
GO
ALTER TABLE dbo.ProductItems ADD CONSTRAINT DF_ProductItems_Fee DEFAULT 0 FOR Fee
GO
ALTER TABLE dbo.ProductItems ADD CONSTRAINT DF_ProductItems_TotalPrice DEFAULT 0 FOR TotalPrice

GO

UPDATE ProductItems SET [Row] = x.RowNUMBER
FROM (SELECT ROW_NUMBER() OVER (PARTITION BY FactorRef ORDER BY id) AS RowNUMBER, ID
FROM productItems) x
WHERE x.ID = ProductItems.ID AND ProductItems.[Row] IS NULL
GO
ALTER TABLE dbo.ProductItems ALTER COLUMN [Row] INT NOT NULL
GO
ALTER TABLE dbo.ProductItems ADD CONSTRAINT DF_ProductItems_UnitRatio DEFAULT 1 FOR UnitRatio

GO

-- ProductCardex اصلاح جدول 

ALTER TABLE dbo.ProductCardex ADD CONSTRAINT DF_ProductCardex_Fee DEFAULT 0 FOR Fee
GO
ALTER TABLE dbo.ProductCardex ADD CONSTRAINT DF_ProductCardex_Sum DEFAULT 0 FOR [Sum]
GO
UPDATE dbo.ProductCardex SET RefID=1 WHERE RefID IS NULL
GO
ALTER TABLE dbo.ProductCardex ALTER COLUMN RefID INT NOT NULL
GO
ALTER TABLE dbo.ProductCardex ADD CONSTRAINT DF_ProductCardex_Value DEFAULT 0 FOR Value

GO

-- Wastages اصلاح جدول 

ALTER TABLE dbo.Wastages ADD CONSTRAINT DF_Wastages_Amount DEFAULT 0 FOR Amount
GO
ALTER TABLE dbo.Wastages ADD CONSTRAINT DF_Wastages_CurrencyRatio DEFAULT 1 FOR CurrencyRatio
GO
ALTER TABLE dbo.Wastages ADD CONSTRAINT DF_Wastages_UnitRatio DEFAULT 1 FOR UnitRatio

--DROP INDEX DocIDIndex ON Wastages
--ALTER TABLE dbo.Wastages ALTER COLUMN DocID INT NOT NULL
--CREATE INDEX DocIDIndex ON Wastages (DocID)

GO

-- Products اصلاح جدول 

ALTER TABLE dbo.Products ADD CONSTRAINT DF_Products_SalePrice DEFAULT 0 FOR SalePrice

GO

UPDATE dbo.Products SET OrderPoint=0 WHERE OrderPoint IS NULL
GO
ALTER TABLE dbo.Products ALTER COLUMN OrderPoint decimal(15, 2) NOT NULL

GO

UPDATE dbo.Products SET ProfitPercent=0 WHERE ProfitPercent IS NULL
GO
ALTER TABLE dbo.Products ALTER COLUMN ProfitPercent decimal(15, 2) NOT NULL
GO
ALTER TABLE dbo.Products ADD CONSTRAINT DF_Products_ProfitPercent DEFAULT 0 FOR ProfitPercent

GO

UPDATE dbo.Products SET LossPercent=0 WHERE LossPercent IS NULL
GO
ALTER TABLE dbo.Products ALTER COLUMN LossPercent decimal(15, 2) NOT NULL
GO
ALTER TABLE dbo.Products ADD CONSTRAINT DF_Products_LossPercent DEFAULT 0 FOR LossPercent

GO

UPDATE dbo.Products SET VisitorPercent=0 WHERE VisitorPercent IS NULL
GO
ALTER TABLE dbo.Products ALTER COLUMN VisitorPercent decimal(5, 2) NOT NULL

GO

UPDATE dbo.Products SET TaxPercent=0 WHERE TaxPercent IS NULL
GO
ALTER TABLE dbo.Products ALTER COLUMN TaxPercent decimal(5, 2) NOT NULL

GO

ALTER TABLE dbo.Products ADD CONSTRAINT DF_Products_Value DEFAULT 0 FOR Value
GO
ALTER TABLE dbo.Products ADD CONSTRAINT DF_Products_UnitRatio DEFAULT 1 FOR UnitRatio

GO

UPDATE dbo.Products SET OrderPointFlag=0 WHERE OrderPointFlag IS NULL
GO
ALTER TABLE dbo.Products ALTER COLUMN OrderPointFlag BIT NOT NULL
GO
ALTER TABLE dbo.Products ADD CONSTRAINT DF_Products_OrderPointFlag DEFAULT 0 FOR OrderPointFlag

GO

UPDATE dbo.Products SET Active=1 WHERE Active IS NULL
GO
ALTER TABLE dbo.Products ALTER COLUMN Active BIT NOT NULL
GO
ALTER TABLE dbo.Products ADD CONSTRAINT DF_Products_Active DEFAULT 1 FOR Active

GO

UPDATE dbo.Products SET Production=0 WHERE Production IS NULL
GO
ALTER TABLE dbo.Products ALTER COLUMN Production BIT NOT NULL
GO
ALTER TABLE dbo.Products ADD CONSTRAINT DF_Products_Production DEFAULT 0 FOR Production

GO

UPDATE dbo.Products SET ChangedPriceMode=0 WHERE ChangedPriceMode IS NULL
GO
ALTER TABLE dbo.Products ALTER COLUMN ChangedPriceMode BIT NOT NULL
GO
ALTER TABLE dbo.Products ADD CONSTRAINT DF_Products_ChangedPriceMode DEFAULT 0 FOR ChangedPriceMode

GO

-- Production اصلاح جدول 

ALTER TABLE dbo.Production ADD CONSTRAINT DF_Production_Value DEFAULT 0 FOR Value
GO
ALTER TABLE dbo.Production ADD CONSTRAINT DF_Production_UnitRatio DEFAULT 1 FOR UnitRatio

GO

-- ProductUnits اصلاح جدول 

ALTER TABLE dbo.ProductUnits ADD CONSTRAINT DF_ProductUnits_UnitRatio DEFAULT 1 FOR UnitRatio

GO

-- Units اصلاح جدول 

ALTER TABLE dbo.Units ADD CONSTRAINT DF_Units_Ratio DEFAULT 1 FOR Ratio

GO

-- Coding اصلاح جدول 

ALTER TABLE dbo.Coding ADD CONSTRAINT DF_Coding_First DEFAULT 0 FOR [First]
GO
ALTER TABLE dbo.Coding ADD CONSTRAINT DF_Coding_Bed DEFAULT 0 FOR Bed
GO
ALTER TABLE dbo.Coding ADD CONSTRAINT DF_Coding_Bes DEFAULT 0 FOR Bes
GO
ALTER TABLE dbo.Coding ADD CONSTRAINT DF_Coding_Remain DEFAULT 0 FOR Remain

GO

-- Factors اصلاح جدول 

ALTER TABLE dbo.Factors ADD CONSTRAINT DF_Factors_CurrencyRatio DEFAULT 1 FOR CurrencyRatio

GO

UPDATE dbo.Factors SET OwnerRef=(SELECT ID FROM dbo.Users WHERE ID=1) WHERE OwnerRef IS NULL
GO
ALTER TABLE dbo.Factors ALTER COLUMN OwnerRef INT NOT NULL

GO

UPDATE dbo.Factors SET IsTemp=0 WHERE IsTemp IS NULL
GO
ALTER TABLE dbo.Factors ALTER COLUMN IsTemp BIT NOT NULL
GO
ALTER TABLE dbo.Factors ADD CONSTRAINT DF_Factors_IsTemp DEFAULT 0 FOR IsTemp

GO

UPDATE dbo.Factors SET Settlement=0 WHERE Settlement IS NULL
GO
ALTER TABLE dbo.Factors ALTER COLUMN Settlement BIT NOT NULL
GO
ALTER TABLE dbo.Factors ADD CONSTRAINT DF_Factors_Settlement DEFAULT 0 FOR Settlement

--DROP INDEX DocIDIndex ON Factors
--ALTER TABLE dbo.Factors ALTER COLUMN DocID INT NOT NULL
--CREATE INDEX DocIDIndex ON Factors (DocID)

GO

-- CashBox اصلاح جدول 

--DROP INDEX DocIDIndex ON CashBox
--ALTER TABLE dbo.CashBox ALTER COLUMN DocID INT NOT NULL
--CREATE INDEX DocIDIndex ON CashBox (DocID)

GO

-- Cache جدول VersionDatabase آپدیت فیلد

UPDATE [dbo].[Cache]   SET [value] = '2.0.78'  Where name='VersionDatabase'

GO