﻿-- InOuts آپدیت جدول  

UPDATE InOuts SET CurrencyRef=(SELECT ID FROM Currencies WHERE Name = Currency)

GO

INSERT INTO [dbo].[Transaction]
           ([Date],[TypeRef],[DocRef],[CodingRef],[AccountRef],[CurrencyRef],[Creditor],[Debtor],[CreditorRemain],[DebtorRemain],[ToBaseCurrencyRatio],[Description],IDRef)
SELECT Date,'14',DocID, '1103',CAST('110300000' AS int)+CustomerRef, CurrencyRef, Amount, 0, 0, 0, 0,N'خه‌رج',ID
from InOuts WHERE [Type]=0

GO

INSERT INTO [dbo].[Transaction]
           ([Date],[TypeRef],[DocRef],[CodingRef],[AccountRef],[CurrencyRef],[Creditor],[Debtor],[CreditorRemain],[DebtorRemain],[ToBaseCurrencyRatio],[Description],IDRef)
SELECT Date,'13',DocID, '1103',CAST('110300000' AS int)+CustomerRef, CurrencyRef, 0, Amount, 0, 0, 0,N'داهات',ID
from InOuts WHERE [Type]=1

IF ((SELECT value FROM dbo.Cache WHERE name='software_language')=N'فارسی')
BEGIN

UPDATE dbo.[Transaction]  SET [Description] =  N'موجودی اولیه' WHERE [Description] = N'بونی دەسپێک'
UPDATE dbo.[Transaction]  SET [Description] = N'خرید اموال' WHERE [Description] = N'کڕینی ماڵ و دارایی'
UPDATE dbo.[Transaction]  SET [Description] = N'فروش اموال' WHERE [Description] = N'فرۆشی ماڵ و دارایی'
UPDATE dbo.[Transaction]  SET [Description] = N'برداشت از حساب و واریز به صندوق'   WHERE [Description] = N'هه‌ڵگرتن له حیساب و رژاندن به ده‌خل' 
UPDATE dbo.[Transaction]  SET [Description] = N'برداشت از صندوق و واریز به حساب'   WHERE [Description] = N'هه‌ڵگرتن له ده‌خل و رژاندن به حیساب'
UPDATE dbo.[Transaction]  SET [Description] = N'برداشت از حساب'	WHERE [Description] = N'هه‌ڵگرتن له حیساب'
UPDATE dbo.[Transaction]  SET [Description] = N'واریز به حساب' 	WHERE [Description] = N'ڕژاندن به حیساب' 
UPDATE dbo.[Transaction]  SET [Description] = N'واریز به صندوق' 	WHERE [Description] = N'ڕژاندن به سندوق' 
UPDATE dbo.[Transaction]  SET [Description] = N'برداشت از صندوق' 	WHERE [Description] = N'هەڵگرتن له سندوق'
UPDATE dbo.[Transaction]  SET [Description] = N'واریز به حساب' 	WHERE [Description] = N'ڕژاندن به حیساب' 
UPDATE dbo.[Transaction]  SET [Description] = N'برداشت از حساب'	WHERE [Description] = N'هەڵگرتن له حیساب'
UPDATE dbo.[Transaction]  SET [Description] = N'نقد های دریافتی' 	WHERE [Description] = N'وەرگرتنی نەقدی'                    
UPDATE dbo.[Transaction]  SET [Description] = N'نقد های پرداختی'	WHERE [Description] = N'پێدانی نه‌قدی'                      
UPDATE dbo.[Transaction]  SET [Description] = N'چک پرداختی' 	WHERE [Description] = N'چەکی پێدان'                              
UPDATE dbo.[Transaction]  SET [Description] = N'چک پرداختی وصول شده'	WHERE [Description] = N'چەکی پێدراوی وه‏ده‏ست هاتو'
UPDATE dbo.[Transaction]  SET [Description] = N'چک پرداختی برگشتی' 	WHERE [Description] = N'چەکی پێدراوی هه‌ڵگه‌ڕا‌وه'            
UPDATE dbo.[Transaction]  SET [Description] = N'چک پرداختی باطل شده'	WHERE [Description] = N'چەکی پێدراوی به‌تاڵ بوو'             
UPDATE dbo.[Transaction]  SET [Description] = N'چک دریافتی' 	WHERE [Description] = N'چەکی وەرگیراو'      
UPDATE dbo.[Transaction]  SET [Description] = N'چک دریافتی نقد شده'	WHERE [Description] = N'چەکی وه‏رگیراوی نه‌قد کراو'
UPDATE dbo.[Transaction]  SET [Description] = N'چک دریافتی برگشتی'	WHERE [Description] = N'چەکی وەرگیراوی هه‌ڵگه‌ڕا‌وە'        
UPDATE dbo.[Transaction]  SET [Description] = N'چک دریافتی باطل شده'	WHERE [Description] = N'چەکی وه‌رگیراوی به‌تاڵ بوو'
UPDATE dbo.[Transaction]  SET [Description] = N'چک دریافتی واگذارشده به شخص'	WHERE [Description] = N'چەکی وه رگیراوی راسپاردراو به که‌س'
UPDATE dbo.[Transaction]  SET [Description] = N'چک دریافتی واگذار شده به بانک'	WHERE [Description] = N'چەکی وه‏رگیراوی راسپاردراو به بانک'
UPDATE dbo.[Transaction]  SET [Description] = N'چک دریافتی وصول شده'	WHERE [Description] = N'چەکی وەرگیراوی وه‏دست هاتو'
UPDATE dbo.[Transaction]  SET [Description] = N'فاکتور فروش'	WHERE [Description] = N'وەسڵی فرۆش'   
UPDATE dbo.[Transaction]  SET [Description] = N'فاکتور خرید'	WHERE [Description] = N'وەسڵی کڕین'                          
UPDATE dbo.[Transaction]  SET [Description] = N'برگشت از فروش'	WHERE [Description] = N'گەڕانەوە له فرۆش'
UPDATE dbo.[Transaction]  SET [Description] = N'برگشت از خرید'	WHERE [Description] = N'گەڕانەوە له کڕین'                    
UPDATE dbo.[Transaction]  SET [Description] = N'بازاریاب'	WHERE [Description] = N'مەندوب'                 
UPDATE dbo.[Transaction]  SET [Description] = N'فیش های پرداختی'	WHERE [Description] = N'فیشەکانی پێدان'
UPDATE dbo.[Transaction]  SET [Description] = N'پرداخت کارتی'	WHERE [Description] = N'پێدان به کارت'                   
UPDATE dbo.[Transaction]  SET [Description] = N'دریافت کارتی'	WHERE [Description] = N'وه‏رگرتن به کارت'
UPDATE dbo.[Transaction]  SET [Description] = N'فیش های دریافتی'	WHERE [Description] = N'فیشی وەرگرتنی'
UPDATE dbo.[Transaction]  SET [Description] = N'هزینه'	WHERE [Description] = N'خه‌رج'            
UPDATE dbo.[Transaction]  SET [Description] = N'درآمد'	WHERE [Description] = N'داهات'

END

GO
ALTER TABLE InOuts ALTER COLUMN CurrencyRef INT NOT NULL
GO
DROP INDEX IX_InOuts ON InOuts
GO
ALTER TABLE InOuts ALTER COLUMN [Date] datetime2(7) NOT NULL
GO
CREATE INDEX IX_InOuts ON InOuts([Date])

GO
ALTER TABLE InOuts DROP COLUMN Currency
GO
ALTER TABLE InOuts ADD CONSTRAINT FK_InOuts_Currencies FOREIGN KEY (CurrencyRef) REFERENCES Currencies(ID)
GO

ALTER TABLE InOuts ADD CustomerTransactionRef INT NULL
GO
Update InOuts set CustomerTransactionRef = 
(select ID from [Transaction] where TypeRef=14 AND DocRef=InOuts.DocID AND AccountRef='110300000'+ InOuts.CustomerRef AND IDRef=InOuts.ID)
WHERE [Type]=0

GO

Update InOuts set CustomerTransactionRef = 
(select ID from [Transaction] where TypeRef=13 AND DocRef=InOuts.DocID AND AccountRef='110300000'+ InOuts.CustomerRef AND IDRef=InOuts.ID)
WHERE [Type]=1
GO
ALTER TABLE InOuts ADD CONSTRAINT FK_InOuts_Transaction1 FOREIGN KEY (CustomerTransactionRef) REFERENCES [Transaction](ID) 

GO

-- ID ستون Identity حذف 
/* To prevent any potential data loss issues, you should review this script in detail before running it outside the context of the database designer.*/
BEGIN TRANSACTION
SET QUOTED_IDENTIFIER ON
SET ARITHABORT ON
SET NUMERIC_ROUNDABORT OFF
SET CONCAT_NULL_YIELDS_NULL ON
SET ANSI_NULLS ON
SET ANSI_PADDING ON
SET ANSI_WARNINGS ON
COMMIT
BEGIN TRANSACTION
GO
ALTER TABLE dbo.InOuts
	DROP CONSTRAINT FK_InOuts_Coding
GO
ALTER TABLE dbo.Coding SET (LOCK_ESCALATION = TABLE)
GO
COMMIT
select Has_Perms_By_Name(N'dbo.Coding', 'Object', 'ALTER') as ALT_Per, Has_Perms_By_Name(N'dbo.Coding', 'Object', 'VIEW DEFINITION') as View_def_Per, Has_Perms_By_Name(N'dbo.Coding', 'Object', 'CONTROL') as Contr_Per BEGIN TRANSACTION
GO
ALTER TABLE dbo.InOuts
	DROP CONSTRAINT FK_InOuts_DocHeader
GO
ALTER TABLE dbo.InOuts
	DROP CONSTRAINT FK_InOutsDocIDIn_DocHeader
GO
ALTER TABLE dbo.DocHeader SET (LOCK_ESCALATION = TABLE)
GO
COMMIT
select Has_Perms_By_Name(N'dbo.DocHeader', 'Object', 'ALTER') as ALT_Per, Has_Perms_By_Name(N'dbo.DocHeader', 'Object', 'VIEW DEFINITION') as View_def_Per, Has_Perms_By_Name(N'dbo.DocHeader', 'Object', 'CONTROL') as Contr_Per BEGIN TRANSACTION
GO
ALTER TABLE dbo.InOuts
	DROP CONSTRAINT FK_InOuts_Products
GO
ALTER TABLE dbo.Products SET (LOCK_ESCALATION = TABLE)
GO
COMMIT
select Has_Perms_By_Name(N'dbo.Products', 'Object', 'ALTER') as ALT_Per, Has_Perms_By_Name(N'dbo.Products', 'Object', 'VIEW DEFINITION') as View_def_Per, Has_Perms_By_Name(N'dbo.Products', 'Object', 'CONTROL') as Contr_Per BEGIN TRANSACTION
GO
ALTER TABLE dbo.InOuts
	DROP CONSTRAINT FK_InOuts_Transaction1
GO
ALTER TABLE dbo.[Transaction] SET (LOCK_ESCALATION = TABLE)
GO
COMMIT
select Has_Perms_By_Name(N'dbo.[Transaction]', 'Object', 'ALTER') as ALT_Per, Has_Perms_By_Name(N'dbo.[Transaction]', 'Object', 'VIEW DEFINITION') as View_def_Per, Has_Perms_By_Name(N'dbo.[Transaction]', 'Object', 'CONTROL') as Contr_Per BEGIN TRANSACTION
GO
ALTER TABLE dbo.InOuts
	DROP CONSTRAINT FK_InOuts_Customers
GO
ALTER TABLE dbo.Customers SET (LOCK_ESCALATION = TABLE)
GO
COMMIT
select Has_Perms_By_Name(N'dbo.Customers', 'Object', 'ALTER') as ALT_Per, Has_Perms_By_Name(N'dbo.Customers', 'Object', 'VIEW DEFINITION') as View_def_Per, Has_Perms_By_Name(N'dbo.Customers', 'Object', 'CONTROL') as Contr_Per BEGIN TRANSACTION
GO
ALTER TABLE dbo.InOuts
	DROP CONSTRAINT FK_InOuts_Currencies
GO
ALTER TABLE dbo.Currencies SET (LOCK_ESCALATION = TABLE)
GO
COMMIT
select Has_Perms_By_Name(N'dbo.Currencies', 'Object', 'ALTER') as ALT_Per, Has_Perms_By_Name(N'dbo.Currencies', 'Object', 'VIEW DEFINITION') as View_def_Per, Has_Perms_By_Name(N'dbo.Currencies', 'Object', 'CONTROL') as Contr_Per BEGIN TRANSACTION
GO

DECLARE @sql nvarchar(max)
SELECT @sql = 'ALTER TABLE InOuts DROP CONSTRAINT ' + df.NAME 
FROM sys.default_constraints df
  INNER JOIN sys.tables t ON df.parent_object_id = t.object_id
  INNER JOIN sys.columns c ON df.parent_object_id = c.object_id AND df.parent_column_id = c.column_id
where t.name = 'InOuts' and c.name = 'RecPayAmount'
EXEC sp_executeSql @sql

GO

DECLARE @sql nvarchar(max)
SELECT @sql = 'ALTER TABLE InOuts DROP CONSTRAINT ' + df.NAME 
FROM sys.default_constraints df
  INNER JOIN sys.tables t ON df.parent_object_id = t.object_id
  INNER JOIN sys.columns c ON df.parent_object_id = c.object_id AND df.parent_column_id = c.column_id
where t.name = 'InOuts' and c.name = 'BaseAmount'
EXEC sp_executeSql @sql

GO

DECLARE @sql nvarchar(max)
SELECT @sql = 'ALTER TABLE InOuts DROP CONSTRAINT ' + df.NAME 
FROM sys.default_constraints df
  INNER JOIN sys.tables t ON df.parent_object_id = t.object_id
  INNER JOIN sys.columns c ON df.parent_object_id = c.object_id AND df.parent_column_id = c.column_id
where t.name = 'InOuts' and c.name = 'BaseRecPayAmount'
EXEC sp_executeSql @sql

GO
CREATE TABLE dbo.Tmp_InOuts
	(
	ID int NOT NULL,
	SubRef int NULL,
	Date datetime2(7) NOT NULL,
	Amount money NOT NULL,
	Description nvarchar(MAX) NULL,
	type bit NULL,
	RecPayAmount money NOT NULL,
	CustomerRef int NOT NULL,
	DocID int NULL,
	DocIDIn int NULL,
	ServiceRef int NULL,
	Count money NULL,
	CurrencyRef int NOT NULL,
	CurrencyRatio money NULL,
	BaseAmount money NOT NULL,
	BaseRecPayAmount money NOT NULL,
	CashID int NULL,
	CustomerTransactionRef int NULL
	)  ON [PRIMARY]
	 TEXTIMAGE_ON [PRIMARY]
GO
ALTER TABLE dbo.Tmp_InOuts SET (LOCK_ESCALATION = TABLE)
GO
ALTER TABLE dbo.Tmp_InOuts ADD CONSTRAINT
	DF__InOuts__RecPayAm__2610A626 DEFAULT ((0)) FOR RecPayAmount
GO
ALTER TABLE dbo.Tmp_InOuts ADD CONSTRAINT
	DF__InOuts__BaseAmou__4F9CCB9E DEFAULT ((0)) FOR BaseAmount
GO
ALTER TABLE dbo.Tmp_InOuts ADD CONSTRAINT
	DF__InOuts__BaseRecP__5090EFD7 DEFAULT ((0)) FOR BaseRecPayAmount
GO
IF EXISTS(SELECT * FROM dbo.InOuts)
	 EXEC('INSERT INTO dbo.Tmp_InOuts (ID, SubRef, Date, Amount, Description, type, RecPayAmount, CustomerRef, DocID, DocIDIn, ServiceRef, Count, CurrencyRef, CurrencyRatio, BaseAmount, BaseRecPayAmount, CashID, CustomerTransactionRef)
		SELECT ID, SubRef, Date, Amount, Description, type, RecPayAmount, CustomerRef, DocID, DocIDIn, ServiceRef, Count, CurrencyRef, CurrencyRatio, BaseAmount, BaseRecPayAmount, CashID, CustomerTransactionRef FROM dbo.InOuts WITH (HOLDLOCK TABLOCKX)')
GO
DROP TABLE dbo.InOuts
GO
EXECUTE sp_rename N'dbo.Tmp_InOuts', N'InOuts', 'OBJECT' 
GO
ALTER TABLE dbo.InOuts ADD CONSTRAINT
	PK_InCome_tbl PRIMARY KEY CLUSTERED 
	(
	ID
	) WITH( STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]

GO
CREATE NONCLUSTERED INDEX IX_InOuts ON dbo.InOuts
	(
	Date
	) WITH( STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX DocIDIndex ON dbo.InOuts
	(
	DocID
	) WITH( STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX IX_InOuts_1 ON dbo.InOuts
	(
	CustomerRef
	) WITH( STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
ALTER TABLE dbo.InOuts ADD CONSTRAINT
	FK_InOuts_Currencies FOREIGN KEY
	(
	CurrencyRef
	) REFERENCES dbo.Currencies
	(
	ID
	) ON UPDATE  NO ACTION 
	 ON DELETE  NO ACTION 
	
GO
ALTER TABLE dbo.InOuts ADD CONSTRAINT
	FK_InOuts_Customers FOREIGN KEY
	(
	CustomerRef
	) REFERENCES dbo.Customers
	(
	ID
	) ON UPDATE  NO ACTION 
	 ON DELETE  NO ACTION 
	
GO
ALTER TABLE dbo.InOuts ADD CONSTRAINT
	FK_InOuts_Transaction1 FOREIGN KEY
	(
	CustomerTransactionRef
	) REFERENCES dbo.[Transaction]
	(
	ID
	) ON UPDATE  NO ACTION 
	 ON DELETE  NO ACTION 
	
GO
ALTER TABLE dbo.InOuts ADD CONSTRAINT
	FK_InOuts_Products FOREIGN KEY
	(
	ServiceRef
	) REFERENCES dbo.Products
	(
	ID
	) ON UPDATE  NO ACTION 
	 ON DELETE  NO ACTION 
	
GO
ALTER TABLE dbo.InOuts ADD CONSTRAINT
	FK_InOuts_DocHeader FOREIGN KEY
	(
	DocID
	) REFERENCES dbo.DocHeader
	(
	ID
	) ON UPDATE  NO ACTION 
	 ON DELETE  NO ACTION 
	
GO
ALTER TABLE dbo.InOuts ADD CONSTRAINT
	FK_InOuts_Coding FOREIGN KEY
	(
	SubRef
	) REFERENCES dbo.Coding
	(
	AccountCode
	) ON UPDATE  NO ACTION 
	 ON DELETE  NO ACTION 
	
GO
ALTER TABLE dbo.InOuts ADD CONSTRAINT
	FK_InOutsDocIDIn_DocHeader FOREIGN KEY
	(
	DocIDIn
	) REFERENCES dbo.DocHeader
	(
	ID
	) ON UPDATE  NO ACTION 
	 ON DELETE  NO ACTION 
	
GO
COMMIT
select Has_Perms_By_Name(N'dbo.InOuts', 'Object', 'ALTER') as ALT_Per, Has_Perms_By_Name(N'dbo.InOuts', 'Object', 'VIEW DEFINITION') as View_def_Per, Has_Perms_By_Name(N'dbo.InOuts', 'Object', 'CONTROL') as Contr_Per 

GO

-- Parts آپدیت جدول  

ALTER TABLE Parts ALTER COLUMN Name nvarchar(300) NOT NULL

GO

-- ProductGroups آپدیت جدول  

ALTER TABLE ProductGroups ALTER COLUMN Name nvarchar(300) NOT NULL

GO

-- ProductSubs آپدیت جدول  

ALTER TABLE ProductSubs ALTER COLUMN Name nvarchar(300) NOT NULL

Go

-- ProductItems آپدیت جدول  

ALTER TABLE ProductItems ALTER COLUMN [ExpireDate] datetime2(7)

GO

-- Products آپدیت جدول  

ALTER TABLE Products ALTER COLUMN Name nvarchar(300) NOT NULL
ALTER TABLE Products ALTER COLUMN Code nvarchar(100)
ALTER TABLE Products ALTER COLUMN property3 nvarchar(200)
ALTER TABLE Products ALTER COLUMN property1 nvarchar(200)
ALTER TABLE Products ALTER COLUMN property2 nvarchar(200)
ALTER TABLE Products ALTER COLUMN StoreName nvarchar(100)
ALTER TABLE Products ALTER COLUMN Shelf nvarchar(100)
ALTER TABLE Products ALTER COLUMN [Floor] nvarchar(100)
ALTER TABLE Products ALTER COLUMN [Row] nvarchar(100)
ALTER TABLE Products ALTER COLUMN [Date] datetime2(7) NULL
ALTER TABLE Products ALTER COLUMN [ExpireDate] datetime2(7) NULL
ALTER TABLE Products ALTER COLUMN CurExpireDate datetime2(7) NULL
ALTER TABLE Products ALTER COLUMN DiscountEndDate datetime2(7) NULL

GO

-- ProductSubs آپدیت جدول  

ALTER TABLE ProductSubs ALTER COLUMN Name nvarchar(300) NOT NULL

GO

-- Units آپدیت جدول  

ALTER TABLE Units ALTER COLUMN Name nvarchar(200) NOT NULL

GO

-- Wastages آپدیت جدول  

UPDATE dbo.Wastages SET TypeDes=N'راستکردنەوە(کەم کردنی کۆگا)'
WHERE [Type]=22

GO

UPDATE dbo.Wastages SET TypeDes=N'راستکردنەوە(زیادکردنی کۆگا)'
WHERE [Type]=21

GO

UPDATE Wastages SET CurrencyRef=(SELECT ID FROM Currencies WHERE Name = Currency)
GO
ALTER TABLE Wastages ADD CONSTRAINT FK_Wastages_Currencies FOREIGN KEY (CurrencyRef) REFERENCES Currencies(ID)
GO
ALTER TABLE Wastages DROP COLUMN Currency

GO

DROP INDEX IX_Wastages ON Wastages
GO
ALTER TABLE Wastages ALTER COLUMN [Date] datetime2(7) NOT NULL
GO
CREATE INDEX IX_Wastages ON Wastages([Date]) 

GO

-- ID ستون Identity حذف 
/* To prevent any potential data loss issues, you should review this script in detail before running it outside the context of the database designer.*/
BEGIN TRANSACTION
SET QUOTED_IDENTIFIER ON
SET ARITHABORT ON
SET NUMERIC_ROUNDABORT OFF
SET CONCAT_NULL_YIELDS_NULL ON
SET ANSI_NULLS ON
SET ANSI_PADDING ON
SET ANSI_WARNINGS ON
COMMIT
BEGIN TRANSACTION
GO
ALTER TABLE dbo.Wastages
	DROP CONSTRAINT FK_Wastages_DocHeader
GO
ALTER TABLE dbo.DocHeader SET (LOCK_ESCALATION = TABLE)
GO
COMMIT
select Has_Perms_By_Name(N'dbo.DocHeader', 'Object', 'ALTER') as ALT_Per, Has_Perms_By_Name(N'dbo.DocHeader', 'Object', 'VIEW DEFINITION') as View_def_Per, Has_Perms_By_Name(N'dbo.DocHeader', 'Object', 'CONTROL') as Contr_Per BEGIN TRANSACTION
GO
ALTER TABLE dbo.Wastages
	DROP CONSTRAINT FK_Wastages_Currencies
GO
ALTER TABLE dbo.Currencies SET (LOCK_ESCALATION = TABLE)
GO
COMMIT
select Has_Perms_By_Name(N'dbo.Currencies', 'Object', 'ALTER') as ALT_Per, Has_Perms_By_Name(N'dbo.Currencies', 'Object', 'VIEW DEFINITION') as View_def_Per, Has_Perms_By_Name(N'dbo.Currencies', 'Object', 'CONTROL') as Contr_Per BEGIN TRANSACTION
GO
ALTER TABLE dbo.Wastages
	DROP CONSTRAINT FK_Wastage_tbl_Goods_tbl
GO
ALTER TABLE dbo.Products SET (LOCK_ESCALATION = TABLE)
GO
COMMIT
select Has_Perms_By_Name(N'dbo.Products', 'Object', 'ALTER') as ALT_Per, Has_Perms_By_Name(N'dbo.Products', 'Object', 'VIEW DEFINITION') as View_def_Per, Has_Perms_By_Name(N'dbo.Products', 'Object', 'CONTROL') as Contr_Per BEGIN TRANSACTION
GO

ALTER TABLE dbo.Wastages
	DROP CONSTRAINT DF_Wastages_ThirdUnitValue
GO

DECLARE @sql nvarchar(max)
SELECT @sql = 'ALTER TABLE Wastages DROP CONSTRAINT ' + df.NAME 
FROM sys.default_constraints df
  INNER JOIN sys.tables t ON df.parent_object_id = t.object_id
  INNER JOIN sys.columns c ON df.parent_object_id = c.object_id AND df.parent_column_id = c.column_id
where t.name = 'Wastages' and c.name = 'BaseAmount'
EXEC sp_executeSql @sql

GO
CREATE TABLE dbo.Tmp_Wastages
	(
	ID int NOT NULL,
	ProductRef int NOT NULL,
	Value decimal(15, 2) NOT NULL,
	Date datetime2(7) NOT NULL,
	Description nvarchar(MAX) NULL,
	Type tinyint NULL,
	Amount money NOT NULL,
	RefID int NULL,
	UnitName nvarchar(50) NOT NULL,
	UnitRatio decimal(15, 2) NOT NULL,
	DocID int NULL,
	CurrencyRef int NULL,
	CurrencyRatio money NULL,
	BaseAmount money NOT NULL,
	TypeDes nvarchar(255) NULL
	)  ON [PRIMARY]
	 TEXTIMAGE_ON [PRIMARY]
GO
ALTER TABLE dbo.Tmp_Wastages SET (LOCK_ESCALATION = TABLE)
GO
ALTER TABLE dbo.Tmp_Wastages ADD CONSTRAINT
	DF_Wastages_ThirdUnitValue DEFAULT ((0)) FOR Value
GO
ALTER TABLE dbo.Tmp_Wastages ADD CONSTRAINT
	DF__Wastages__BaseAm__51851410 DEFAULT ((0)) FOR BaseAmount
GO
IF EXISTS(SELECT * FROM dbo.Wastages)
	 EXEC('INSERT INTO dbo.Tmp_Wastages (ID, ProductRef, Value, Date, Description, Type, Amount, RefID, UnitName, UnitRatio, DocID, CurrencyRef, CurrencyRatio, BaseAmount, TypeDes)
		SELECT ID, ProductRef, Value, Date, Description, Type, Amount, RefID, UnitName, UnitRatio, DocID, CurrencyRef, CurrencyRatio, BaseAmount, TypeDes FROM dbo.Wastages WITH (HOLDLOCK TABLOCKX)')
GO
DROP TABLE dbo.Wastages
GO
EXECUTE sp_rename N'dbo.Tmp_Wastages', N'Wastages', 'OBJECT' 
GO
ALTER TABLE dbo.Wastages ADD CONSTRAINT
	PK_Wastage_tbl PRIMARY KEY CLUSTERED 
	(
	ID
	) WITH( STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]

GO
CREATE NONCLUSTERED INDEX IX_Wastages ON dbo.Wastages
	(
	Date
	) WITH( STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX DocIDIndex ON dbo.Wastages
	(
	DocID
	) WITH( STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX IX_Wastages_1 ON dbo.Wastages
	(
	ProductRef
	) WITH( STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
ALTER TABLE dbo.Wastages WITH NOCHECK ADD CONSTRAINT
	FK_Wastage_tbl_Goods_tbl FOREIGN KEY
	(
	ProductRef
	) REFERENCES dbo.Products
	(
	ID
	) ON UPDATE  NO ACTION 
	 ON DELETE  NO ACTION 
	
GO
ALTER TABLE dbo.Wastages ADD CONSTRAINT
	FK_Wastages_Currencies FOREIGN KEY
	(
	CurrencyRef
	) REFERENCES dbo.Currencies
	(
	ID
	) ON UPDATE  NO ACTION 
	 ON DELETE  NO ACTION 
	
GO
ALTER TABLE dbo.Wastages ADD CONSTRAINT
	FK_Wastages_DocHeader FOREIGN KEY
	(
	DocID
	) REFERENCES dbo.DocHeader
	(
	ID
	) ON UPDATE  NO ACTION 
	 ON DELETE  NO ACTION 
	
GO
COMMIT
select Has_Perms_By_Name(N'dbo.Wastages', 'Object', 'ALTER') as ALT_Per, Has_Perms_By_Name(N'dbo.Wastages', 'Object', 'VIEW DEFINITION') as View_def_Per, Has_Perms_By_Name(N'dbo.Wastages', 'Object', 'CONTROL') as Contr_Per 



