﻿-- Factors آپدیت جدول  

UPDATE Factors SET CurrencyRef=(SELECT ID FROM Currencies WHERE [Name] = Factors.Currency)
GO
UPDATE Factors SET CurrencyRef=(SELECT TOP(1) CurrencyRef FROM CashBox) WHERE CurrencyRef is NULL

GO
ALTER TABLE Factors ADD CONSTRAINT FK_Factors_Currencies FOREIGN KEY (CurrencyRef) REFERENCES Currencies(ID)

GO

INSERT INTO [dbo].[Transaction]
           ([Date],[TypeRef],[DocRef],[CodingRef],[AccountRef],[CurrencyRef],[Creditor],[Debtor],[CreditorRemain],[DebtorRemain],[ToBaseCurrencyRatio],[Description],IDRef)
SELECT [Date],'3',DocID, '1103',CAST('110300000' AS int)+CustomerRef, CurrencyRef, 0, RealSum, 0, 0, 0,N'وەسڵی فرۆش',ID
from Factors WHERE TypeRef=3

GO

INSERT INTO [dbo].[Transaction]
           ([Date],[TypeRef],[DocRef],[CodingRef],[AccountRef],[CurrencyRef],[Creditor],[Debtor],[CreditorRemain],[DebtorRemain],[ToBaseCurrencyRatio],[Description],IDRef)
SELECT [Date],'2',DocID, '1103',CAST('110300000' AS int)+CustomerRef, CurrencyRef, RealSum, 0, 0, 0, 0,N'وەسڵی کڕین',ID
from Factors WHERE TypeRef=2

GO

INSERT INTO [dbo].[Transaction]
           ([Date],[TypeRef],[DocRef],[CodingRef],[AccountRef],[CurrencyRef],[Creditor],[Debtor],[CreditorRemain],[DebtorRemain],[ToBaseCurrencyRatio],[Description],IDRef)
SELECT [Date],'4',DocID, '1103',CAST('110300000' AS int)+CustomerRef, CurrencyRef, RealSum, 0, 0, 0, 0,N'گەڕانەوە له فرۆش',ID
from Factors WHERE TypeRef=4

GO

INSERT INTO [dbo].[Transaction]
           ([Date],[TypeRef],[DocRef],[CodingRef],[AccountRef],[CurrencyRef],[Creditor],[Debtor],[CreditorRemain],[DebtorRemain],[ToBaseCurrencyRatio],[Description],IDRef)
SELECT [Date],'5',DocID, '1103',CAST('110300000' AS int)+CustomerRef, CurrencyRef, 0, RealSum, 0, 0, 0,N'گەڕانەوە له کڕین',ID
from Factors WHERE TypeRef=5

GO

INSERT INTO [dbo].[Transaction]
           ([Date],[TypeRef],[DocRef],[CodingRef],[AccountRef],[CurrencyRef],[Creditor],[Debtor],[CreditorRemain],[DebtorRemain],[ToBaseCurrencyRatio],[Description],IDRef)
SELECT [Date],'3',DocID, '1103',CAST('110300000' AS int)+VisitorRef, CurrencyRef, VisitorAmount, 0, 0, 0, 0,N'مەندوب',ID
from Factors WHERE TypeRef=3 AND VisitorRef IS NOT NULL

GO

INSERT INTO [dbo].[Transaction]
           ([Date],[TypeRef],[DocRef],[CodingRef],[AccountRef],[CurrencyRef],[Creditor],[Debtor],[CreditorRemain],[DebtorRemain],[ToBaseCurrencyRatio],[Description],IDRef)
SELECT [Date],'4',DocID, '1103',CAST('110300000' AS int)+VisitorRef, CurrencyRef, 0, VisitorAmount, 0, 0, 0,N'مەندوب',ID
from Factors WHERE TypeRef=4 AND VisitorRef IS NOT NULL

GO
ALTER TABLE Factors DROP COLUMN Currency
GO

Update Factors SET CurrencyRatio = (CASE WHEN CurrencyValue is not null THEN CurrencyValue else 1 end) 
ALTER TABLE Factors ALTER COLUMN CurrencyRatio money NOT NULL

GO

DECLARE @sql nvarchar(max)
SELECT @sql = 'ALTER TABLE Factors DROP CONSTRAINT ' + df.NAME 
FROM sys.default_constraints df
  INNER JOIN sys.tables t ON df.parent_object_id = t.object_id
  INNER JOIN sys.columns c ON df.parent_object_id = c.object_id AND df.parent_column_id = c.column_id
where t.name = 'Factors' and c.name = 'CurrencyValue'
EXEC sp_executeSql @sql
GO
ALTER TABLE Factors DROP COLUMN CurrencyValue

GO


ALTER TABLE Factors ADD CustomerTransactionRef INT NULL
GO
Update Factors set CustomerTransactionRef = (select ID from [Transaction] where TypeRef=Factors.TypeRef AND DocRef=Factors.DocID 
AND CodingRef='1103' AND AccountRef='110300000'+ Factors.CustomerRef AND [Description]<>N'مەندوب' AND IDRef=Factors.ID)
WHERE CustomerRef IS NOT NULL
GO
ALTER TABLE Factors ADD CONSTRAINT FK_Factors_Transaction FOREIGN KEY (CustomerTransactionRef) REFERENCES [Transaction](ID) 

GO

ALTER TABLE Factors ADD VisitorTransactionRef INT NULL
GO
Update Factors set VisitorTransactionRef = (select ID from [Transaction] where TypeRef=Factors.TypeRef AND DocRef=Factors.DocID 
AND CodingRef='1103' AND AccountRef='110300000'+ Factors.VisitorRef AND [Description]=N'مەندوب' AND IDRef=Factors.ID)
WHERE VisitorRef IS NOT NULL
GO
ALTER TABLE Factors ADD CONSTRAINT FK_Factors_Transaction1 FOREIGN KEY (VisitorTransactionRef) REFERENCES [Transaction](ID) 

GO

ALTER TABLE Factors ALTER COLUMN CurrencyRef INT NOT NULL

GO

DROP INDEX IX_FactorsDate ON Factors
GO
ALTER TABLE Factors ALTER COLUMN [Date] datetime2(7) NOT NULL
GO
CREATE INDEX IX_FactorsDate ON Factors([Date])

GO

DROP INDEX IX_FactorsTypeRef ON Factors
GO
ALTER TABLE Factors ALTER COLUMN TypeRef tinyint NOT NULL
GO
CREATE INDEX IX_FactorsTypeRef ON Factors(TypeRef)


GO

-- FishPays آپدیت جدول  

INSERT INTO [dbo].[DocHeader]([ID],[RefTable],[RefID],[Date],[Subject],[Bed],[Bes])
select ROW_NUMBER() OVER (ORDER BY FishPays.ID)+CASE WHEN (select top(1) ID from DocHeader order by ID DESC) IS NULL THEN 1 ELSE 
(select top(1) ID from DocHeader order by ID DESC) end,
 '11', ID, CASE WHEN [Date] is not null  THEN [Date] else '2000-01-01' end, CAST(FishPays.ID+FishPays.Amount AS NVARCHAR)+'FishPays', 0, 0
from FishPays WHERE DocID IS NULL

GO

update FishPays set docid = (select id from DocHeader where [Subject] = CAST(FishPays.ID+FishPays.Amount AS NVARCHAR)+'FishPays')
WHERE DocID IS NULL

GO

INSERT INTO [dbo].[Transaction]
           ([Date],[TypeRef],[DocRef],[CodingRef],[AccountRef],[CurrencyRef],[Creditor],[Debtor],[CreditorRemain],[DebtorRemain],[ToBaseCurrencyRatio],[Description],IDRef)
SELECT [Date],'11',DocID, '1103',CAST('110300000' AS int)+CustomerRef,
(SELECT CurrencyRef from dbo.CashBox where ID=1), 0, Amount, 0, 0, 0, N'فیشەکانی پێدان',ID
from FishPays

GO

INSERT INTO [dbo].[Transaction]
           ([Date],[TypeRef],[DocRef],[CodingRef],[AccountRef],[CurrencyRef],[Creditor],[Debtor],[CreditorRemain],[DebtorRemain],[ToBaseCurrencyRatio],[Description],IDRef)
SELECT [Date],'11',DocID, '1101',CAST('110100000' AS int)+CashBoxRef,
(SELECT CurrencyRef from dbo.CashBox where ID=1), 0, Amount, 0, 0, 0, N'فیشەکانی پێدان',ID
from FishPays

GO

ALTER TABLE FishPays ALTER COLUMN Serial nvarchar(100) NULL
ALTER TABLE FishPays ALTER COLUMN [Date] datetime2(7) NOT NULL
ALTER TABLE FishPays ALTER COLUMN BankName nvarchar(300) NULL
ALTER TABLE FishPays ALTER COLUMN AccountNumber nvarchar(200) NULL

GO


ALTER TABLE FishPays ADD CustomerTransactionRef INT NULL
GO
ALTER TABLE FishPays ADD CONSTRAINT FK_FishPays_Transaction1 FOREIGN KEY (CustomerTransactionRef) REFERENCES [Transaction](ID)
GO
ALTER TABLE FishPays ADD CashBoxTransactionRef INT NULL
GO
ALTER TABLE FishPays ADD CONSTRAINT FK_FishPays_Transaction FOREIGN KEY (CashBoxTransactionRef) REFERENCES [Transaction](ID)

GO

Update FishPays set CustomerTransactionRef = (select ID from [Transaction] where TypeRef=11 AND DocRef=FishPays.DocID 
AND CodingRef='1103' AND AccountRef='110300000'+ FishPays.CustomerRef AND IDRef=FishPays.ID)

GO

Update FishPays set CashBoxTransactionRef = (select ID from [Transaction] where TypeRef=11 AND DocRef=FishPays.DocID 
AND CodingRef='1101' AND AccountRef='110100000'+ FishPays.CashBoxRef AND IDRef=FishPays.ID)

GO

ALTER TABLE FishPays ALTER COLUMN CustomerTransactionRef INT NOT NULL
GO
ALTER TABLE FishPays ALTER COLUMN CashBoxTransactionRef INT NOT NULL

GO

-- FishRecs آپدیت جدول  

INSERT INTO [dbo].[DocHeader]([ID],[RefTable],[RefID],[Date],[Subject],[Bed],[Bes])
select ROW_NUMBER() OVER (ORDER BY FishRecs.ID)+CASE WHEN (select top(1) ID from DocHeader order by ID DESC) IS NULL THEN 1 ELSE 
(select top(1) ID from DocHeader order by ID DESC) end,
 '8', ID, CASE WHEN [Date] is not null  THEN [Date] else '2000-01-01' end, CAST(FishRecs.ID+FishRecs.Amount AS NVARCHAR)+'FishRecs', 0, 0
from FishRecs WHERE [Type]=8 AND DocID IS NULL

GO

INSERT INTO [dbo].[DocHeader]([ID],[RefTable],[RefID],[Date],[Subject],[Bed],[Bes])
select ROW_NUMBER() OVER (ORDER BY FishRecs.ID)+CASE WHEN (select top(1) ID from DocHeader order by ID DESC) IS NULL THEN 1 ELSE 
(select top(1) ID from DocHeader order by ID DESC) end,
 '9', ID, CASE WHEN [Date] is not null  THEN [Date] else '2000-01-01' end, CAST(FishRecs.ID+FishRecs.Amount AS NVARCHAR)+'FishRecs', 0, 0
from FishRecs WHERE [Type]=9 AND DocID IS NULL

GO

INSERT INTO [dbo].[DocHeader]([ID],[RefTable],[RefID],[Date],[Subject],[Bed],[Bes])
select ROW_NUMBER() OVER (ORDER BY FishRecs.ID)+CASE WHEN (select top(1) ID from DocHeader order by ID DESC) IS NULL THEN 1 ELSE 
(select top(1) ID from DocHeader order by ID DESC) end,
 '10', ID, CASE WHEN [Date] is not null  THEN [Date] else '2000-01-01' end, CAST(FishRecs.ID+FishRecs.Amount AS NVARCHAR)+'FishRecs', 0, 0
from FishRecs WHERE [Type]=10 AND DocID IS NULL

GO

update FishRecs set docid = (select id from DocHeader where [Subject] = CAST(FishRecs.ID+FishRecs.Amount AS NVARCHAR)+'FishRecs')
WHERE DocID IS NULL

GO

INSERT INTO [dbo].[Transaction]
           ([Date],[TypeRef],[DocRef],[CodingRef],[AccountRef],[CurrencyRef],[Creditor],[Debtor],[CreditorRemain],[DebtorRemain],[ToBaseCurrencyRatio],[Description],IDRef)
SELECT [Date],'8',DocID, '1103',CAST('110300000' AS int)+CustomerRef,
(SELECT CurrencyRef from dbo.CashBox where ID=1), 0, Amount, 0, 0, 0, N'پێدان به کارت',ID
from FishRecs WHERE [Type]=8

GO

INSERT INTO [dbo].[Transaction]
           ([Date],[TypeRef],[DocRef],[CodingRef],[AccountRef],[CurrencyRef],[Creditor],[Debtor],[CreditorRemain],[DebtorRemain],[ToBaseCurrencyRatio],[Description],IDRef)
SELECT [Date],'8',DocID, '1102',CAST('110200000' AS int)+AccountRef,
(SELECT CurrencyRef from dbo.CashBox where ID=1), 0, Amount, 0, 0, 0, N'پێدان به کارت',ID
from FishRecs WHERE [Type]=8

Go

INSERT INTO [dbo].[Transaction]
           ([Date],[TypeRef],[DocRef],[CodingRef],[AccountRef],[CurrencyRef],[Creditor],[Debtor],[CreditorRemain],[DebtorRemain],[ToBaseCurrencyRatio],[Description],IDRef)
SELECT [Date],'9',DocID, '1103',CAST('110300000' AS int)+CustomerRef,
(SELECT CurrencyRef from dbo.CashBox where ID=1), Amount, 0, 0, 0, 0, N'وه‏رگرتن به کارت',ID
from FishRecs WHERE [Type]=9

GO

INSERT INTO [dbo].[Transaction]
           ([Date],[TypeRef],[DocRef],[CodingRef],[AccountRef],[CurrencyRef],[Creditor],[Debtor],[CreditorRemain],[DebtorRemain],[ToBaseCurrencyRatio],[Description],IDRef)
SELECT [Date],'9',DocID, '1102',CAST('110200000' AS int)+AccountRef,
(SELECT CurrencyRef from dbo.CashBox where ID=1), Amount, 0, 0, 0, 0, N'وه‏رگرتن به کارت',ID
from FishRecs WHERE [Type]=9

GO

INSERT INTO [dbo].[Transaction]
           ([Date],[TypeRef],[DocRef],[CodingRef],[AccountRef],[CurrencyRef],[Creditor],[Debtor],[CreditorRemain],[DebtorRemain],[ToBaseCurrencyRatio],[Description],IDRef)
SELECT [Date],'10',DocID, '1103',CAST('110300000' AS int)+CustomerRef,
(SELECT CurrencyRef from dbo.CashBox where ID=1), Amount, 0, 0, 0, 0, N'فیشی وەرگرتنی',ID
from FishRecs WHERE [Type]=10

GO

INSERT INTO [dbo].[Transaction]
           ([Date],[TypeRef],[DocRef],[CodingRef],[AccountRef],[CurrencyRef],[Creditor],[Debtor],[CreditorRemain],[DebtorRemain],[ToBaseCurrencyRatio],[Description],IDRef)
SELECT [Date],'10',DocID, '1102',CAST('110200000' AS int)+AccountRef,
(SELECT CurrencyRef from dbo.CashBox where ID=1), Amount, 0, 0, 0, 0, N'فیشی وەرگرتنی',ID
from FishRecs WHERE [Type]=10

GO

ALTER TABLE FishRecs ALTER COLUMN Serial nvarchar(100) NULL
ALTER TABLE FishRecs ALTER COLUMN [Date] datetime2(7) NOT NULL

GO


ALTER TABLE FishRecs ADD CustomerTransactionRef INT NULL
GO
ALTER TABLE FishRecs ADD CONSTRAINT FK_FishRecs_Transaction1 FOREIGN KEY (CustomerTransactionRef) REFERENCES [Transaction](ID)
GO
ALTER TABLE FishRecs ADD BankAccountTransactionRef INT NULL
GO
ALTER TABLE FishRecs ADD CONSTRAINT FK_FishRecs_Transaction FOREIGN KEY (BankAccountTransactionRef) REFERENCES [Transaction](ID)

GO

Update FishRecs set CustomerTransactionRef = (select ID from [Transaction] where TypeRef=FishRecs.[Type] AND DocRef=FishRecs.DocID 
AND CodingRef='1103' AND AccountRef='110300000'+ FishRecs.CustomerRef AND IDRef=FishRecs.ID)

GO

Update FishRecs set BankAccountTransactionRef = (select ID from [Transaction] where TypeRef=FishRecs.[Type] AND DocRef=FishRecs.DocID 
AND CodingRef='1102' AND AccountRef='110200000'+ FishRecs.AccountRef AND IDRef=FishRecs.ID)

GO

ALTER TABLE FishRecs ALTER COLUMN CustomerTransactionRef INT NOT NULL
GO
ALTER TABLE FishRecs ALTER COLUMN BankAccountTransactionRef INT NOT NULL

GO



