﻿
-- Cashs  آپدیت جدول 

INSERT INTO [dbo].[DocHeader]([ID],[RefTable],[RefID],[Date],[Subject],[Bed],[Bes])
select ROW_NUMBER() OVER (ORDER BY Cashs.ID)+CASE WHEN (select top(1) ID from DocHeader order by ID DESC) IS NULL THEN 1 ELSE 
(select top(1) ID from DocHeader order by ID DESC) end,
 '3', ID, CASE WHEN [Date] is not null  THEN [Date] else '2000-01-01' end,CAST(Cashs.ID+Cashs.Amount AS NVARCHAR)+'Cashs',0,0
from Cashs WHERE [Type]=1 AND DocID IS NULL

GO

INSERT INTO [dbo].[DocHeader]([ID],[RefTable],[RefID],[Date],[Subject],[Bed],[Bes])
select ROW_NUMBER() OVER (ORDER BY Cashs.ID)+CASE WHEN (select top(1) ID from DocHeader order by ID DESC) IS NULL THEN 1 ELSE 
(select top(1) ID from DocHeader order by ID DESC) end,
 '2', ID, CASE WHEN [Date] is not null  THEN [Date] else '2000-01-01' end,CAST(Cashs.ID+Cashs.Amount AS NVARCHAR)+'Cashs',0,0
from Cashs WHERE [Type]=0 AND DocID IS NULL

GO

update Cashs set docid = (select id from DocHeader where [Subject] = CAST(Cashs.ID+Cashs.Amount AS NVARCHAR)+'Cashs')
WHERE DocID IS NULL

GO

INSERT INTO [dbo].[Transaction]
           ([Date],[TypeRef],[DocRef],[CodingRef],[AccountRef],[CurrencyRef],[Creditor],[Debtor],[CreditorRemain],[DebtorRemain],[ToBaseCurrencyRatio],[Description],IDRef)
SELECT [Date],'35',DocID, '1103',CAST('110300000' AS int)+CustomerRef,
(SELECT CurrencyRef from dbo.CashBox where ID=CashBoxRef), Amount, 0, 0, 0, 0, N'وەرگرتنی نەقدی',ID
from Cashs where Type=1

Go

INSERT INTO [dbo].[Transaction]
           ([Date],[TypeRef],[DocRef],[CodingRef],[AccountRef],[CurrencyRef],[Creditor],[Debtor],[CreditorRemain],[DebtorRemain],[ToBaseCurrencyRatio],[Description],IDRef)
SELECT [Date],'31',DocID, '1101',CAST('110100000' AS int)+CashboxRef,
(SELECT CurrencyRef from dbo.CashBox where ID=CashBoxRef), Amount, 0, 0, 0, 0, N'وەرگرتنی نەقدی',ID
from Cashs where Type=1

GO 

INSERT INTO [dbo].[Transaction]
           ([Date],[TypeRef],[DocRef],[CodingRef],[AccountRef],[CurrencyRef],[Creditor],[Debtor],[CreditorRemain],[DebtorRemain],[ToBaseCurrencyRatio],[Description],IDRef)
SELECT [Date],'35',DocID, '1103',CAST('110300000' AS int)+CustomerRef,
(SELECT CurrencyRef from dbo.CashBox where ID=CashBoxRef), 0, Amount, 0, 0, 0, N'پێدانی نه‌قدی',ID
from Cashs where Type=0

GO

INSERT INTO [dbo].[Transaction]
           ([Date],[TypeRef],[DocRef],[CodingRef],[AccountRef],[CurrencyRef],[Creditor],[Debtor],[CreditorRemain],[DebtorRemain],[ToBaseCurrencyRatio],[Description],IDRef)
SELECT [Date],'31',DocID, '1101',CAST('110100000' AS int)+CashboxRef,
(SELECT CurrencyRef from dbo.CashBox where ID=CashBoxRef), 0, Amount, 0, 0, 0, N'پێدانی نه‌قدی',ID
from Cashs where Type=0

GO

DROP INDEX IX_Cashs_1 ON Cashs
GO
ALTER TABLE Cashs ALTER COLUMN [Date] datetime2(7) NOT NULL
GO
CREATE INDEX IX_Cashs_1 ON Cashs([Date]) 
GO


ALTER TABLE Cashs ADD CurrencyRatio MONEY NULL
GO
UPDATE Cashs SET CurrencyRatio=1
GO
ALTER TABLE Cashs ALTER COLUMN CurrencyRatio MONEY NOT NULL
GO

ALTER TABLE Cashs ADD CustomerTransactionRef INT NULL
GO
Update Cashs set CustomerTransactionRef = (select ID from [Transaction] where TypeRef=35 AND DocRef=Cashs.DocID 
AND CodingRef='1103' AND AccountRef='110300000'+ Cashs.CustomerRef AND IDRef=Cashs.ID)
GO
ALTER TABLE Cashs ALTER COLUMN CustomerTransactionRef INT NOT NULL
GO
ALTER TABLE Cashs ADD CONSTRAINT FK_Customer_Transaction FOREIGN KEY (CustomerTransactionRef) REFERENCES [Transaction](ID)

GO

ALTER TABLE Cashs ADD CashBoxTransactionRef INT NULL
GO
Update Cashs set CashBoxTransactionRef = (select ID from [Transaction] where TypeRef=31 AND DocRef=Cashs.DocID 
AND CodingRef='1101' AND AccountRef='110100000'+ Cashs.CashboxRef AND IDRef=Cashs.ID)
GO
ALTER TABLE Cashs ALTER COLUMN CashBoxTransactionRef INT NOT NULL
GO
ALTER TABLE Cashs ADD CONSTRAINT FK_CashBox_Transactions FOREIGN KEY (CashBoxTransactionRef) REFERENCES [Transaction](ID)

GO

-- ID ستون Identity حذف 
/* To prevent any potential data loss issues, you should review this script in detail before running it outside the context of the database designer.*/
BEGIN TRANSACTION
SET QUOTED_IDENTIFIER ON
SET ARITHABORT ON
SET NUMERIC_ROUNDABORT OFF
SET CONCAT_NULL_YIELDS_NULL ON
SET ANSI_NULLS ON
SET ANSI_PADDING ON
SET ANSI_WARNINGS ON
COMMIT
BEGIN TRANSACTION
GO
ALTER TABLE dbo.Cashs
	DROP CONSTRAINT FK_Cashs_DocHeader
GO
ALTER TABLE dbo.DocHeader SET (LOCK_ESCALATION = TABLE)
GO
COMMIT
select Has_Perms_By_Name(N'dbo.DocHeader', 'Object', 'ALTER') as ALT_Per, Has_Perms_By_Name(N'dbo.DocHeader', 'Object', 'VIEW DEFINITION') as View_def_Per, Has_Perms_By_Name(N'dbo.DocHeader', 'Object', 'CONTROL') as Contr_Per BEGIN TRANSACTION
GO
ALTER TABLE dbo.Cashs
	DROP CONSTRAINT FK_Customer_Transaction
GO
ALTER TABLE dbo.Cashs
	DROP CONSTRAINT FK_CashBox_Transactions
GO
ALTER TABLE dbo.[Transaction] SET (LOCK_ESCALATION = TABLE)
GO
COMMIT
select Has_Perms_By_Name(N'dbo.[Transaction]', 'Object', 'ALTER') as ALT_Per, Has_Perms_By_Name(N'dbo.[Transaction]', 'Object', 'VIEW DEFINITION') as View_def_Per, Has_Perms_By_Name(N'dbo.[Transaction]', 'Object', 'CONTROL') as Contr_Per BEGIN TRANSACTION
GO
ALTER TABLE dbo.Cashs
	DROP CONSTRAINT FK_Cashs_CashBox
GO
ALTER TABLE dbo.CashBox SET (LOCK_ESCALATION = TABLE)
GO
COMMIT
select Has_Perms_By_Name(N'dbo.CashBox', 'Object', 'ALTER') as ALT_Per, Has_Perms_By_Name(N'dbo.CashBox', 'Object', 'VIEW DEFINITION') as View_def_Per, Has_Perms_By_Name(N'dbo.CashBox', 'Object', 'CONTROL') as Contr_Per BEGIN TRANSACTION
GO
ALTER TABLE dbo.Cashs
	DROP CONSTRAINT FK_Cash_Customer
GO
ALTER TABLE dbo.Customers SET (LOCK_ESCALATION = TABLE)
GO
COMMIT
select Has_Perms_By_Name(N'dbo.Customers', 'Object', 'ALTER') as ALT_Per, Has_Perms_By_Name(N'dbo.Customers', 'Object', 'VIEW DEFINITION') as View_def_Per, Has_Perms_By_Name(N'dbo.Customers', 'Object', 'CONTROL') as Contr_Per BEGIN TRANSACTION
GO

DECLARE @sql nvarchar(max)
SELECT @sql = 'ALTER TABLE Cashs DROP CONSTRAINT ' + df.NAME 
FROM sys.default_constraints df
  INNER JOIN sys.tables t ON df.parent_object_id = t.object_id
  INNER JOIN sys.columns c ON df.parent_object_id = c.object_id AND df.parent_column_id = c.column_id
where t.name = 'Cashs' and c.name = 'CashboxRef'
EXEC sp_executeSql @sql

GO

DECLARE @sql nvarchar(max)
SELECT @sql = 'ALTER TABLE Cashs DROP CONSTRAINT ' + df.NAME 
FROM sys.default_constraints df
  INNER JOIN sys.tables t ON df.parent_object_id = t.object_id
  INNER JOIN sys.columns c ON df.parent_object_id = c.object_id AND df.parent_column_id = c.column_id
where t.name = 'Cashs' and c.name = 'BaseAmount'
EXEC sp_executeSql @sql

GO
CREATE TABLE dbo.Tmp_Cashs
	(
	ID int NOT NULL,
	Description nvarchar(MAX) NULL,
	Date datetime2(7) NOT NULL,
	Amount money NOT NULL,
	CustomerRef int NOT NULL,
	type bit NULL,
	CashboxRef int NOT NULL,
	DocID int NULL,
	BaseAmount money NOT NULL,
	CurrencyRatio money NOT NULL,
	CustomerTransactionRef int NOT NULL,
	CashBoxTransactionRef int NOT NULL
	)  ON [PRIMARY]
	 TEXTIMAGE_ON [PRIMARY]
GO
ALTER TABLE dbo.Tmp_Cashs SET (LOCK_ESCALATION = TABLE)
GO
ALTER TABLE dbo.Tmp_Cashs ADD CONSTRAINT
	DF__Cashs__CashboxRe__286302EC DEFAULT ((1)) FOR CashboxRef
GO
ALTER TABLE dbo.Tmp_Cashs ADD CONSTRAINT
	DF__Cashs__BaseAmoun__52793849 DEFAULT ((0)) FOR BaseAmount
GO
IF EXISTS(SELECT * FROM dbo.Cashs)
	 EXEC('INSERT INTO dbo.Tmp_Cashs (ID, Description, Date, Amount, CustomerRef, type, CashboxRef, DocID, BaseAmount, CurrencyRatio, CustomerTransactionRef, CashBoxTransactionRef)
		SELECT ID, Description, Date, Amount, CustomerRef, type, CashboxRef, DocID, BaseAmount, CurrencyRatio, CustomerTransactionRef, CashBoxTransactionRef FROM dbo.Cashs WITH (HOLDLOCK TABLOCKX)')
GO
DROP TABLE dbo.Cashs
GO
EXECUTE sp_rename N'dbo.Tmp_Cashs', N'Cashs', 'OBJECT' 
GO
ALTER TABLE dbo.Cashs ADD CONSTRAINT
	PK_CashRec_tbl PRIMARY KEY CLUSTERED 
	(
	ID
	) WITH( STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]

GO
CREATE NONCLUSTERED INDEX IX_Cashs_1 ON dbo.Cashs
	(
	Date
	) WITH( STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX DocIDIndex ON dbo.Cashs
	(
	DocID
	) WITH( STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX IX_Cashs_2 ON dbo.Cashs
	(
	CustomerRef
	) WITH( STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
ALTER TABLE dbo.Cashs WITH NOCHECK ADD CONSTRAINT
	FK_Cash_Customer FOREIGN KEY
	(
	CustomerRef
	) REFERENCES dbo.Customers
	(
	ID
	) ON UPDATE  NO ACTION 
	 ON DELETE  NO ACTION 
	
GO
ALTER TABLE dbo.Cashs ADD CONSTRAINT
	FK_Cashs_CashBox FOREIGN KEY
	(
	CashboxRef
	) REFERENCES dbo.CashBox
	(
	ID
	) ON UPDATE  NO ACTION 
	 ON DELETE  NO ACTION 
	
GO
ALTER TABLE dbo.Cashs ADD CONSTRAINT
	FK_Customer_Transaction FOREIGN KEY
	(
	CustomerTransactionRef
	) REFERENCES dbo.[Transaction]
	(
	ID
	) ON UPDATE  NO ACTION 
	 ON DELETE  NO ACTION 
	
GO
ALTER TABLE dbo.Cashs ADD CONSTRAINT
	FK_CashBox_Transactions FOREIGN KEY
	(
	CashBoxTransactionRef
	) REFERENCES dbo.[Transaction]
	(
	ID
	) ON UPDATE  NO ACTION 
	 ON DELETE  NO ACTION 
	
GO
ALTER TABLE dbo.Cashs ADD CONSTRAINT
	FK_Cashs_DocHeader FOREIGN KEY
	(
	DocID
	) REFERENCES dbo.DocHeader
	(
	ID
	) ON UPDATE  NO ACTION 
	 ON DELETE  NO ACTION 
	
GO
COMMIT
select Has_Perms_By_Name(N'dbo.Cashs', 'Object', 'ALTER') as ALT_Per, Has_Perms_By_Name(N'dbo.Cashs', 'Object', 'VIEW DEFINITION') as View_def_Per, Has_Perms_By_Name(N'dbo.Cashs', 'Object', 'CONTROL') as Contr_Per 


GO

-- ChequeActs آپدیت جدول 

ALTER TABLE ChequeActs ALTER COLUMN Name nvarchar(200) NOT NULL

GO

-- ChequePayActs آپدیت جدول 

ALTER TABLE ChequePayActs ALTER COLUMN [Date] datetime2(7)

GO

-- ChequePays آپدیت جدول 

INSERT INTO [dbo].[DocHeader]([ID],[RefTable],[RefID],[Date],[Subject],[Bed],[Bes])
select ROW_NUMBER() OVER (ORDER BY ChequePays.ID)+CASE WHEN (select top(1) ID from DocHeader order by ID DESC) IS NULL THEN 1 ELSE 
(select top(1) ID from DocHeader order by ID DESC) end,
 '36', ID, CASE WHEN ExportDate is not null  THEN ExportDate else '2000-01-01' end, CAST(ChequePays.ID+ChequePays.Amount AS NVARCHAR)+'ChequePays', 0, 0
from ChequePays WHERE DocID IS NULL

GO

update ChequePays set docid = (select id from DocHeader where [Subject] = CAST(ChequePays.ID+ChequePays.Amount AS NVARCHAR)+'ChequePays')
WHERE DocID IS NULL

GO

INSERT INTO [dbo].[Transaction]
           ([Date],[TypeRef],[DocRef],[CodingRef],[AccountRef],[CurrencyRef],[Creditor],[Debtor],[CreditorRemain],[DebtorRemain],[ToBaseCurrencyRatio],[Description],IDRef)
SELECT ExportDate,'36',DocID, '1103',CAST('110300000' AS int)+CustomerRef,
(SELECT CurrencyRef from dbo.CashBox where ID=1), 0, Amount, 0, 0, 0, N'چەکی پێدان',ID
from ChequePays WHERE LastActRef IN (3,15)

GO

INSERT INTO [dbo].[Transaction]
           ([Date],[TypeRef],[DocRef],[CodingRef],[AccountRef],[CurrencyRef],[Creditor],[Debtor],[CreditorRemain],[DebtorRemain],[ToBaseCurrencyRatio],[Description],IDRef)
SELECT ExportDate,'36',DocID, '1103',CAST('110300000' AS int)+CustomerRef,
(SELECT CurrencyRef from dbo.CashBox where ID=1), 0, Amount, 0, 0, 0, N'چەکی پێدان',ID
from ChequePays WHERE LastActRef IN (4)
GO
INSERT INTO [dbo].[Transaction]
           ([Date],[TypeRef],[DocRef],[CodingRef],[AccountRef],[CurrencyRef],[Creditor],[Debtor],[CreditorRemain],[DebtorRemain],[ToBaseCurrencyRatio],[Description],IDRef)
SELECT ExportDate,'36',DocID, '1102',CAST('110200000' AS int)+AccountRef,
(SELECT CurrencyRef from dbo.CashBox where ID=1), 0, Amount, 0, 0, 0, N'چەکی پێدراوی وه‏ده‏ست هاتو',ID
from ChequePays WHERE LastActRef IN (4)

GO

INSERT INTO [dbo].[Transaction]
           ([Date],[TypeRef],[DocRef],[CodingRef],[AccountRef],[CurrencyRef],[Creditor],[Debtor],[CreditorRemain],[DebtorRemain],[ToBaseCurrencyRatio],[Description],IDRef)
SELECT ExportDate,'36',DocID, '1103',CAST('110300000' AS int)+CustomerRef,
(SELECT CurrencyRef from dbo.CashBox where ID=1), 0, Amount, 0, 0, 0, N'چەکی پێدان',ID
from ChequePays WHERE LastActRef IN (5)
GO
INSERT INTO [dbo].[Transaction]
           ([Date],[TypeRef],[DocRef],[CodingRef],[AccountRef],[CurrencyRef],[Creditor],[Debtor],[CreditorRemain],[DebtorRemain],[ToBaseCurrencyRatio],[Description],IDRef)
SELECT ExportDate,'36',DocID, '1103',CAST('110300000' AS int)+CustomerRef,
(SELECT CurrencyRef from dbo.CashBox where ID=1), Amount, 0, 0, 0, 0, N'چەکی پێدراوی هه‌ڵگه‌ڕا‌وه‌',ID
from ChequePays WHERE LastActRef IN (5)

GO

INSERT INTO [dbo].[Transaction]
           ([Date],[TypeRef],[DocRef],[CodingRef],[AccountRef],[CurrencyRef],[Creditor],[Debtor],[CreditorRemain],[DebtorRemain],[ToBaseCurrencyRatio],[Description],IDRef)
SELECT ExportDate,'36',DocID, '1103',CAST('110300000' AS int)+CustomerRef,
(SELECT CurrencyRef from dbo.CashBox where ID=1), 0, Amount, 0, 0, 0, N'چەکی پێدان',ID
from ChequePays WHERE LastActRef IN (6)
GO
INSERT INTO [dbo].[Transaction]
           ([Date],[TypeRef],[DocRef],[CodingRef],[AccountRef],[CurrencyRef],[Creditor],[Debtor],[CreditorRemain],[DebtorRemain],[ToBaseCurrencyRatio],[Description],IDRef)
SELECT ExportDate,'36',DocID, '1103',CAST('110300000' AS int)+CustomerRef,
(SELECT CurrencyRef from dbo.CashBox where ID=1), Amount, 0, 0, 0, 0, N'چەکی پێدراوی به‌تاڵ بوو',ID
from ChequePays WHERE LastActRef IN (6)

GO

ALTER TABLE ChequePays ALTER COLUMN Serial nvarchar(100)

GO

DROP INDEX IX_ChequePays ON ChequePays
GO
ALTER TABLE ChequePays ALTER COLUMN CustomerRef INT NOT NULL
ALTER TABLE ChequePays ALTER COLUMN AccountRef INT NOT NULL
GO
CREATE INDEX IX_ChequePays ON ChequePays(CustomerRef)

GO

DROP INDEX IX_ChequePays_1 ON ChequePays
GO
ALTER TABLE ChequePays ALTER COLUMN ExportDate datetime2(7) NOT NULL
ALTER TABLE ChequePays ALTER COLUMN ExpireyDate datetime2(7) NOT NULL
GO
CREATE INDEX IX_ChequePays_1 ON ChequePays(ExportDate)

ALTER TABLE ChequePays ALTER COLUMN ToPerson nvarchar(200)

GO

ALTER TABLE ChequePays ADD CustomerTransactionRef INT NULL
GO
ALTER TABLE ChequePays ADD CONSTRAINT FK_ChequePays_Transaction1 FOREIGN KEY (CustomerTransactionRef) REFERENCES [Transaction](ID) 
GO
ALTER TABLE ChequePays ADD BankAccountTransactionRef INT NULL
GO
ALTER TABLE ChequePays ADD CONSTRAINT FK_ChequePays_Transaction FOREIGN KEY (BankAccountTransactionRef) REFERENCES [Transaction](ID) 
GO

Update ChequePays set CustomerTransactionRef = (select ID from [Transaction] where TypeRef=36 AND DocRef=ChequePays.DocID 
AND CodingRef='1103' AND AccountRef='110300000'+ ChequePays.CustomerRef AND [Description]=N'چەکی پێدان' AND IDRef=ChequePays.ID)

GO

Update ChequePays set BankAccountTransactionRef = (select ID from [Transaction] where TypeRef=36 AND DocRef=ChequePays.DocID 
AND CodingRef='1102' AND AccountRef='110200000'+ ChequePays.AccountRef AND [Description]=N'چەکی پێدراوی وه‏ده‏ست هاتو' AND IDRef=ChequePays.ID)
WHERE LastActRef=4

GO

Update ChequePays set CustomerTransactionRef = (select ID from [Transaction] where TypeRef=36 AND DocRef=ChequePays.DocID 
AND CodingRef='1103' AND AccountRef='110300000'+ ChequePays.CustomerRef AND [Description]=N'چەکی پێدراوی هه‌ڵگه‌ڕا‌وه‌' AND IDRef=ChequePays.ID)
WHERE LastActRef=5

GO

Update ChequePays set CustomerTransactionRef = (select ID from [Transaction] where TypeRef=36 AND DocRef=ChequePays.DocID 
AND CodingRef='1103' AND AccountRef='110300000'+ ChequePays.CustomerRef AND [Description]=N'چەکی پێدراوی به‌تاڵ بوو' AND IDRef=ChequePays.ID)
WHERE LastActRef=6

GO

ALTER TABLE ChequePays ALTER COLUMN CustomerTransactionRef INT NOT NULL

GO

-- ChequeRecActs آپدیت جدول 

ALTER TABLE ChequeRecActs ALTER COLUMN [Date] datetime2(7)

GO

-- ChequeRecs آپدیت جدول 

INSERT INTO [dbo].[DocHeader]([ID],[RefTable],[RefID],[Date],[Subject],[Bed],[Bes])
select ROW_NUMBER() OVER (ORDER BY ChequeRecs.ID)+CASE WHEN (select top(1) ID from DocHeader order by ID DESC) IS NULL THEN 1 ELSE 
(select top(1) ID from DocHeader order by ID DESC) end,
 '36', ID, CASE WHEN ExportDate is not null  THEN ExportDate else '2000-01-01' end, CAST(ChequeRecs.ID+ChequeRecs.Amount AS NVARCHAR)+'ChequeRecs', 0, 0
from ChequeRecs WHERE DocID IS NULL

GO

update ChequeRecs set docid = (select id from DocHeader where [Subject] = CAST(ChequeRecs.ID+ChequeRecs.Amount AS NVARCHAR)+'ChequeRecs')
WHERE DocID IS NULL

GO

INSERT INTO [dbo].[Transaction]
           ([Date],[TypeRef],[DocRef],[CodingRef],[AccountRef],[CurrencyRef],[Creditor],[Debtor],[CreditorRemain],[DebtorRemain],[ToBaseCurrencyRatio],[Description],IDRef)
SELECT ExportDate,'27',DocID, '1103',CAST('110300000' AS int)+CustomerRef,
(SELECT CurrencyRef from dbo.CashBox where ID=1), Amount, 0, 0, 0, 0, N'چەکی وەرگیراو',ID
from ChequeRecs WHERE LastActRef IN (7,16)

GO

INSERT INTO [dbo].[Transaction]
           ([Date],[TypeRef],[DocRef],[CodingRef],[AccountRef],[CurrencyRef],[Creditor],[Debtor],[CreditorRemain],[DebtorRemain],[ToBaseCurrencyRatio],[Description],IDRef)
SELECT ExportDate,'27',DocID, '1103',CAST('110300000' AS int)+CustomerRef,
(SELECT CurrencyRef from dbo.CashBox where ID=1), Amount, 0, 0, 0, 0, N'چەکی وەرگیراو',ID
from ChequeRecs WHERE LastActRef IN (8)
GO
INSERT INTO [dbo].[Transaction]
           ([Date],[TypeRef],[DocRef],[CodingRef],[AccountRef],[CurrencyRef],[Creditor],[Debtor],[CreditorRemain],[DebtorRemain],[ToBaseCurrencyRatio],[Description],IDRef)
SELECT ExportDate,'27',DocID, '1101',CAST('110100000' AS int)+CashBoxRef,
(SELECT CurrencyRef from dbo.CashBox where ID=1), Amount, 0, 0, 0, 0, N'چەکی وه‏رگیراوی نه‌قد کراو',ID
from ChequeRecs WHERE LastActRef IN (8)

GO

INSERT INTO [dbo].[Transaction]
           ([Date],[TypeRef],[DocRef],[CodingRef],[AccountRef],[CurrencyRef],[Creditor],[Debtor],[CreditorRemain],[DebtorRemain],[ToBaseCurrencyRatio],[Description],IDRef)
SELECT ExportDate,'27',DocID, '1103',CAST('110300000' AS int)+CustomerRef,
(SELECT CurrencyRef from dbo.CashBox where ID=1), Amount, 0, 0, 0, 0, N'چەکی وەرگیراو',ID
from ChequeRecs WHERE LastActRef IN (9)
GO
INSERT INTO [dbo].[Transaction]
           ([Date],[TypeRef],[DocRef],[CodingRef],[AccountRef],[CurrencyRef],[Creditor],[Debtor],[CreditorRemain],[DebtorRemain],[ToBaseCurrencyRatio],[Description],IDRef)
SELECT ExportDate,'27',DocID, '1103',CAST('110300000' AS int)+CustomerRef,
(SELECT CurrencyRef from dbo.CashBox where ID=1), 0, Amount, 0, 0, 0, N'چەکی وەرگیراوی هه‌ڵگه‌ڕا‌وە',ID
from ChequeRecs WHERE LastActRef IN (9)

GO

INSERT INTO [dbo].[Transaction]
           ([Date],[TypeRef],[DocRef],[CodingRef],[AccountRef],[CurrencyRef],[Creditor],[Debtor],[CreditorRemain],[DebtorRemain],[ToBaseCurrencyRatio],[Description],IDRef)
SELECT ExportDate,'27',DocID, '1103',CAST('110300000' AS int)+CustomerRef,
(SELECT CurrencyRef from dbo.CashBox where ID=1), Amount, 0, 0, 0, 0, N'چەکی وەرگیراو',ID
from ChequeRecs WHERE LastActRef IN (10)
GO
INSERT INTO [dbo].[Transaction]
           ([Date],[TypeRef],[DocRef],[CodingRef],[AccountRef],[CurrencyRef],[Creditor],[Debtor],[CreditorRemain],[DebtorRemain],[ToBaseCurrencyRatio],[Description],IDRef)
SELECT ExportDate,'27',DocID, '1103',CAST('110300000' AS int)+CustomerRef,
(SELECT CurrencyRef from dbo.CashBox where ID=1), 0, Amount, 0, 0, 0, N'چەکی وه‌رگیراوی به‌تاڵ بوو',ID
from ChequeRecs WHERE LastActRef IN (10)

GO

INSERT INTO [dbo].[Transaction]
           ([Date],[TypeRef],[DocRef],[CodingRef],[AccountRef],[CurrencyRef],[Creditor],[Debtor],[CreditorRemain],[DebtorRemain],[ToBaseCurrencyRatio],[Description],IDRef)
SELECT ExportDate,'27',DocID, '1103',CAST('110300000' AS int)+CustomerRef,
(SELECT CurrencyRef from dbo.CashBox where ID=1), Amount, 0, 0, 0, 0, N'چەکی وەرگیراو',ID
from ChequeRecs WHERE LastActRef IN (11,12)
GO
INSERT INTO [dbo].[Transaction]
           ([Date],[TypeRef],[DocRef],[CodingRef],[AccountRef],[CurrencyRef],[Creditor],[Debtor],[CreditorRemain],[DebtorRemain],[ToBaseCurrencyRatio],[Description],IDRef)
SELECT ExportDate,'27',DocID, '1103',CAST('110300000' AS int)+VagozarbeShakhs,
(SELECT CurrencyRef from dbo.CashBox where ID=1), 0, Amount, 0, 0, 0, N'چەکی وه رگیراوی راسپاردراو به که‌س',ID
from ChequeRecs WHERE LastActRef IN (11,12)

GO

INSERT INTO [dbo].[Transaction]
           ([Date],[TypeRef],[DocRef],[CodingRef],[AccountRef],[CurrencyRef],[Creditor],[Debtor],[CreditorRemain],[DebtorRemain],[ToBaseCurrencyRatio],[Description],IDRef)
SELECT ExportDate,'27',DocID, '1103',CAST('110300000' AS int)+CustomerRef,
(SELECT CurrencyRef from dbo.CashBox where ID=1), Amount, 0, 0, 0, 0, N'چەکی وەرگیراو',ID
from ChequeRecs WHERE LastActRef IN (13)
GO
INSERT INTO [dbo].[Transaction]
           ([Date],[TypeRef],[DocRef],[CodingRef],[AccountRef],[CurrencyRef],[Creditor],[Debtor],[CreditorRemain],[DebtorRemain],[ToBaseCurrencyRatio],[Description],IDRef)
SELECT ExportDate,'27',DocID, '1102',CAST('110200000' AS int)+VagozarbeBank,
(SELECT CurrencyRef from dbo.CashBox where ID=1), 0, 0, 0, 0, 0, N'چەکی وه‏رگیراوی راسپاردراو به بانک',ID
from ChequeRecs WHERE LastActRef IN (13)

GO

INSERT INTO [dbo].[Transaction]
           ([Date],[TypeRef],[DocRef],[CodingRef],[AccountRef],[CurrencyRef],[Creditor],[Debtor],[CreditorRemain],[DebtorRemain],[ToBaseCurrencyRatio],[Description],IDRef)
SELECT ExportDate,'27',DocID, '1103',CAST('110300000' AS int)+CustomerRef,
(SELECT CurrencyRef from dbo.CashBox where ID=1), Amount, 0, 0, 0, 0, N'چەکی وەرگیراو',ID
from ChequeRecs WHERE LastActRef IN (14)
GO
INSERT INTO [dbo].[Transaction]
           ([Date],[TypeRef],[DocRef],[CodingRef],[AccountRef],[CurrencyRef],[Creditor],[Debtor],[CreditorRemain],[DebtorRemain],[ToBaseCurrencyRatio],[Description],IDRef)
SELECT ExportDate,'27',DocID, '1102',CAST('110200000' AS int)+VagozarbeBank,
(SELECT CurrencyRef from dbo.CashBox where ID=1), Amount, 0, 0, 0, 0, N'چەکی وەرگیراوی وه‏دست هاتو',ID
from ChequeRecs WHERE LastActRef IN (14)

GO

ALTER TABLE ChequeRecs ALTER COLUMN Serial nvarchar(100)

GO
DROP INDEX IX_ChequeRecs_1 ON ChequeRecs
GO
ALTER TABLE ChequeRecs ALTER COLUMN ExportDate datetime2(7) NOT NULL
ALTER TABLE ChequeRecs ALTER COLUMN ExpireyDate datetime2(7) NOT NULL
GO
CREATE INDEX IX_ChequeRecs_1 ON ChequeRecs(ExportDate) 
GO

ALTER TABLE ChequeRecs ALTER COLUMN BankName nvarchar(200)
ALTER TABLE ChequeRecs ALTER COLUMN ToPerson nvarchar(200)
ALTER TABLE ChequeRecs ALTER COLUMN AccountNumber nvarchar(100)
ALTER TABLE ChequeRecs ALTER COLUMN AccountOwner nvarchar(100)

GO

ALTER TABLE ChequeRecs ADD CustomerTransactionRef INT NULL
GO
ALTER TABLE ChequeRecs ADD CONSTRAINT FK_ChequeRecs_Transaction1 FOREIGN KEY (CustomerTransactionRef) REFERENCES [Transaction](ID) 
GO
ALTER TABLE ChequeRecs ADD CashBoxTransactionRef INT NULL
GO
ALTER TABLE ChequeRecs ADD CONSTRAINT FK_ChequeRecs_Transaction FOREIGN KEY (CashBoxTransactionRef) REFERENCES [Transaction](ID) 
GO
ALTER TABLE ChequeRecs ADD VagozarbeBankTransactionRef INT NULL
GO
ALTER TABLE ChequeRecs ADD CONSTRAINT FK_ChequeRecs_Transaction2 FOREIGN KEY (VagozarbeBankTransactionRef) REFERENCES [Transaction](ID) 
GO
ALTER TABLE ChequeRecs ADD VagozarbeShakhsTransactionRef INT NULL
GO
ALTER TABLE ChequeRecs ADD CONSTRAINT FK_ChequeRecs_Transaction3 FOREIGN KEY (VagozarbeShakhsTransactionRef) REFERENCES [Transaction](ID) 
GO

Update ChequeRecs set CustomerTransactionRef = (select ID from [Transaction] where TypeRef=27 AND DocRef=ChequeRecs.DocID 
AND CodingRef='1103' AND AccountRef='110300000'+ ChequeRecs.CustomerRef AND [Description]=N'چەکی وەرگیراو' AND IDRef=ChequeRecs.ID)

GO

Update ChequeRecs set CashBoxTransactionRef = (select ID from [Transaction] where TypeRef=27 AND DocRef=ChequeRecs.DocID 
AND CodingRef='1101' AND AccountRef='110100000'+ ChequeRecs.CashBoxRef AND [Description]=N'چەکی وه‏رگیراوی نه‌قد کراو' AND IDRef=ChequeRecs.ID)
WHERE LastActRef=8

GO

Update ChequeRecs set VagozarbeBankTransactionRef = (select ID from [Transaction] where TypeRef=27 AND DocRef=ChequeRecs.DocID 
AND CodingRef='1102' AND AccountRef='110200000'+ ChequeRecs.VagozarbeBank AND [Description]=N'چەکی وه‏رگیراوی راسپاردراو به بانک' AND IDRef=ChequeRecs.ID)
WHERE LastActRef=13

GO

Update ChequeRecs set VagozarbeBankTransactionRef = (select ID from [Transaction] where TypeRef=27 AND DocRef=ChequeRecs.DocID 
AND CodingRef='1102' AND AccountRef='110200000'+ ChequeRecs.VagozarbeBank AND [Description]=N'چەکی وەرگیراوی وه‏دست هاتو' AND IDRef=ChequeRecs.ID)
WHERE LastActRef=14

GO

Update ChequeRecs set VagozarbeShakhsTransactionRef = (select ID from [Transaction] where TypeRef=27 AND DocRef=ChequeRecs.DocID 
AND CodingRef='1103' AND AccountRef='110300000'+ ChequeRecs.VagozarbeShakhs AND [Description]=N'چەکی وه رگیراوی راسپاردراو به که‌س' AND IDRef=ChequeRecs.ID)
WHERE LastActRef IN(11,12)

GO

ALTER TABLE ChequeRecs ALTER COLUMN CustomerTransactionRef INT NOT NULL

GO

-- Costuses  آپدیت جدول  

DROP INDEX IX_Costuses ON Costuses
GO
ALTER TABLE Costuses ALTER COLUMN StartDate datetime2(7)
GO
CREATE INDEX IX_Costuses ON Costuses(StartDate) 
GO

--DECLARE @SQL NVARCHAR(MAX) = N'';
--SELECT @SQL += N'
--ALTER TABLE ' + OBJECT_NAME(PARENT_OBJECT_ID) + ' DROP CONSTRAINT ' + OBJECT_NAME(OBJECT_ID) + ';' 
--FROM SYS.OBJECTS
--WHERE TYPE_DESC LIKE '%CONSTRAINT' AND OBJECT_NAME(PARENT_OBJECT_ID) = 'Costuses' AND type = 'D';
----PRINT @SQL
--EXECUTE(@SQL)

GO
DECLARE @sql nvarchar(max)
SELECT @sql = 'ALTER TABLE Costuses DROP CONSTRAINT ' + df.NAME 
FROM sys.default_constraints df
  INNER JOIN sys.tables t ON df.parent_object_id = t.object_id
  INNER JOIN sys.columns c ON df.parent_object_id = c.object_id AND df.parent_column_id = c.column_id
where t.name = 'Costuses' and c.name = 'BaseAmont'
EXEC sp_executeSql @sql
GO
ALTER TABLE Costuses DROP COLUMN BaseAmont

GO

-- CostusItems آپدیت جدول  

DECLARE @sql nvarchar(max)
SELECT @sql = 'ALTER TABLE CostusItems DROP CONSTRAINT ' + df.NAME 
FROM sys.default_constraints df
  INNER JOIN sys.tables t ON df.parent_object_id = t.object_id
  INNER JOIN sys.columns c ON df.parent_object_id = c.object_id AND df.parent_column_id = c.column_id
where t.name = 'CostusItems' and c.name = 'BaseAmount'
EXEC sp_executeSql @sql
GO
ALTER TABLE CostusItems DROP COLUMN BaseAmount 

GO

DECLARE @sql nvarchar(max)
SELECT @sql = 'ALTER TABLE CostusItems DROP CONSTRAINT ' + df.NAME 
FROM sys.default_constraints df
  INNER JOIN sys.tables t ON df.parent_object_id = t.object_id
  INNER JOIN sys.columns c ON df.parent_object_id = c.object_id AND df.parent_column_id = c.column_id
where t.name = 'CostusItems' and c.name = 'BaseAmountRecive'
EXEC sp_executeSql @sql
GO
ALTER TABLE CostusItems DROP COLUMN BaseAmountRecive

GO

-- CurrencyHistory آپدیت جدول  

ALTER TABLE CurrencyHistory DROP CONSTRAINT FK_CurrencyHistory_DocHeader
ALTER TABLE CurrencyHistory DROP COLUMN DocID 

GO

ALTER TABLE CurrencyHistory DROP CONSTRAINT FK_CurrencyHistory_ItemGroup2
ALTER TABLE CurrencyHistory DROP CONSTRAINT FK_CurrencyHistory_ItemGroup3

GO

update CurrencyHistory set CurrencyFromRef=(select ID from Currencies where name=(select label from ItemGroup where ID=CurrencyFromRef))
GO
update CurrencyHistory set CurrencyToRef=(select ID from Currencies where name=(select label from ItemGroup where ID=CurrencyToRef))

GO

ALTER TABLE CurrencyHistory ADD CONSTRAINT FK_CurrencyHistoryFrom_Currencies FOREIGN KEY (CurrencyFromRef) REFERENCES Currencies(ID)
ALTER TABLE CurrencyHistory ADD CONSTRAINT FK_CurrencyHistoryTo_Currencies FOREIGN KEY (CurrencyToRef) REFERENCES Currencies(ID)

GO