﻿
-- Assets  آپدیت جدول  

INSERT INTO [dbo].[DocHeader]([ID],[RefTable],[RefID],[Date],[Subject],[Bed],[Bes])
select ROW_NUMBER() OVER (ORDER BY Assets.ID)+CASE WHEN (select top(1) ID from DocHeader order by ID DESC) IS NULL THEN 1 ELSE 
(select top(1) ID from DocHeader order by ID DESC) end,
 '40', ID, CASE WHEN [Date] is not null  THEN [Date] else '2000-01-01' end,Name+CAST(ID AS NVARCHAR),0,0
from Assets WHERE HaveBuySell=0 AND DocID IS NULL
GO
update Assets set DocID = (select ID from DocHeader where [Subject] = Name+CAST(Assets.ID AS NVARCHAR))
WHERE HaveBuySell=0 AND DocID IS NULL


GO

ALTER TABLE Assets ADD DocIDBuy INT NULL
GO
ALTER TABLE [dbo].[Assets]  WITH CHECK ADD  CONSTRAINT [FK_Assets_DocHeaderBuy] FOREIGN KEY([DocIDBuy]) REFERENCES [dbo].[DocHeader] ([ID])
GO
Update Assets set DocIDBuy=DocID

GO

INSERT INTO [dbo].[DocHeader]([ID],[RefTable],[RefID],[Date],[Subject],[Bed],[Bes])
select ROW_NUMBER() OVER (ORDER BY Assets.ID)+CASE WHEN (select top(1) ID from DocHeader order by ID DESC) IS NULL THEN 1 ELSE 
(select top(1) ID from DocHeader order by ID DESC) end,
 '6', ID, CASE WHEN BuyDate is not null  THEN BuyDate else '2000-01-01' end,Name+CAST(ID AS NVARCHAR),0,0
from Assets WHERE HaveBuySell=1 AND DocIDBuy IS NULL
GO
update Assets set DocIDBuy = (select ID from DocHeader where [Subject] = Name+CAST(Assets.ID AS NVARCHAR))
WHERE HaveBuySell=1 AND DocIDBuy IS NULL

GO

INSERT INTO [dbo].[DocHeader]([ID],[RefTable],[RefID],[Date],[Subject],[Bed],[Bes])
select ROW_NUMBER() OVER (ORDER BY Assets.ID)+CASE WHEN (select top(1) ID from DocHeader order by ID DESC) IS NULL THEN 1 ELSE 
(select top(1) ID from DocHeader order by ID DESC) end,
 '7', ID, CASE WHEN SellDate is not null  THEN SellDate else '2000-01-01' end,Name+CAST(ID AS NVARCHAR),0,0
from Assets WHERE HaveBuySell=2 AND DocIDSell IS NULL
GO
update Assets set DocIDBuy = (select ID from DocHeader where [Subject] = Name+CAST(Assets.ID AS NVARCHAR))
WHERE HaveBuySell=2 AND DocIDSell IS NULL

GO

INSERT INTO [dbo].[Transaction]
           ([Date],[TypeRef],[DocRef],[CodingRef],[AccountRef],[CurrencyRef],[Creditor],[Debtor],[ToBaseCurrencyRatio],[Description],IDRef)
SELECT BuyDate,'6',DocID, '1103',CAST('110300000' AS int)+BuyCustomerRef, BuyCurrencyRef,
BuyAmount, 0, 0, N'کڕینی ماڵ و دارایی',ID
from Assets 
where HaveBuySell=1

GO 
 
INSERT INTO [dbo].[Transaction]
           ([Date],[TypeRef],[DocRef],[CodingRef],[AccountRef],[CurrencyRef],[Creditor],[Debtor],[CreditorRemain],[DebtorRemain],[ToBaseCurrencyRatio],[Description],IDRef)
SELECT SellDate,'7',DocIDSell, '1103',CAST('110300000' AS int)+SellCustomerRef, SellCurrencyRef,
0, SellAmount, 0, 0, 0, N'فرۆشی ماڵ و دارایی',ID
from Assets
where HaveBuySell=2

GO

UPDATE Assets SET CurrencyRef=(SELECT ID FROM Currencies WHERE Name = CurrencyName)
GO
UPDATE Assets SET BuyCurrencyRef=(SELECT ID FROM Currencies WHERE Name = BuyCurrencyName)
GO
UPDATE Assets SET SellCurrencyRef=(SELECT ID FROM Currencies WHERE Name = SellCurrencyName)

GO

ALTER TABLE Assets ALTER COLUMN Name nvarchar(200) NOT NULL
ALTER TABLE Assets ADD CONSTRAINT FK_Assets_Currencies FOREIGN KEY (CurrencyRef) REFERENCES Currencies(ID) 
UPDATE Assets SET CurrencyRatio=1
ALTER TABLE Assets ALTER COLUMN CurrencyRatio money NOT NULL
ALTER TABLE Assets ADD CONSTRAINT FK_Assets_CurrenciesBuy FOREIGN KEY (BuyCurrencyRef) REFERENCES Currencies(ID) 
UPDATE Assets SET BuyCurrencyRatio=1
ALTER TABLE Assets ALTER COLUMN BuyCurrencyRatio money NOT NULL
ALTER TABLE Assets ADD CONSTRAINT FK_Assets_CurrenciesSell FOREIGN KEY (SellCurrencyRef) REFERENCES Currencies(ID) 
UPDATE Assets SET SellCurrencyRatio=1
ALTER TABLE Assets ALTER COLUMN SellCurrencyRatio money NOT NULL

ALTER TABLE Assets DROP COLUMN CurrencyName
ALTER TABLE Assets DROP COLUMN BuyCurrencyName
ALTER TABLE Assets DROP COLUMN SellCurrencyName

GO

ALTER TABLE Assets ADD BuyCustomerTransactionRef INT NULL
GO
Update Assets set BuyCustomerTransactionRef = (select ID from [Transaction] where TypeRef=6 AND DocRef=Assets.DocID 
AND CodingRef='1103' AND AccountRef='110300000'+ Assets.BuyCustomerRef AND IDRef=Assets.ID)
where HaveBuySell=1
GO
ALTER TABLE Assets ADD CONSTRAINT FK_Assets_Transaction FOREIGN KEY (BuyCustomerTransactionRef) REFERENCES [Transaction](ID)

GO

ALTER TABLE Assets ADD SellCustomerTransactionRef INT NULL
GO
Update Assets set SellCustomerTransactionRef = (select ID from [Transaction] where TypeRef=7 AND DocRef=Assets.DocIDSell 
AND CodingRef='1103' AND AccountRef='110300000'+ Assets.SellCustomerRef AND IDRef=Assets.ID)
where HaveBuySell=2
GO
ALTER TABLE Assets ADD CONSTRAINT FK_Assets_Transaction1 FOREIGN KEY (SellCustomerTransactionRef) REFERENCES [Transaction](ID)

GO

ALTER TABLE Assets ADD AssetTransactionRef INT NULL
GO
ALTER TABLE Assets ADD CONSTRAINT FK_Assets_Transaction2 FOREIGN KEY (AssetTransactionRef) REFERENCES [Transaction](ID)

GO

INSERT INTO [dbo].[DocHeader]([ID],[RefTable],[RefID],[Date],[Subject],[Bed],[Bes])
select ROW_NUMBER() OVER (ORDER BY Assets.id)+CASE WHEN (select top(1) ID from DocHeader order by ID DESC) IS NULL THEN 1 ELSE 
(select top(1) ID from DocHeader order by ID DESC) end,
 '40', id, CASE WHEN [date] is not null  THEN [date] else '2000-01-01' end,name,0,0
from Assets
WHERE HaveBuySell=0
GO
update Assets set Docid = (select ID from DocHeader where [Subject] = name)

GO

-- ID ستون Identity حذف 
/* To prevent any potential data loss issues, you should review this script in detail before running it outside the context of the database designer.*/
BEGIN TRANSACTION
SET QUOTED_IDENTIFIER ON
SET ARITHABORT ON
SET NUMERIC_ROUNDABORT OFF
SET CONCAT_NULL_YIELDS_NULL ON
SET ANSI_NULLS ON
SET ANSI_PADDING ON
SET ANSI_WARNINGS ON
COMMIT
BEGIN TRANSACTION
GO
ALTER TABLE dbo.Assets
	DROP CONSTRAINT FK_Assets_Transaction
GO
ALTER TABLE dbo.Assets
	DROP CONSTRAINT FK_Assets_Transaction1
GO
ALTER TABLE dbo.Assets
	DROP CONSTRAINT FK_Assets_Transaction2
GO
ALTER TABLE dbo.[Transaction] SET (LOCK_ESCALATION = TABLE)
GO
COMMIT
select Has_Perms_By_Name(N'dbo.[Transaction]', 'Object', 'ALTER') as ALT_Per, Has_Perms_By_Name(N'dbo.[Transaction]', 'Object', 'VIEW DEFINITION') as View_def_Per, Has_Perms_By_Name(N'dbo.[Transaction]', 'Object', 'CONTROL') as Contr_Per BEGIN TRANSACTION
GO
ALTER TABLE dbo.Assets
	DROP CONSTRAINT FK_Assets_Currencies
GO
ALTER TABLE dbo.Assets
	DROP CONSTRAINT FK_Assets_CurrenciesBuy
GO
ALTER TABLE dbo.Assets
	DROP CONSTRAINT FK_Assets_CurrenciesSell
GO
ALTER TABLE dbo.Currencies SET (LOCK_ESCALATION = TABLE)
GO
COMMIT
select Has_Perms_By_Name(N'dbo.Currencies', 'Object', 'ALTER') as ALT_Per, Has_Perms_By_Name(N'dbo.Currencies', 'Object', 'VIEW DEFINITION') as View_def_Per, Has_Perms_By_Name(N'dbo.Currencies', 'Object', 'CONTROL') as Contr_Per BEGIN TRANSACTION
GO
ALTER TABLE dbo.Assets
	DROP CONSTRAINT FK_Assets_Customers
GO
ALTER TABLE dbo.Assets
	DROP CONSTRAINT FK_Assets_Customers1
GO
ALTER TABLE dbo.Customers SET (LOCK_ESCALATION = TABLE)
GO
COMMIT
select Has_Perms_By_Name(N'dbo.Customers', 'Object', 'ALTER') as ALT_Per, Has_Perms_By_Name(N'dbo.Customers', 'Object', 'VIEW DEFINITION') as View_def_Per, Has_Perms_By_Name(N'dbo.Customers', 'Object', 'CONTROL') as Contr_Per BEGIN TRANSACTION
GO
ALTER TABLE dbo.Assets
	DROP CONSTRAINT FK_Assets_Coding
GO
ALTER TABLE dbo.Coding SET (LOCK_ESCALATION = TABLE)
GO
COMMIT
select Has_Perms_By_Name(N'dbo.Coding', 'Object', 'ALTER') as ALT_Per, Has_Perms_By_Name(N'dbo.Coding', 'Object', 'VIEW DEFINITION') as View_def_Per, Has_Perms_By_Name(N'dbo.Coding', 'Object', 'CONTROL') as Contr_Per BEGIN TRANSACTION
GO
ALTER TABLE dbo.Assets
	DROP CONSTRAINT FK_CashsSell_DocHeader
GO
ALTER TABLE dbo.Assets
	DROP CONSTRAINT FK_Assets_DocHeaderBuy
GO
ALTER TABLE dbo.Assets
	DROP CONSTRAINT FK_Assets_DocHeader
GO
ALTER TABLE dbo.DocHeader SET (LOCK_ESCALATION = TABLE)
GO
COMMIT
select Has_Perms_By_Name(N'dbo.DocHeader', 'Object', 'ALTER') as ALT_Per, Has_Perms_By_Name(N'dbo.DocHeader', 'Object', 'VIEW DEFINITION') as View_def_Per, Has_Perms_By_Name(N'dbo.DocHeader', 'Object', 'CONTROL') as Contr_Per BEGIN TRANSACTION
GO

DECLARE @sql nvarchar(max)
SELECT @sql = 'ALTER TABLE Assets DROP CONSTRAINT ' + df.NAME 
FROM sys.default_constraints df
  INNER JOIN sys.tables t ON df.parent_object_id = t.object_id
  INNER JOIN sys.columns c ON df.parent_object_id = c.object_id AND df.parent_column_id = c.column_id
where t.name = 'Assets' and c.name = 'Amount'
EXEC sp_executeSql @sql
GO
DECLARE @sql nvarchar(max)
SELECT @sql = 'ALTER TABLE Assets DROP CONSTRAINT ' + df.NAME 
FROM sys.default_constraints df
  INNER JOIN sys.tables t ON df.parent_object_id = t.object_id
  INNER JOIN sys.columns c ON df.parent_object_id = c.object_id AND df.parent_column_id = c.column_id
where t.name = 'Assets' and c.name = 'BuyAmount'
EXEC sp_executeSql @sql
GO
DECLARE @sql nvarchar(max)
SELECT @sql = 'ALTER TABLE Assets DROP CONSTRAINT ' + df.NAME 
FROM sys.default_constraints df
  INNER JOIN sys.tables t ON df.parent_object_id = t.object_id
  INNER JOIN sys.columns c ON df.parent_object_id = c.object_id AND df.parent_column_id = c.column_id
where t.name = 'Assets' and c.name = 'BuyPayAmount'
EXEC sp_executeSql @sql
GO
DECLARE @sql nvarchar(max)
SELECT @sql = 'ALTER TABLE Assets DROP CONSTRAINT ' + df.NAME 
FROM sys.default_constraints df
  INNER JOIN sys.tables t ON df.parent_object_id = t.object_id
  INNER JOIN sys.columns c ON df.parent_object_id = c.object_id AND df.parent_column_id = c.column_id
where t.name = 'Assets' and c.name = 'SellAmount'
EXEC sp_executeSql @sql
GO
DECLARE @sql nvarchar(max)
SELECT @sql = 'ALTER TABLE Assets DROP CONSTRAINT ' + df.NAME 
FROM sys.default_constraints df
  INNER JOIN sys.tables t ON df.parent_object_id = t.object_id
  INNER JOIN sys.columns c ON df.parent_object_id = c.object_id AND df.parent_column_id = c.column_id
where t.name = 'Assets' and c.name = 'SellRecAmount'
EXEC sp_executeSql @sql
GO
DECLARE @sql nvarchar(max)
SELECT @sql = 'ALTER TABLE Assets DROP CONSTRAINT ' + df.NAME 
FROM sys.default_constraints df
  INNER JOIN sys.tables t ON df.parent_object_id = t.object_id
  INNER JOIN sys.columns c ON df.parent_object_id = c.object_id AND df.parent_column_id = c.column_id
where t.name = 'Assets' and c.name = 'BaseAmount'
EXEC sp_executeSql @sql
GO
DECLARE @sql nvarchar(max)
SELECT @sql = 'ALTER TABLE Assets DROP CONSTRAINT ' + df.NAME 
FROM sys.default_constraints df
  INNER JOIN sys.tables t ON df.parent_object_id = t.object_id
  INNER JOIN sys.columns c ON df.parent_object_id = c.object_id AND df.parent_column_id = c.column_id
where t.name = 'Assets' and c.name = 'BaseBuyAmount'
EXEC sp_executeSql @sql
GO
DECLARE @sql nvarchar(max)
SELECT @sql = 'ALTER TABLE Assets DROP CONSTRAINT ' + df.NAME 
FROM sys.default_constraints df
  INNER JOIN sys.tables t ON df.parent_object_id = t.object_id
  INNER JOIN sys.columns c ON df.parent_object_id = c.object_id AND df.parent_column_id = c.column_id
where t.name = 'Assets' and c.name = 'BaseBuyPayAmount'
EXEC sp_executeSql @sql
GO
DECLARE @sql nvarchar(max)
SELECT @sql = 'ALTER TABLE Assets DROP CONSTRAINT ' + df.NAME 
FROM sys.default_constraints df
  INNER JOIN sys.tables t ON df.parent_object_id = t.object_id
  INNER JOIN sys.columns c ON df.parent_object_id = c.object_id AND df.parent_column_id = c.column_id
where t.name = 'Assets' and c.name = 'BaseSellAmount'
EXEC sp_executeSql @sql
GO
DECLARE @sql nvarchar(max)
SELECT @sql = 'ALTER TABLE Assets DROP CONSTRAINT ' + df.NAME 
FROM sys.default_constraints df
  INNER JOIN sys.tables t ON df.parent_object_id = t.object_id
  INNER JOIN sys.columns c ON df.parent_object_id = c.object_id AND df.parent_column_id = c.column_id
where t.name = 'Assets' and c.name = 'BaseSellRecAmount'
EXEC sp_executeSql @sql

GO
CREATE TABLE dbo.Tmp_Assets
	(
	ID int NOT NULL,
	SubRef int NOT NULL,
	Name nvarchar(200) NOT NULL,
	Amount money NOT NULL,
	Date datetime2(7) NULL,
	Description nvarchar(MAX) NULL,
	HaveBuySell int NULL,
	BuyAmount money NOT NULL,
	BuyDate datetime2(7) NULL,
	BuyCustomerRef int NULL,
	BuyPayAmount money NOT NULL,
	BuyDescription nvarchar(MAX) NULL,
	SellAmount money NOT NULL,
	SellDate datetime2(7) NULL,
	SellCustomerRef int NULL,
	SellRecAmount money NOT NULL,
	SellDescription nvarchar(MAX) NULL,
	DocID int NULL,
	DocIDSell int NULL,
	CurrencyRef int NULL,
	CurrencyRatio money NOT NULL,
	BuyCurrencyRef int NULL,
	BuyCurrencyRatio money NOT NULL,
	SellCurrencyRef int NULL,
	SellCurrencyRatio money NOT NULL,
	BaseAmount money NOT NULL,
	BaseBuyAmount money NOT NULL,
	BaseBuyPayAmount money NOT NULL,
	BaseSellAmount money NOT NULL,
	BaseSellRecAmount money NOT NULL,
	DocIDBuy int NULL,
	BuyCustomerTransactionRef int NULL,
	SellCustomerTransactionRef int NULL,
	AssetTransactionRef int NULL
	)  ON [PRIMARY]
	 TEXTIMAGE_ON [PRIMARY]
GO
ALTER TABLE dbo.Tmp_Assets SET (LOCK_ESCALATION = TABLE)
GO
ALTER TABLE dbo.Tmp_Assets ADD CONSTRAINT
	DF__Assets__Amount__16644E42 DEFAULT ((0)) FOR Amount
GO
ALTER TABLE dbo.Tmp_Assets ADD CONSTRAINT
	DF__Assets__BuyAmoun__1758727B DEFAULT ((0)) FOR BuyAmount
GO
ALTER TABLE dbo.Tmp_Assets ADD CONSTRAINT
	DF__Assets__BuyPayAm__184C96B4 DEFAULT ((0)) FOR BuyPayAmount
GO
ALTER TABLE dbo.Tmp_Assets ADD CONSTRAINT
	DF__Assets__SellAmou__1940BAED DEFAULT ((0)) FOR SellAmount
GO
ALTER TABLE dbo.Tmp_Assets ADD CONSTRAINT
	DF__Assets__SellRecA__1A34DF26 DEFAULT ((0)) FOR SellRecAmount
GO
ALTER TABLE dbo.Tmp_Assets ADD CONSTRAINT
	DF__Assets__BaseAmou__04CFADEC DEFAULT ((0)) FOR BaseAmount
GO
ALTER TABLE dbo.Tmp_Assets ADD CONSTRAINT
	DF__Assets__BaseBuyA__05C3D225 DEFAULT ((0)) FOR BaseBuyAmount
GO
ALTER TABLE dbo.Tmp_Assets ADD CONSTRAINT
	DF__Assets__BaseBuyP__06B7F65E DEFAULT ((0)) FOR BaseBuyPayAmount
GO
ALTER TABLE dbo.Tmp_Assets ADD CONSTRAINT
	DF__Assets__BaseSell__07AC1A97 DEFAULT ((0)) FOR BaseSellAmount
GO
ALTER TABLE dbo.Tmp_Assets ADD CONSTRAINT
	DF__Assets__BaseSell__08A03ED0 DEFAULT ((0)) FOR BaseSellRecAmount
GO
IF EXISTS(SELECT * FROM dbo.Assets)
	 EXEC('INSERT INTO dbo.Tmp_Assets (ID, SubRef, Name, Amount, Date, Description, HaveBuySell, BuyAmount, BuyDate, BuyCustomerRef, BuyPayAmount, BuyDescription, SellAmount, SellDate, SellCustomerRef, SellRecAmount, SellDescription, DocID, DocIDSell, CurrencyRef, CurrencyRatio, BuyCurrencyRef, BuyCurrencyRatio, SellCurrencyRef, SellCurrencyRatio, BaseAmount, BaseBuyAmount, BaseBuyPayAmount, BaseSellAmount, BaseSellRecAmount, DocIDBuy, BuyCustomerTransactionRef, SellCustomerTransactionRef, AssetTransactionRef)
		SELECT ID, SubRef, Name, Amount, Date, Description, HaveBuySell, BuyAmount, BuyDate, BuyCustomerRef, BuyPayAmount, BuyDescription, SellAmount, SellDate, SellCustomerRef, SellRecAmount, SellDescription, DocID, DocIDSell, CurrencyRef, CurrencyRatio, BuyCurrencyRef, BuyCurrencyRatio, SellCurrencyRef, SellCurrencyRatio, BaseAmount, BaseBuyAmount, BaseBuyPayAmount, BaseSellAmount, BaseSellRecAmount, DocIDBuy, BuyCustomerTransactionRef, SellCustomerTransactionRef, AssetTransactionRef FROM dbo.Assets WITH (HOLDLOCK TABLOCKX)')
GO
DROP TABLE dbo.Assets
GO
EXECUTE sp_rename N'dbo.Tmp_Assets', N'Assets', 'OBJECT' 
GO
ALTER TABLE dbo.Assets ADD CONSTRAINT
	PK_Assets PRIMARY KEY CLUSTERED 
	(
	ID
	) WITH( STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]

GO
CREATE NONCLUSTERED INDEX DocIDIndex ON dbo.Assets
	(
	DocID
	) WITH( STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX DocIDSellIndex ON dbo.Assets
	(
	DocIDSell
	) WITH( STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
ALTER TABLE dbo.Assets ADD CONSTRAINT
	FK_CashsSell_DocHeader FOREIGN KEY
	(
	DocIDSell
	) REFERENCES dbo.DocHeader
	(
	ID
	) ON UPDATE  NO ACTION 
	 ON DELETE  NO ACTION 
	
GO
ALTER TABLE dbo.Assets ADD CONSTRAINT
	FK_Assets_Coding FOREIGN KEY
	(
	SubRef
	) REFERENCES dbo.Coding
	(
	AccountCode
	) ON UPDATE  NO ACTION 
	 ON DELETE  NO ACTION 
	
GO
ALTER TABLE dbo.Assets ADD CONSTRAINT
	FK_Assets_Customers FOREIGN KEY
	(
	BuyCustomerRef
	) REFERENCES dbo.Customers
	(
	ID
	) ON UPDATE  NO ACTION 
	 ON DELETE  NO ACTION 
	
GO
ALTER TABLE dbo.Assets ADD CONSTRAINT
	FK_Assets_Customers1 FOREIGN KEY
	(
	SellCustomerRef
	) REFERENCES dbo.Customers
	(
	ID
	) ON UPDATE  NO ACTION 
	 ON DELETE  NO ACTION 
	
GO
ALTER TABLE dbo.Assets ADD CONSTRAINT
	FK_Assets_DocHeaderBuy FOREIGN KEY
	(
	DocIDBuy
	) REFERENCES dbo.DocHeader
	(
	ID
	) ON UPDATE  NO ACTION 
	 ON DELETE  NO ACTION 
	
GO
ALTER TABLE dbo.Assets ADD CONSTRAINT
	FK_Assets_Currencies FOREIGN KEY
	(
	CurrencyRef
	) REFERENCES dbo.Currencies
	(
	ID
	) ON UPDATE  NO ACTION 
	 ON DELETE  NO ACTION 
	
GO
ALTER TABLE dbo.Assets ADD CONSTRAINT
	FK_Assets_DocHeader FOREIGN KEY
	(
	DocID
	) REFERENCES dbo.DocHeader
	(
	ID
	) ON UPDATE  CASCADE 
	 ON DELETE  NO ACTION 
	
GO
ALTER TABLE dbo.Assets ADD CONSTRAINT
	FK_Assets_CurrenciesBuy FOREIGN KEY
	(
	BuyCurrencyRef
	) REFERENCES dbo.Currencies
	(
	ID
	) ON UPDATE  NO ACTION 
	 ON DELETE  NO ACTION 
	
GO
ALTER TABLE dbo.Assets ADD CONSTRAINT
	FK_Assets_CurrenciesSell FOREIGN KEY
	(
	SellCurrencyRef
	) REFERENCES dbo.Currencies
	(
	ID
	) ON UPDATE  NO ACTION 
	 ON DELETE  NO ACTION 
	
GO
ALTER TABLE dbo.Assets ADD CONSTRAINT
	FK_Assets_Transaction FOREIGN KEY
	(
	BuyCustomerTransactionRef
	) REFERENCES dbo.[Transaction]
	(
	ID
	) ON UPDATE  NO ACTION 
	 ON DELETE  NO ACTION 
	
GO
ALTER TABLE dbo.Assets ADD CONSTRAINT
	FK_Assets_Transaction1 FOREIGN KEY
	(
	SellCustomerTransactionRef
	) REFERENCES dbo.[Transaction]
	(
	ID
	) ON UPDATE  NO ACTION 
	 ON DELETE  NO ACTION 
	
GO
ALTER TABLE dbo.Assets ADD CONSTRAINT
	FK_Assets_Transaction2 FOREIGN KEY
	(
	AssetTransactionRef
	) REFERENCES dbo.[Transaction]
	(
	ID
	) ON UPDATE  NO ACTION 
	 ON DELETE  NO ACTION 
	
GO
COMMIT
select Has_Perms_By_Name(N'dbo.Assets', 'Object', 'ALTER') as ALT_Per, Has_Perms_By_Name(N'dbo.Assets', 'Object', 'VIEW DEFINITION') as View_def_Per, Has_Perms_By_Name(N'dbo.Assets', 'Object', 'CONTROL') as Contr_Per 


GO

-- CapitalAction  آپدیت جدول  

ALTER TABLE CapitalAction ALTER COLUMN Name nvarchar(200) NULL

GO

-- Capitals  آپدیت جدول  

INSERT INTO [dbo].[DocHeader]([ID],[RefTable],[RefID],[Date],[Subject],[Bed],[Bes])
select ROW_NUMBER() OVER (ORDER BY Capitals.ID)+CASE WHEN (select top(1) ID from DocHeader order by ID DESC) IS NULL THEN 1 ELSE 
(select top(1) ID from DocHeader order by ID DESC) end,
 '34', ID, CASE WHEN [Date] is not null  THEN [Date] else '2000-01-01' end,Who+CAST(ID AS NVARCHAR),0,0
from Capitals WHERE DocID IS NULL
GO
update Capitals set DocID = (select ID from DocHeader where [Subject] = Who+CAST(Capitals.ID AS NVARCHAR))
WHERE DocID IS NULL

GO

INSERT INTO [dbo].[Transaction]
           ([Date],[TypeRef],[DocRef],[CodingRef],[AccountRef],[CurrencyRef],[Creditor],[Debtor],[CreditorRemain],[DebtorRemain],[ToBaseCurrencyRatio],[Description],IDRef)
SELECT [Date],'31',DocID, '1101',CAST('110100000' AS int)+CashboxRef,
(SELECT CurrencyRef from dbo.CashBox where ID=CashBoxRef), Amount, 0, 0, 0, 0, N'ڕژاندن به سندوق',ID
from Capitals where CapitalActionRef=1

GO

INSERT INTO [dbo].[Transaction]
           ([Date],[TypeRef],[DocRef],[CodingRef],[AccountRef],[CurrencyRef],[Creditor],[Debtor],[CreditorRemain],[DebtorRemain],[ToBaseCurrencyRatio],[Description],IDRef)
SELECT [Date],'31',DocID, '1101',CAST('110100000' AS int)+CashboxRef,
(SELECT CurrencyRef from dbo.CashBox where ID=CashBoxRef), 0, Amount, 0, 0, 0, N'هەڵگرتن له سندوق',ID
from Capitals where CapitalActionRef=2

GO

INSERT INTO [dbo].[Transaction]
           ([Date],[TypeRef],[DocRef],[CodingRef],[AccountRef],[CurrencyRef],[Creditor],[Debtor],[CreditorRemain],[DebtorRemain],[ToBaseCurrencyRatio],[Description],IDRef)
SELECT [Date],'30',DocID, '1102',CAST('110200000' AS int)+AccountRef,
(SELECT CurrencyRef from dbo.CashBox where ID=1), Amount, 0, 0, 0, 0, N'ڕژاندن به حیساب',ID
from Capitals where CapitalActionRef=3

GO

INSERT INTO [dbo].[Transaction]
           ([Date],[TypeRef],[DocRef],[CodingRef],[AccountRef],[CurrencyRef],[Creditor],[Debtor],[CreditorRemain],[DebtorRemain],[ToBaseCurrencyRatio],[Description],IDRef)
SELECT [Date],'30',DocID, '1102',CAST('110200000' AS int)+AccountRef,
(SELECT CurrencyRef from dbo.CashBox where ID=1), 0, Amount, 0, 0, 0, N'هەڵگرتن له حیساب',ID
from Capitals where CapitalActionRef=4

GO

ALTER TABLE Capitals ALTER COLUMN Who nvarchar(200) NOT NULL
ALTER TABLE Capitals ALTER COLUMN [Date] datetime2(7) NOT NULL

GO

ALTER TABLE Capitals ADD CapitalTransactionRef INT NULL
GO

Update Capitals set CapitalTransactionRef = (select ID from [Transaction] where TypeRef=31 
AND DocRef=Capitals.DocID AND CodingRef='1101' AND AccountRef='110100000'+ Capitals.CashBoxRef AND IDRef=Capitals.ID)
where CapitalActionRef=1 OR CapitalActionRef=2
GO
Update Capitals set CapitalTransactionRef = (select ID from [Transaction] where TypeRef=30 
AND DocRef=Capitals.DocID AND CodingRef='1102' AND AccountRef='110200000'+ Capitals.AccountRef AND IDRef=Capitals.ID)
where CapitalActionRef=3 OR CapitalActionRef=4
ALTER TABLE Capitals ADD CONSTRAINT FK_Capitals_Transaction FOREIGN KEY (CapitalTransactionRef) REFERENCES [Transaction](ID)
GO

ALTER TABLE Capitals ADD CashBoxOrBankAccountTransactionRef INT NULL
GO
Update Capitals set CashBoxOrBankAccountTransactionRef = (select ID from [Transaction] where TypeRef=31 
AND DocRef=Capitals.DocID AND CodingRef='1101' AND AccountRef='110100000'+ Capitals.CashBoxRef AND IDRef=Capitals.ID)
where CapitalActionRef=1 OR CapitalActionRef=2
GO
Update Capitals set CashBoxOrBankAccountTransactionRef = (select ID from [Transaction] where TypeRef=30 
AND DocRef=Capitals.DocID AND CodingRef='1102' AND AccountRef='110200000'+ Capitals.AccountRef AND IDRef=Capitals.ID)
where CapitalActionRef=3 OR CapitalActionRef=4
GO
ALTER TABLE Capitals ALTER COLUMN CapitalTransactionRef INT NOT NULL
GO
ALTER TABLE Capitals ALTER COLUMN CashBoxOrBankAccountTransactionRef INT NOT NULL
GO

ALTER TABLE Capitals ADD CONSTRAINT FK_CashBoxBankAccount_Transaction FOREIGN KEY (CashBoxOrBankAccountTransactionRef) REFERENCES [Transaction](ID)

GO

