﻿

-- CashBox  آپدیت جدول  

UPDATE CashBox SET [Date]='2000-01-01'
WHERE [Date] IS NULL

UPDATE CashBox SET [Type]=(select ID from dbo.Currencies WHERE Name=dbo.CashBox.Currency)
WHERE [Type]<>0 OR [Type] IS NOT NULL

UPDATE CashBox SET Currency=(select top(1) Name from dbo.Currencies)
WHERE [Type] IS NULL OR [Type]=0

UPDATE CashBox SET [Type]=(select top(1) ID from dbo.Currencies)
WHERE [Type] IS NULL OR [Type]=0

GO

INSERT INTO [dbo].[DocHeader]([ID],[RefTable],[RefID],[Date],[Subject],[Bed],[Bes])
select ROW_NUMBER() OVER (ORDER BY CashBox.id)+CASE WHEN (select top(1) ID from DocHeader order by ID DESC) IS NULL THEN 1 ELSE 
(select top(1) ID from DocHeader order by ID DESC) end,
 '31', id, CASE WHEN [date] is not null  THEN [date] else '2000-01-01' end,name,0,0
from cashbox WHERE DocID IS NULL OR DocID=0

GO

update cashbox set docid = (select id from DocHeader where [Subject] = name)
WHERE DocID IS NULL

GO

INSERT INTO DetailAccounts(ID,CodingRef,RefTable,RefID,GroupRef,Name,[First],Creditor,Debtor,Remain,CurrencyRef)
SELECT CAST('110100000' AS int)+ID,'1101', '31',ID,null,Name,FirstAmount, 0, 0, 0,
(SELECT id from dbo.Currencies where name = Currency)
from Cashbox 

GO

INSERT INTO [dbo].[Transaction]
           ([Date],[TypeRef],[DocRef],[CodingRef],[AccountRef],[CurrencyRef],[Creditor],[Debtor],[CreditorRemain],[DebtorRemain],[ToBaseCurrencyRatio],[Description],IDRef)
SELECT CASE WHEN [date] is not null  THEN [date] else '2000-01-01' end,'31',DocID, '310103',CAST('110100000' AS int)+ID,
(SELECT id from dbo.Currencies where name = Currency),
CASE WHEN firstamount > 0  THEN abs(firstamount) else CAST('0' AS money) end,
CASE WHEN firstamount < 0  THEN abs(firstamount) else CAST('0' AS money) end,0,0,0,N'بونی دەسپێک', ID
from Cashbox where [Type] IS NOT NULL

GO

ALTER TABLE Cashbox ADD AccountRef INT NULL
GO
Update Cashbox set AccountRef = (select id from DetailAccounts where RefTable=31 AND CodingRef='1101' and RefID=Cashbox.ID)
GO
ALTER TABLE Cashbox ALTER COLUMN [AccountRef] INT NOT NULL
GO
ALTER TABLE Cashbox ADD CONSTRAINT FK_CashBox_Accounts FOREIGN KEY (AccountRef) REFERENCES DetailAccounts(ID) 

GO

ALTER TABLE Cashbox ADD FirstTransactionRef INT NULL
GO
Update Cashbox set FirstTransactionRef = (select ID from [Transaction] where TypeRef=31 AND DocRef=Cashbox.DocID 
AND CodingRef='310103' AND AccountRef='110100000'+ Cashbox.ID)
GO
ALTER TABLE Cashbox ALTER COLUMN FirstTransactionRef INT NOT NULL
GO
ALTER TABLE Cashbox ADD CONSTRAINT FK_CashBox_Transaction FOREIGN KEY (FirstTransactionRef) REFERENCES [Transaction](ID) 

GO

ALTER TABLE Cashbox ADD CurrencyRef INT NULL
GO
Update Cashbox set CurrencyRef = (select ID from Currencies where Name=Cashbox.Currency)
GO
ALTER TABLE Cashbox ALTER COLUMN CurrencyRef INT NOT NULL
GO
ALTER TABLE Cashbox ADD CONSTRAINT FK_CashBox_Currencies FOREIGN KEY (CurrencyRef) REFERENCES Currencies(ID)

GO

--DECLARE @SQL NVARCHAR(MAX) = N'';
--SELECT @SQL += N'
--ALTER TABLE ' + OBJECT_NAME(PARENT_OBJECT_ID) + ' DROP CONSTRAINT ' + OBJECT_NAME(OBJECT_ID) + ';' 
--FROM SYS.OBJECTS
--WHERE TYPE_DESC LIKE '%CONSTRAINT' AND OBJECT_NAME(PARENT_OBJECT_ID) = 'CashBox' AND type = 'D';
----PRINT @SQL
--EXECUTE(@SQL)

GO

ALTER TABLE Cashbox ALTER COLUMN Name nvarchar(200) NOT NULL
ALTER TABLE Cashbox ALTER COLUMN [Date] datetime2(7)
GO

DECLARE @sql nvarchar(max)
SELECT @sql = 'ALTER TABLE Cashbox DROP CONSTRAINT ' + df.NAME 
FROM sys.default_constraints df
  INNER JOIN sys.tables t ON df.parent_object_id = t.object_id
  INNER JOIN sys.columns c ON df.parent_object_id = c.object_id AND df.parent_column_id = c.column_id
where t.name = 'Cashbox' and c.name = 'Amount'
EXEC sp_executeSql @sql
GO
ALTER TABLE Cashbox DROP COLUMN Amount

GO

DECLARE @sql nvarchar(max)
SELECT @sql = 'ALTER TABLE Cashbox DROP CONSTRAINT ' + df.NAME 
FROM sys.default_constraints df
  INNER JOIN sys.tables t ON df.parent_object_id = t.object_id
  INNER JOIN sys.columns c ON df.parent_object_id = c.object_id AND df.parent_column_id = c.column_id
where t.name = 'Cashbox' and c.name = 'FirstAmount'
EXEC sp_executeSql @sql
GO
ALTER TABLE Cashbox DROP COLUMN FirstAmount

GO
DECLARE @sql nvarchar(max)
SELECT @sql = 'ALTER TABLE Cashbox DROP CONSTRAINT ' + df.NAME 
FROM sys.default_constraints df
  INNER JOIN sys.tables t ON df.parent_object_id = t.object_id
  INNER JOIN sys.columns c ON df.parent_object_id = c.object_id AND df.parent_column_id = c.column_id
where t.name = 'Cashbox' and c.name = 'CurrencyFirstAmount'
EXEC sp_executeSql @sql
GO
ALTER TABLE Cashbox DROP COLUMN CurrencyFirstAmount

GO
DECLARE @sql nvarchar(max)
SELECT @sql = 'ALTER TABLE Cashbox DROP CONSTRAINT ' + df.NAME 
FROM sys.default_constraints df
  INNER JOIN sys.tables t ON df.parent_object_id = t.object_id
  INNER JOIN sys.columns c ON df.parent_object_id = c.object_id AND df.parent_column_id = c.column_id
where t.name = 'Cashbox' and c.name = 'CurrencyAmount'
EXEC sp_executeSql @sql
GO
ALTER TABLE Cashbox DROP COLUMN CurrencyAmount

GO
DECLARE @sql nvarchar(max)
SELECT @sql = 'ALTER TABLE Cashbox DROP CONSTRAINT ' + df.NAME 
FROM sys.default_constraints df
  INNER JOIN sys.tables t ON df.parent_object_id = t.object_id
  INNER JOIN sys.columns c ON df.parent_object_id = c.object_id AND df.parent_column_id = c.column_id
where t.name = 'Cashbox' and c.name = 'Currency'
EXEC sp_executeSql @sql
GO
ALTER TABLE Cashbox DROP COLUMN Currency 

GO

-- ID ستون Identity حذف 
/* To prevent any potential data loss issues, you should review this script in detail before running it outside the context of the database designer.*/
BEGIN TRANSACTION
SET QUOTED_IDENTIFIER ON
SET ARITHABORT ON
SET NUMERIC_ROUNDABORT OFF
SET CONCAT_NULL_YIELDS_NULL ON
SET ANSI_NULLS ON
SET ANSI_PADDING ON
SET ANSI_WARNINGS ON
COMMIT
BEGIN TRANSACTION
GO
ALTER TABLE dbo.CashBox
	DROP CONSTRAINT FK_CashBox_Currencies
GO
ALTER TABLE dbo.Currencies SET (LOCK_ESCALATION = TABLE)
GO
COMMIT
select Has_Perms_By_Name(N'dbo.Currencies', 'Object', 'ALTER') as ALT_Per, Has_Perms_By_Name(N'dbo.Currencies', 'Object', 'VIEW DEFINITION') as View_def_Per, Has_Perms_By_Name(N'dbo.Currencies', 'Object', 'CONTROL') as Contr_Per BEGIN TRANSACTION
GO
ALTER TABLE dbo.CashBox
	DROP CONSTRAINT FK_CashBox_Transaction
GO
ALTER TABLE dbo.[Transaction] SET (LOCK_ESCALATION = TABLE)
GO
COMMIT
select Has_Perms_By_Name(N'dbo.[Transaction]', 'Object', 'ALTER') as ALT_Per, Has_Perms_By_Name(N'dbo.[Transaction]', 'Object', 'VIEW DEFINITION') as View_def_Per, Has_Perms_By_Name(N'dbo.[Transaction]', 'Object', 'CONTROL') as Contr_Per BEGIN TRANSACTION
GO
ALTER TABLE dbo.CashBox
	DROP CONSTRAINT FK_CashBox_Accounts
GO
ALTER TABLE dbo.DetailAccounts SET (LOCK_ESCALATION = TABLE)
GO
COMMIT
select Has_Perms_By_Name(N'dbo.DetailAccounts', 'Object', 'ALTER') as ALT_Per, Has_Perms_By_Name(N'dbo.DetailAccounts', 'Object', 'VIEW DEFINITION') as View_def_Per, Has_Perms_By_Name(N'dbo.DetailAccounts', 'Object', 'CONTROL') as Contr_Per BEGIN TRANSACTION
GO
ALTER TABLE dbo.CashBox
	DROP CONSTRAINT FK_CashBox_DocHeader
GO
ALTER TABLE dbo.DocHeader SET (LOCK_ESCALATION = TABLE)
GO
COMMIT
select Has_Perms_By_Name(N'dbo.DocHeader', 'Object', 'ALTER') as ALT_Per, Has_Perms_By_Name(N'dbo.DocHeader', 'Object', 'VIEW DEFINITION') as View_def_Per, Has_Perms_By_Name(N'dbo.DocHeader', 'Object', 'CONTROL') as Contr_Per BEGIN TRANSACTION
GO
CREATE TABLE dbo.Tmp_CashBox
	(
	ID int NOT NULL,
	Name nvarchar(200) NOT NULL,
	Description nvarchar(MAX) NULL,
	Date datetime2(7) NULL,
	Type int NULL,
	RowVersion timestamp NOT NULL,
	DocID int NULL,
	AccountRef int NOT NULL,
	FirstTransactionRef int NOT NULL,
	CurrencyRef int NOT NULL
	)  ON [PRIMARY]
	 TEXTIMAGE_ON [PRIMARY]
GO
ALTER TABLE dbo.Tmp_CashBox SET (LOCK_ESCALATION = TABLE)
GO
IF EXISTS(SELECT * FROM dbo.CashBox)
	 EXEC('INSERT INTO dbo.Tmp_CashBox (ID, Name, Description, Date, Type, DocID, AccountRef, FirstTransactionRef, CurrencyRef)
		SELECT ID, Name, Description, Date, Type, DocID, AccountRef, FirstTransactionRef, CurrencyRef FROM dbo.CashBox WITH (HOLDLOCK TABLOCKX)')
GO
ALTER TABLE dbo.Cashs
	DROP CONSTRAINT FK_Cashs_CashBox
GO
ALTER TABLE dbo.FishPays
	DROP CONSTRAINT FK_FishPays_CashBox
GO
ALTER TABLE dbo.ChequeRecs
	DROP CONSTRAINT FK_ChequeRecs_CashBox
GO
ALTER TABLE dbo.BankActs
	DROP CONSTRAINT FK_BankActs_CashBox
GO
ALTER TABLE dbo.Capitals
	DROP CONSTRAINT FK_Capitals_CashBox
GO
DROP TABLE dbo.CashBox
GO
EXECUTE sp_rename N'dbo.Tmp_CashBox', N'CashBox', 'OBJECT' 
GO
ALTER TABLE dbo.CashBox ADD CONSTRAINT
	PK_CashBox PRIMARY KEY CLUSTERED 
	(
	ID
	) WITH( STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]

GO
CREATE NONCLUSTERED INDEX DocIDIndex ON dbo.CashBox
	(
	DocID
	) WITH( STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
ALTER TABLE dbo.CashBox ADD CONSTRAINT
	FK_CashBox_DocHeader FOREIGN KEY
	(
	DocID
	) REFERENCES dbo.DocHeader
	(
	ID
	) ON UPDATE  CASCADE 
	 ON DELETE  NO ACTION 
	
GO
ALTER TABLE dbo.CashBox ADD CONSTRAINT
	FK_CashBox_Accounts FOREIGN KEY
	(
	AccountRef
	) REFERENCES dbo.DetailAccounts
	(
	ID
	) ON UPDATE  NO ACTION 
	 ON DELETE  NO ACTION 
	
GO
ALTER TABLE dbo.CashBox ADD CONSTRAINT
	FK_CashBox_Transaction FOREIGN KEY
	(
	FirstTransactionRef
	) REFERENCES dbo.[Transaction]
	(
	ID
	) ON UPDATE  NO ACTION 
	 ON DELETE  NO ACTION 
	
GO
ALTER TABLE dbo.CashBox ADD CONSTRAINT
	FK_CashBox_Currencies FOREIGN KEY
	(
	CurrencyRef
	) REFERENCES dbo.Currencies
	(
	ID
	) ON UPDATE  NO ACTION 
	 ON DELETE  NO ACTION 
	
GO
COMMIT
select Has_Perms_By_Name(N'dbo.CashBox', 'Object', 'ALTER') as ALT_Per, Has_Perms_By_Name(N'dbo.CashBox', 'Object', 'VIEW DEFINITION') as View_def_Per, Has_Perms_By_Name(N'dbo.CashBox', 'Object', 'CONTROL') as Contr_Per BEGIN TRANSACTION
GO
ALTER TABLE dbo.Capitals ADD CONSTRAINT
	FK_Capitals_CashBox FOREIGN KEY
	(
	CashBoxRef
	) REFERENCES dbo.CashBox
	(
	ID
	) ON UPDATE  NO ACTION 
	 ON DELETE  NO ACTION 
	
GO
ALTER TABLE dbo.Capitals SET (LOCK_ESCALATION = TABLE)
GO
COMMIT
select Has_Perms_By_Name(N'dbo.Capitals', 'Object', 'ALTER') as ALT_Per, Has_Perms_By_Name(N'dbo.Capitals', 'Object', 'VIEW DEFINITION') as View_def_Per, Has_Perms_By_Name(N'dbo.Capitals', 'Object', 'CONTROL') as Contr_Per BEGIN TRANSACTION
GO
ALTER TABLE dbo.BankActs ADD CONSTRAINT
	FK_BankActs_CashBox FOREIGN KEY
	(
	CashBoxRef
	) REFERENCES dbo.CashBox
	(
	ID
	) ON UPDATE  NO ACTION 
	 ON DELETE  NO ACTION 
	
GO
ALTER TABLE dbo.BankActs SET (LOCK_ESCALATION = TABLE)
GO
COMMIT
select Has_Perms_By_Name(N'dbo.BankActs', 'Object', 'ALTER') as ALT_Per, Has_Perms_By_Name(N'dbo.BankActs', 'Object', 'VIEW DEFINITION') as View_def_Per, Has_Perms_By_Name(N'dbo.BankActs', 'Object', 'CONTROL') as Contr_Per BEGIN TRANSACTION
GO
ALTER TABLE dbo.ChequeRecs ADD CONSTRAINT
	FK_ChequeRecs_CashBox FOREIGN KEY
	(
	CashBoxRef
	) REFERENCES dbo.CashBox
	(
	ID
	) ON UPDATE  NO ACTION 
	 ON DELETE  NO ACTION 
	
GO
ALTER TABLE dbo.ChequeRecs SET (LOCK_ESCALATION = TABLE)
GO
COMMIT
select Has_Perms_By_Name(N'dbo.ChequeRecs', 'Object', 'ALTER') as ALT_Per, Has_Perms_By_Name(N'dbo.ChequeRecs', 'Object', 'VIEW DEFINITION') as View_def_Per, Has_Perms_By_Name(N'dbo.ChequeRecs', 'Object', 'CONTROL') as Contr_Per BEGIN TRANSACTION
GO
ALTER TABLE dbo.FishPays ADD CONSTRAINT
	FK_FishPays_CashBox FOREIGN KEY
	(
	CashBoxRef
	) REFERENCES dbo.CashBox
	(
	ID
	) ON UPDATE  NO ACTION 
	 ON DELETE  NO ACTION 
	
GO
ALTER TABLE dbo.FishPays SET (LOCK_ESCALATION = TABLE)
GO
COMMIT
select Has_Perms_By_Name(N'dbo.FishPays', 'Object', 'ALTER') as ALT_Per, Has_Perms_By_Name(N'dbo.FishPays', 'Object', 'VIEW DEFINITION') as View_def_Per, Has_Perms_By_Name(N'dbo.FishPays', 'Object', 'CONTROL') as Contr_Per BEGIN TRANSACTION
GO
ALTER TABLE dbo.Cashs ADD CONSTRAINT
	FK_Cashs_CashBox FOREIGN KEY
	(
	CashboxRef
	) REFERENCES dbo.CashBox
	(
	ID
	) ON UPDATE  NO ACTION 
	 ON DELETE  NO ACTION 
	
GO
ALTER TABLE dbo.Cashs SET (LOCK_ESCALATION = TABLE)
GO
COMMIT
select Has_Perms_By_Name(N'dbo.Cashs', 'Object', 'ALTER') as ALT_Per, Has_Perms_By_Name(N'dbo.Cashs', 'Object', 'VIEW DEFINITION') as View_def_Per, Has_Perms_By_Name(N'dbo.Cashs', 'Object', 'CONTROL') as Contr_Per 

GO


GO

-- Accounts  آپدیت جدول  

-- ID ستون Identity حذف
/* To prevent any potential data loss issues, you should review this script in detail before running it outside the context of the database designer.*/
BEGIN TRANSACTION
SET QUOTED_IDENTIFIER ON
SET ARITHABORT ON
SET NUMERIC_ROUNDABORT OFF
SET CONCAT_NULL_YIELDS_NULL ON
SET ANSI_NULLS ON
SET ANSI_PADDING ON
SET ANSI_WARNINGS ON
COMMIT
BEGIN TRANSACTION
GO
ALTER TABLE dbo.Accounts
	DROP CONSTRAINT FK_CompanyAccount_tbl_Bank_tbl
GO
ALTER TABLE dbo.Banks SET (LOCK_ESCALATION = TABLE)
GO
COMMIT
select Has_Perms_By_Name(N'dbo.Banks', 'Object', 'ALTER') as ALT_Per, Has_Perms_By_Name(N'dbo.Banks', 'Object', 'VIEW DEFINITION') as View_def_Per, Has_Perms_By_Name(N'dbo.Banks', 'Object', 'CONTROL') as Contr_Per BEGIN TRANSACTION
GO
ALTER TABLE dbo.Accounts
	DROP CONSTRAINT FK_Accounts_DocHeader
GO
ALTER TABLE dbo.DocHeader SET (LOCK_ESCALATION = TABLE)
GO
COMMIT
select Has_Perms_By_Name(N'dbo.DocHeader', 'Object', 'ALTER') as ALT_Per, Has_Perms_By_Name(N'dbo.DocHeader', 'Object', 'VIEW DEFINITION') as View_def_Per, Has_Perms_By_Name(N'dbo.DocHeader', 'Object', 'CONTROL') as Contr_Per BEGIN TRANSACTION
GO
CREATE TABLE dbo.Tmp_Accounts
	(
	ID int NOT NULL,
	BankRef int NULL,
	Type nvarchar(MAX) NULL,
	Number nvarchar(MAX) NULL,
	FirstSupply money NOT NULL,
	Date datetime NULL,
	CurrentSupply money NOT NULL,
	Description nvarchar(MAX) NULL,
	CardNumber nvarchar(MAX) NULL,
	RowVersion timestamp NOT NULL,
	DocID int NULL
	)  ON [PRIMARY]
	 TEXTIMAGE_ON [PRIMARY]
GO
ALTER TABLE dbo.Tmp_Accounts SET (LOCK_ESCALATION = TABLE)
GO
IF EXISTS(SELECT * FROM dbo.Accounts)
	 EXEC('INSERT INTO dbo.Tmp_Accounts (ID, BankRef, Type, Number, FirstSupply, Date, CurrentSupply, Description, CardNumber, DocID)
		SELECT ID, BankRef, Type, Number, FirstSupply, Date, CurrentSupply, Description, CardNumber, DocID FROM dbo.Accounts WITH (HOLDLOCK TABLOCKX)')
GO
ALTER TABLE dbo.FishRecs
	DROP CONSTRAINT FK_FishRec_Account
GO
ALTER TABLE dbo.ChequePays
	DROP CONSTRAINT FK_ChequePay_Account
GO
ALTER TABLE dbo.ChequeRecs
	DROP CONSTRAINT FK_ChequeRec_Account
GO
ALTER TABLE dbo.BankActs
	DROP CONSTRAINT FK_BankAct_Account
GO
ALTER TABLE dbo.Capitals
	DROP CONSTRAINT FK_Capitals_Accounts
GO
ALTER TABLE dbo.ChequeRecActs
	DROP CONSTRAINT FK_ChequeRecAct_Account
GO
ALTER TABLE dbo.BankMovements
	DROP CONSTRAINT FK_BankMovement_Account
GO
ALTER TABLE dbo.BankMovements
	DROP CONSTRAINT FK_BankMovement_Account1
GO
DROP TABLE dbo.Accounts
GO
EXECUTE sp_rename N'dbo.Tmp_Accounts', N'Accounts', 'OBJECT' 
GO
ALTER TABLE dbo.Accounts ADD CONSTRAINT
	PK_CompanyAccount_tbl PRIMARY KEY CLUSTERED 
	(
	ID
	) WITH( STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]

GO
CREATE NONCLUSTERED INDEX DocIDIndex ON dbo.Accounts
	(
	DocID
	) WITH( STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
ALTER TABLE dbo.Accounts ADD CONSTRAINT
	FK_Accounts_DocHeader FOREIGN KEY
	(
	DocID
	) REFERENCES dbo.DocHeader
	(
	ID
	) ON UPDATE  CASCADE 
	 ON DELETE  NO ACTION 
	
GO
ALTER TABLE dbo.Accounts WITH NOCHECK ADD CONSTRAINT
	FK_CompanyAccount_tbl_Bank_tbl FOREIGN KEY
	(
	BankRef
	) REFERENCES dbo.Banks
	(
	ID
	) ON UPDATE  NO ACTION 
	 ON DELETE  NO ACTION 
	
GO
COMMIT
select Has_Perms_By_Name(N'dbo.Accounts', 'Object', 'ALTER') as ALT_Per, Has_Perms_By_Name(N'dbo.Accounts', 'Object', 'VIEW DEFINITION') as View_def_Per, Has_Perms_By_Name(N'dbo.Accounts', 'Object', 'CONTROL') as Contr_Per BEGIN TRANSACTION
GO
ALTER TABLE dbo.BankMovements WITH NOCHECK ADD CONSTRAINT
	FK_BankMovement_Account FOREIGN KEY
	(
	AccountRef1
	) REFERENCES dbo.Accounts
	(
	ID
	) ON UPDATE  NO ACTION 
	 ON DELETE  NO ACTION 
	
GO
ALTER TABLE dbo.BankMovements WITH NOCHECK ADD CONSTRAINT
	FK_BankMovement_Account1 FOREIGN KEY
	(
	AccountRef2
	) REFERENCES dbo.Accounts
	(
	ID
	) ON UPDATE  NO ACTION 
	 ON DELETE  NO ACTION 
	
GO
ALTER TABLE dbo.BankMovements SET (LOCK_ESCALATION = TABLE)
GO
COMMIT
select Has_Perms_By_Name(N'dbo.BankMovements', 'Object', 'ALTER') as ALT_Per, Has_Perms_By_Name(N'dbo.BankMovements', 'Object', 'VIEW DEFINITION') as View_def_Per, Has_Perms_By_Name(N'dbo.BankMovements', 'Object', 'CONTROL') as Contr_Per BEGIN TRANSACTION
GO
ALTER TABLE dbo.ChequeRecActs WITH NOCHECK ADD CONSTRAINT
	FK_ChequeRecAct_Account FOREIGN KEY
	(
	AccountRef
	) REFERENCES dbo.Accounts
	(
	ID
	) ON UPDATE  NO ACTION 
	 ON DELETE  NO ACTION 
	
GO
ALTER TABLE dbo.ChequeRecActs SET (LOCK_ESCALATION = TABLE)
GO
COMMIT
select Has_Perms_By_Name(N'dbo.ChequeRecActs', 'Object', 'ALTER') as ALT_Per, Has_Perms_By_Name(N'dbo.ChequeRecActs', 'Object', 'VIEW DEFINITION') as View_def_Per, Has_Perms_By_Name(N'dbo.ChequeRecActs', 'Object', 'CONTROL') as Contr_Per BEGIN TRANSACTION
GO
ALTER TABLE dbo.Capitals ADD CONSTRAINT
	FK_Capitals_Accounts FOREIGN KEY
	(
	AccountRef
	) REFERENCES dbo.Accounts
	(
	ID
	) ON UPDATE  NO ACTION 
	 ON DELETE  NO ACTION 
	
GO
ALTER TABLE dbo.Capitals SET (LOCK_ESCALATION = TABLE)
GO
COMMIT
select Has_Perms_By_Name(N'dbo.Capitals', 'Object', 'ALTER') as ALT_Per, Has_Perms_By_Name(N'dbo.Capitals', 'Object', 'VIEW DEFINITION') as View_def_Per, Has_Perms_By_Name(N'dbo.Capitals', 'Object', 'CONTROL') as Contr_Per BEGIN TRANSACTION
GO
ALTER TABLE dbo.BankActs WITH NOCHECK ADD CONSTRAINT
	FK_BankAct_Account FOREIGN KEY
	(
	AccountRef
	) REFERENCES dbo.Accounts
	(
	ID
	) ON UPDATE  NO ACTION 
	 ON DELETE  NO ACTION 
	
GO
ALTER TABLE dbo.BankActs SET (LOCK_ESCALATION = TABLE)
GO
COMMIT
select Has_Perms_By_Name(N'dbo.BankActs', 'Object', 'ALTER') as ALT_Per, Has_Perms_By_Name(N'dbo.BankActs', 'Object', 'VIEW DEFINITION') as View_def_Per, Has_Perms_By_Name(N'dbo.BankActs', 'Object', 'CONTROL') as Contr_Per BEGIN TRANSACTION
GO
ALTER TABLE dbo.ChequeRecs WITH NOCHECK ADD CONSTRAINT
	FK_ChequeRec_Account FOREIGN KEY
	(
	VagozarbeBank
	) REFERENCES dbo.Accounts
	(
	ID
	) ON UPDATE  NO ACTION 
	 ON DELETE  NO ACTION 
	
GO
ALTER TABLE dbo.ChequeRecs SET (LOCK_ESCALATION = TABLE)
GO
COMMIT
select Has_Perms_By_Name(N'dbo.ChequeRecs', 'Object', 'ALTER') as ALT_Per, Has_Perms_By_Name(N'dbo.ChequeRecs', 'Object', 'VIEW DEFINITION') as View_def_Per, Has_Perms_By_Name(N'dbo.ChequeRecs', 'Object', 'CONTROL') as Contr_Per BEGIN TRANSACTION
GO
ALTER TABLE dbo.ChequePays WITH NOCHECK ADD CONSTRAINT
	FK_ChequePay_Account FOREIGN KEY
	(
	AccountRef
	) REFERENCES dbo.Accounts
	(
	ID
	) ON UPDATE  NO ACTION 
	 ON DELETE  NO ACTION 
	
GO
ALTER TABLE dbo.ChequePays SET (LOCK_ESCALATION = TABLE)
GO
COMMIT
select Has_Perms_By_Name(N'dbo.ChequePays', 'Object', 'ALTER') as ALT_Per, Has_Perms_By_Name(N'dbo.ChequePays', 'Object', 'VIEW DEFINITION') as View_def_Per, Has_Perms_By_Name(N'dbo.ChequePays', 'Object', 'CONTROL') as Contr_Per BEGIN TRANSACTION
GO
ALTER TABLE dbo.FishRecs WITH NOCHECK ADD CONSTRAINT
	FK_FishRec_Account FOREIGN KEY
	(
	AccountRef
	) REFERENCES dbo.Accounts
	(
	ID
	) ON UPDATE  NO ACTION 
	 ON DELETE  NO ACTION 
	
GO
ALTER TABLE dbo.FishRecs SET (LOCK_ESCALATION = TABLE)
GO
COMMIT
select Has_Perms_By_Name(N'dbo.FishRecs', 'Object', 'ALTER') as ALT_Per, Has_Perms_By_Name(N'dbo.FishRecs', 'Object', 'VIEW DEFINITION') as View_def_Per, Has_Perms_By_Name(N'dbo.FishRecs', 'Object', 'CONTROL') as Contr_Per 

GO

INSERT INTO [dbo].[DocHeader]([ID],[RefTable],[RefID],[Date],[Subject],[Bed],[Bes])
select ROW_NUMBER() OVER (ORDER BY Accounts.id)+CASE WHEN (select top(1) ID from DocHeader order by ID DESC) IS NULL THEN 1 ELSE 
(select top(1) ID from DocHeader order by ID DESC) end,
 '30', id, CASE WHEN [date] is not null  THEN [date] else '2000-01-01' end, Number,0,0
from Accounts WHERE DocID IS NULL

GO

update Accounts set docid = (select id from DocHeader where [Subject]=Number)
WHERE DocID IS NULL

GO

INSERT INTO DetailAccounts(ID,CodingRef,RefTable,RefID,GroupRef,Name,[First],Creditor,Debtor,Remain,CurrencyRef)
SELECT CAST('110200000' AS int)+ID,'1102', '30',ID,null,Number,FirstSupply, 0, 0, 0,
(SELECT CurrencyRef from dbo.CashBox where ID = 1)
from Accounts

GO

INSERT INTO [dbo].[Transaction]
           ([Date],[TypeRef],[DocRef],[CodingRef],[AccountRef],[CurrencyRef],[Creditor],[Debtor],[CreditorRemain],[DebtorRemain],[ToBaseCurrencyRatio],[Description],IDRef)
SELECT CASE WHEN [date] is not null  THEN [date] else '2000-01-01' end,'30',DocID, '310104',CAST('110200000' AS int)+ID,
(SELECT CurrencyRef from dbo.CashBox where ID = 1),
CASE WHEN FirstSupply > 0  THEN abs(FirstSupply) else CAST('0' AS money) end,
CASE WHEN FirstSupply < 0  THEN abs(FirstSupply) else CAST('0' AS money) end,0,0,0,N'بونی دەسپێک', ID
from Accounts

GO

ALTER TABLE Accounts ADD AccountRef INT NULL
GO
Update Accounts set AccountRef = (select id from DetailAccounts where CodingRef='1102' AND RefTable=30 AND RefID=Accounts.ID)
GO
ALTER TABLE Accounts ALTER COLUMN [AccountRef] INT NOT NULL
GO
ALTER TABLE Accounts ADD CONSTRAINT FK_BankAccounts_Accounts FOREIGN KEY (AccountRef) REFERENCES DetailAccounts(ID) 

GO

ALTER TABLE Accounts ADD FirstTransactionRef INT NULL
GO
Update Accounts set FirstTransactionRef = (select ID from [Transaction] where TypeRef=30 AND DocRef=Accounts.DocID 
AND CodingRef='310104' AND AccountRef='110200000'+ Accounts.ID)
GO
ALTER TABLE Accounts ALTER COLUMN FirstTransactionRef INT NOT NULL
GO
ALTER TABLE Accounts ADD CONSTRAINT FK_BankAccount_Transaction FOREIGN KEY (FirstTransactionRef) REFERENCES [Transaction](ID) 

GO

ALTER TABLE Accounts ALTER COLUMN BankRef INT NOT NULL
ALTER TABLE Accounts ALTER COLUMN [Type] nvarchar(200) NULL
ALTER TABLE Accounts ALTER COLUMN Number nvarchar(200) NULL
ALTER TABLE Accounts ALTER COLUMN [Date] datetime2(7)
ALTER TABLE Accounts ALTER COLUMN CardNumber nvarchar(200) NULL
ALTER TABLE Accounts DROP COLUMN FirstSupply
ALTER TABLE Accounts DROP COLUMN CurrentSupply

GO

EXEC sp_rename 'Accounts', 'BankAccounts'

GO

-- BankActs  آپدیت جدول  

INSERT INTO [dbo].[DocHeader]([ID],[RefTable],[RefID],[Date],[Subject],[Bed],[Bes])
select ROW_NUMBER() OVER (ORDER BY BankActs.ID)+CASE WHEN (select top(1) ID from DocHeader order by ID DESC) IS NULL THEN 1 ELSE 
(select top(1) ID from DocHeader order by ID DESC) end,
 '33', ID, CASE WHEN [Date] is not null  THEN [Date] else '2000-01-01' end, CAST(BankActs.ID+BankActs.Amount AS NVARCHAR)+'BankActs', 0, 0
from BankActs WHERE DocID IS NULL

GO

update BankActs set docid = (select id from DocHeader where [Subject] = CAST(BankActs.ID+BankActs.Amount AS NVARCHAR)+'BankActs')
WHERE DocID IS NULL

GO

INSERT INTO [dbo].[Transaction]
           ([Date],[TypeRef],[DocRef],[CodingRef],[AccountRef],[CurrencyRef],[Creditor],[Debtor],[CreditorRemain],[DebtorRemain],[ToBaseCurrencyRatio],[Description],IDRef)
SELECT [Date],'33',DocID, '1102',CAST('110200000' AS int)+AccountRef,
(SELECT CurrencyRef from dbo.CashBox where ID=1), 0, Amount, 0, 0, 0, N'هه‌ڵگرتن له حیساب و رژاندن به ده‌خل',ID
from BankActs WHERE InOrOut=0

GO

INSERT INTO [dbo].[Transaction]
           ([Date],[TypeRef],[DocRef],[CodingRef],[AccountRef],[CurrencyRef],[Creditor],[Debtor],[CreditorRemain],[DebtorRemain],[ToBaseCurrencyRatio],[Description],IDRef)
SELECT [Date],'33',DocID, '1101',CAST('110100000' AS int)+CashBoxRef,
(SELECT CurrencyRef from dbo.CashBox where ID=1), Amount, 0, 0, 0, 0, N'هه‌ڵگرتن له حیساب و رژاندن به ده‌خل',ID
from BankActs WHERE InOrOut=0

GO

INSERT INTO [dbo].[Transaction]
           ([Date],[TypeRef],[DocRef],[CodingRef],[AccountRef],[CurrencyRef],[Creditor],[Debtor],[CreditorRemain],[DebtorRemain],[ToBaseCurrencyRatio],[Description],IDRef)
SELECT [Date],'33',DocID, '1102',CAST('110200000' AS int)+AccountRef,
(SELECT CurrencyRef from dbo.CashBox where ID=1), Amount, 0, 0, 0, 0, N'هه‌ڵگرتن له ده‌خل و رژاندن به حیساب',ID
from BankActs WHERE InOrOut=1

GO

INSERT INTO [dbo].[Transaction]
           ([Date],[TypeRef],[DocRef],[CodingRef],[AccountRef],[CurrencyRef],[Creditor],[Debtor],[CreditorRemain],[DebtorRemain],[ToBaseCurrencyRatio],[Description],IDRef)
SELECT [Date],'33',DocID, '1101',CAST('110100000' AS int)+CashBoxRef,
(SELECT CurrencyRef from dbo.CashBox where ID=1), 0, Amount, 0, 0, 0, N'هه‌ڵگرتن له ده‌خل و رژاندن به حیساب',ID
from BankActs WHERE InOrOut=1

GO

ALTER TABLE BankActs ALTER COLUMN CashBoxRef INT NOT NULL

GO

ALTER TABLE BankActs ALTER COLUMN [Date] datetime2(7) NOT NULL

GO

ALTER TABLE BankActs ADD CashBoxTransactionRef INT NULL
GO
ALTER TABLE BankActs ADD CONSTRAINT FK_BankActs_Transaction FOREIGN KEY (CashBoxTransactionRef) REFERENCES [Transaction](ID)
GO
ALTER TABLE BankActs ADD BankAccountTransactionRef INT NULL
GO
ALTER TABLE BankActs ADD CONSTRAINT FK_BankActs_Transaction1 FOREIGN KEY (BankAccountTransactionRef) REFERENCES [Transaction](ID)

GO

Update BankActs set CashBoxTransactionRef = (select ID from [Transaction] where TypeRef=33 AND DocRef=BankActs.DocID 
AND CodingRef='1101' AND AccountRef='110100000'+ BankActs.CashBoxRef AND IDRef=BankActs.ID)

GO

Update BankActs set BankAccountTransactionRef = (select ID from [Transaction] where TypeRef=33 AND DocRef=BankActs.DocID 
AND CodingRef='1102' AND AccountRef='110200000'+ BankActs.AccountRef AND IDRef=BankActs.ID)

GO

ALTER TABLE BankActs ALTER COLUMN CashboxTransactionRef INT NOT NULL
GO
ALTER TABLE BankActs ALTER COLUMN BankAccountTransactionRef INT NOT NULL

GO

-- BankMovements  آپدیت جدول  

EXEC sp_RENAME 'BankMovements.AccountRef1', 'SrcAccountRef', 'COLUMN'
GO
EXEC sp_RENAME 'BankMovements.AccountRef2', 'DesAccountRef', 'COLUMN'

GO

INSERT INTO [dbo].[DocHeader]([ID],[RefTable],[RefID],[Date],[Subject],[Bed],[Bes])
select ROW_NUMBER() OVER (ORDER BY BankMovements.ID)+CASE WHEN (select top(1) ID from DocHeader order by ID DESC) IS NULL THEN 1 ELSE 
(select top(1) ID from DocHeader order by ID DESC) end,
 '32', ID, CASE WHEN [Date] is not null  THEN [Date] else '2000-01-01' end, CAST(BankMovements.ID+BankMovements.Amount AS NVARCHAR)+'BankMovements', 0, 0
from BankMovements WHERE DocID IS NULL

GO

update BankMovements set docid = (select id from DocHeader where [Subject] = CAST(BankMovements.ID+BankMovements.Amount AS NVARCHAR)+'BankMovements')
WHERE DocID IS NULL

GO

INSERT INTO [dbo].[Transaction]
           ([Date],[TypeRef],[DocRef],[CodingRef],[AccountRef],[CurrencyRef],[Creditor],[Debtor],[CreditorRemain],[DebtorRemain],[ToBaseCurrencyRatio],[Description],IDRef)
SELECT [Date],'32',DocID, '1102',CAST('110200000' AS int)+SrcAccountRef,
(SELECT CurrencyRef from dbo.CashBox where ID=1), 0, Amount, 0, 0, 0, N'هه‌ڵگرتن له حیساب',ID
from BankMovements

GO

INSERT INTO [dbo].[Transaction]
           ([Date],[TypeRef],[DocRef],[CodingRef],[AccountRef],[CurrencyRef],[Creditor],[Debtor],[CreditorRemain],[DebtorRemain],[ToBaseCurrencyRatio],[Description],IDRef)
SELECT [Date],'32',DocID, '1102',CAST('110200000' AS int)+DesAccountRef,
(SELECT CurrencyRef from dbo.CashBox where ID=1), Amount, 0, 0, 0, 0, N'ڕژاندن به حیساب',ID
from BankMovements

GO

ALTER TABLE BankMovements ALTER COLUMN [Date] datetime2(7) NOT NULL

GO

ALTER TABLE BankMovements drop FK_BankMovement_Account
GO
ALTER TABLE BankMovements ADD CONSTRAINT FK_BankMovement_AccountSrc FOREIGN KEY (SrcAccountRef) REFERENCES BankAccounts(ID)
GO

ALTER TABLE BankMovements drop FK_BankMovement_Account1
GO
ALTER TABLE BankMovements ADD CONSTRAINT FK_BankMovement_AccountDes FOREIGN KEY (DesAccountRef) REFERENCES BankAccounts(ID)

GO

ALTER TABLE BankMovements ADD BankAccountSrcTransactionRef INT NULL
GO
ALTER TABLE BankMovements ADD CONSTRAINT FK_BankMovement_BankAccountSrcTransaction FOREIGN KEY (BankAccountSrcTransactionRef) REFERENCES [Transaction](ID)
GO
ALTER TABLE BankMovements ADD BankAccountDesTransactionRef INT NULL
GO
ALTER TABLE BankMovements ADD CONSTRAINT FK_BankMovement_BankAccountDesTransaction FOREIGN KEY (BankAccountDesTransactionRef) REFERENCES [Transaction](ID)

GO

Update BankMovements set BankAccountSrcTransactionRef = (select ID from [Transaction] where TypeRef=32 AND DocRef=BankMovements.DocID 
AND CodingRef='1102' AND AccountRef='110200000'+ BankMovements.SrcAccountRef AND IDRef=BankMovements.ID)

GO

Update BankMovements set BankAccountDesTransactionRef = (select ID from [Transaction] where TypeRef=32 AND DocRef=BankMovements.DocID 
AND CodingRef='1102' AND AccountRef='110200000'+ BankMovements.DesAccountRef AND IDRef=BankMovements.ID)

GO

ALTER TABLE BankMovements ALTER COLUMN BankAccountSrcTransactionRef INT NOT NULL
GO
ALTER TABLE BankMovements ALTER COLUMN BankAccountDesTransactionRef INT NOT NULL

GO


-- Banks  آپدیت جدول  

ALTER TABLE Banks ALTER COLUMN Name nvarchar(300) NOT NULL
ALTER TABLE Banks ALTER COLUMN BranchName nvarchar(300) NULL
ALTER TABLE Banks ALTER COLUMN Branchcode nvarchar(300) NULL
ALTER TABLE Banks ALTER COLUMN [Address] nvarchar(1000) NULL
ALTER TABLE Banks ALTER COLUMN Fax varchar(50) NULL

GO

-- Customers  آپدیت جدول  

INSERT INTO [dbo].[DocHeader]([ID],[RefTable],[RefID],[Date],[Subject],[Bed],[Bes])
select ROW_NUMBER() OVER (ORDER BY Customers.id)+CASE WHEN (select top(1) ID from DocHeader order by ID DESC) IS NULL THEN 1 ELSE 
(select top(1) ID from DocHeader order by ID DESC) end,
 '38', id, CASE WHEN DateCreate is not null  THEN DateCreate else '2000-01-01' end,Name,0,0
from Customers WHERE DocID IS NULL

GO

update Customers set docid = (select id from DocHeader where [Subject] = Name)
WHERE DocID IS NULL

GO

INSERT INTO DetailAccounts(ID,CodingRef,RefTable,RefID,GroupRef,Name,[First],Creditor,Debtor,Remain,CurrencyRef)
SELECT CAST('110300000' AS int)+ID,'1103', '38',ID,null,Name,FirstPrice, 0, 0, 0,
(SELECT CurrencyRef from dbo.CashBox where ID = 1)
from Customers

GO

INSERT INTO [dbo].[Transaction]
           ([Date],[TypeRef],[DocRef],[CodingRef],[AccountRef],[CurrencyRef],[Creditor],[Debtor],[CreditorRemain],[DebtorRemain],[ToBaseCurrencyRatio],[Description],IDRef)
SELECT CASE WHEN DateCreate is not null  THEN DateCreate else '2000-01-01' end,'38',DocID, '310105',CAST('110300000' AS int)+ID,
(SELECT CurrencyRef from dbo.CashBox where ID = 1),
CASE WHEN FirstPrice > 0  THEN abs(FirstPrice) else CAST('0' AS money) end,
CASE WHEN FirstPrice < 0  THEN abs(FirstPrice) else CAST('0' AS money) end, 0, 0, 0, N'بونی دەسپێک', ID
from Customers

GO

ALTER TABLE Customers ADD AccountRef INT NULL
GO
Update Customers set AccountRef = (select ID from DetailAccounts where CodingRef='1103' AND RefTable=38 AND RefID=Customers.ID)
GO
ALTER TABLE Customers ALTER COLUMN [AccountRef] INT NOT NULL
GO
ALTER TABLE Customers ADD CONSTRAINT FK_Customers_Accounts FOREIGN KEY (AccountRef) REFERENCES DetailAccounts(ID) 

GO

ALTER TABLE Customers ADD FirstTransactionRef INT NULL
GO

Update Customers set FirstTransactionRef = (select ID from [Transaction] where TypeRef=38 AND DocRef=Customers.DocID 
AND CodingRef='310105' AND AccountRef='110300000'+ Customers.ID)
GO
ALTER TABLE Customers ALTER COLUMN FirstTransactionRef INT NOT NULL
GO
ALTER TABLE Customers ADD CONSTRAINT FK_Customers_Transaction FOREIGN KEY (FirstTransactionRef) REFERENCES [Transaction](ID) 

GO


--DECLARE @SQL NVARCHAR(MAX) = N'';
--SELECT @SQL += N'
--ALTER TABLE ' + OBJECT_NAME(PARENT_OBJECT_ID) + ' DROP CONSTRAINT ' + OBJECT_NAME(OBJECT_ID) + ';' 
--FROM SYS.OBJECTS
--WHERE TYPE_DESC LIKE '%CONSTRAINT' AND OBJECT_NAME(PARENT_OBJECT_ID) = 'Customers' AND type = 'D';
----PRINT @SQL
--EXECUTE(@SQL)

GO

ALTER TABLE Customers ALTER COLUMN Code nvarchar(100) NULL
ALTER TABLE Customers ALTER COLUMN Name nvarchar(300) NULL
ALTER TABLE Customers ALTER COLUMN [Address] nvarchar(1000) NULL
ALTER TABLE Customers ALTER COLUMN Pic nvarchar(1000) NULL			
ALTER TABLE Customers ALTER COLUMN UntoldLastDate datetime2(7)
ALTER TABLE Customers ALTER COLUMN Email nvarchar(200) NULL
ALTER TABLE Customers ALTER COLUMN DateCreate datetime2(7)
ALTER TABLE Customers ALTER COLUMN NationalCode nvarchar(200) NULL
ALTER TABLE Customers ALTER COLUMN PostCode nvarchar(200) NULL
ALTER TABLE Customers ALTER COLUMN EconomicCode nvarchar(200) NULL
ALTER TABLE Customers ALTER COLUMN Province nvarchar(200) NULL
ALTER TABLE Customers ALTER COLUMN TownShip nvarchar(200) NULL
ALTER TABLE Customers ALTER COLUMN Town nvarchar(200) NULL
ALTER TABLE Customers ALTER COLUMN [Date] datetime2(7)

GO
DECLARE @sql nvarchar(max)
SELECT @sql = 'ALTER TABLE Customers DROP CONSTRAINT ' + df.NAME 
FROM sys.default_constraints df
  INNER JOIN sys.tables t ON df.parent_object_id = t.object_id
  INNER JOIN sys.columns c ON df.parent_object_id = c.object_id AND df.parent_column_id = c.column_id
where t.name = 'Customers' and c.name = 'FirstPrice'
EXEC sp_executeSql @sql
GO
ALTER TABLE Customers DROP COLUMN FirstPrice

GO
DECLARE @sql nvarchar(max)
SELECT @sql = 'ALTER TABLE Customers DROP CONSTRAINT ' + df.NAME 
FROM sys.default_constraints df
  INNER JOIN sys.tables t ON df.parent_object_id = t.object_id
  INNER JOIN sys.columns c ON df.parent_object_id = c.object_id AND df.parent_column_id = c.column_id
where t.name = 'Customers' and c.name = 'SumPrice'
EXEC sp_executeSql @sql
GO
ALTER TABLE Customers  DROP COLUMN SumPrice

GO

-- ID ستون Identity حذف 
/* To prevent any potential data loss issues, you should review this script in detail before running it outside the context of the database designer.*/
BEGIN TRANSACTION
SET QUOTED_IDENTIFIER ON
SET ARITHABORT ON
SET NUMERIC_ROUNDABORT OFF
SET CONCAT_NULL_YIELDS_NULL ON
SET ANSI_NULLS ON
SET ANSI_PADDING ON
SET ANSI_WARNINGS ON
COMMIT
BEGIN TRANSACTION
GO
ALTER TABLE dbo.Customers
	DROP CONSTRAINT FK_Customers_Transaction
GO
ALTER TABLE dbo.[Transaction] SET (LOCK_ESCALATION = TABLE)
GO
COMMIT
select Has_Perms_By_Name(N'dbo.[Transaction]', 'Object', 'ALTER') as ALT_Per, Has_Perms_By_Name(N'dbo.[Transaction]', 'Object', 'VIEW DEFINITION') as View_def_Per, Has_Perms_By_Name(N'dbo.[Transaction]', 'Object', 'CONTROL') as Contr_Per BEGIN TRANSACTION
GO
ALTER TABLE dbo.Customers
	DROP CONSTRAINT FK_Customers_Accounts
GO
ALTER TABLE dbo.DetailAccounts SET (LOCK_ESCALATION = TABLE)
GO
COMMIT
select Has_Perms_By_Name(N'dbo.DetailAccounts', 'Object', 'ALTER') as ALT_Per, Has_Perms_By_Name(N'dbo.DetailAccounts', 'Object', 'VIEW DEFINITION') as View_def_Per, Has_Perms_By_Name(N'dbo.DetailAccounts', 'Object', 'CONTROL') as Contr_Per BEGIN TRANSACTION
GO
ALTER TABLE dbo.Customers
	DROP CONSTRAINT FK_Customers_ItemGroup1
GO
ALTER TABLE dbo.Customers
	DROP CONSTRAINT FK_Customers_ItemGroup
GO
ALTER TABLE dbo.ItemGroup SET (LOCK_ESCALATION = TABLE)
GO
COMMIT
select Has_Perms_By_Name(N'dbo.ItemGroup', 'Object', 'ALTER') as ALT_Per, Has_Perms_By_Name(N'dbo.ItemGroup', 'Object', 'VIEW DEFINITION') as View_def_Per, Has_Perms_By_Name(N'dbo.ItemGroup', 'Object', 'CONTROL') as Contr_Per BEGIN TRANSACTION
GO
ALTER TABLE dbo.Customers
	DROP CONSTRAINT FK_Customers_DocHeader
GO
ALTER TABLE dbo.DocHeader SET (LOCK_ESCALATION = TABLE)
GO
COMMIT
select Has_Perms_By_Name(N'dbo.DocHeader', 'Object', 'ALTER') as ALT_Per, Has_Perms_By_Name(N'dbo.DocHeader', 'Object', 'VIEW DEFINITION') as View_def_Per, Has_Perms_By_Name(N'dbo.DocHeader', 'Object', 'CONTROL') as Contr_Per BEGIN TRANSACTION
GO

DECLARE @sql nvarchar(max)
SELECT @sql = 'ALTER TABLE Customers DROP CONSTRAINT ' + df.NAME 
FROM sys.default_constraints df
  INNER JOIN sys.tables t ON df.parent_object_id = t.object_id
  INNER JOIN sys.columns c ON df.parent_object_id = c.object_id AND df.parent_column_id = c.column_id
where t.name = 'Customers' and c.name = 'SumBuy'
EXEC sp_executeSql @sql
GO
DECLARE @sql nvarchar(max)
SELECT @sql = 'ALTER TABLE Customers DROP CONSTRAINT ' + df.NAME 
FROM sys.default_constraints df
  INNER JOIN sys.tables t ON df.parent_object_id = t.object_id
  INNER JOIN sys.columns c ON df.parent_object_id = c.object_id AND df.parent_column_id = c.column_id
where t.name = 'Customers' and c.name = 'Rank'
EXEC sp_executeSql @sql
GO
DECLARE @sql nvarchar(max)
SELECT @sql = 'ALTER TABLE Customers DROP CONSTRAINT ' + df.NAME 
FROM sys.default_constraints df
  INNER JOIN sys.tables t ON df.parent_object_id = t.object_id
  INNER JOIN sys.columns c ON df.parent_object_id = c.object_id AND df.parent_column_id = c.column_id
where t.name = 'Customers' and c.name = 'Credit'
EXEC sp_executeSql @sql

GO
CREATE TABLE dbo.Tmp_Customers
	(
	ID int NOT NULL,
	Code nvarchar(100) NULL,
	Name nvarchar(300) NULL,
	Description nvarchar(MAX) NULL,
	Tel varchar(15) NULL,
	Mobile varchar(15) NULL,
	Fax varchar(50) NULL,
	Address nvarchar(1000) NULL,
	Pic nvarchar(1000) NULL,
	UntoldLastDate datetime2(7) NULL,
	Email nvarchar(200) NULL,
	DateCreate datetime2(7) NULL,
	Active bit NULL,
	NationalCode nvarchar(200) NULL,
	PostCode nvarchar(200) NULL,
	EconomicCode nvarchar(200) NULL,
	Province nvarchar(200) NULL,
	TownShip nvarchar(200) NULL,
	Town nvarchar(200) NULL,
	ItemGroupRef int NULL,
	Type nvarchar(50) NULL,
	RowVersion timestamp NOT NULL,
	PerDayFactor bit NULL,
	SumBuy money NOT NULL,
	Rank int NOT NULL,
	Credit money NOT NULL,
	DocID int NULL,
	Date datetime2(7) NULL,
	TypeRef int NULL,
	VisitorRef int NULL,
	AccountRef int NOT NULL,
	FirstTransactionRef int NOT NULL
	)  ON [PRIMARY]
	 TEXTIMAGE_ON [PRIMARY]
GO
ALTER TABLE dbo.Tmp_Customers SET (LOCK_ESCALATION = TABLE)
GO
ALTER TABLE dbo.Tmp_Customers ADD CONSTRAINT
	DF__Customers__SumBu__414EAC47 DEFAULT ((0)) FOR SumBuy
GO
ALTER TABLE dbo.Tmp_Customers ADD CONSTRAINT
	DF__Customers__Rank__4242D080 DEFAULT ((0)) FOR Rank
GO
ALTER TABLE dbo.Tmp_Customers ADD CONSTRAINT
	DF__Customers__Credi__4336F4B9 DEFAULT ((0)) FOR Credit
GO
IF EXISTS(SELECT * FROM dbo.Customers)
	 EXEC('INSERT INTO dbo.Tmp_Customers (ID, Code, Name, Description, Tel, Mobile, Fax, Address, Pic, UntoldLastDate, Email, DateCreate, Active, NationalCode, PostCode, EconomicCode, Province, TownShip, Town, ItemGroupRef, Type, PerDayFactor, SumBuy, Rank, Credit, DocID, Date, TypeRef, VisitorRef, AccountRef, FirstTransactionRef)
		SELECT ID, Code, Name, Description, Tel, Mobile, Fax, Address, Pic, UntoldLastDate, Email, DateCreate, Active, NationalCode, PostCode, EconomicCode, Province, TownShip, Town, ItemGroupRef, Type, PerDayFactor, SumBuy, Rank, Credit, DocID, Date, TypeRef, VisitorRef, AccountRef, FirstTransactionRef FROM dbo.Customers WITH (HOLDLOCK TABLOCKX)')
GO
ALTER TABLE dbo.FishPays
	DROP CONSTRAINT FK_FishPay_Customer
GO
ALTER TABLE dbo.FishRecs
	DROP CONSTRAINT FK_FishRec_tbl_Customer_tbl
GO
ALTER TABLE dbo.Cashs
	DROP CONSTRAINT FK_Cash_Customer
GO
ALTER TABLE dbo.InOuts
	DROP CONSTRAINT FK_InOuts_Customers
GO
ALTER TABLE dbo.Customers
	DROP CONSTRAINT FK_Customers_Customers
GO
ALTER TABLE dbo.Assets
	DROP CONSTRAINT FK_Assets_Customers
GO
ALTER TABLE dbo.Assets
	DROP CONSTRAINT FK_Assets_Customers1
GO
ALTER TABLE dbo.ChequePays
	DROP CONSTRAINT FK_ChequePay_Customer
GO
ALTER TABLE dbo.ChequeRecActs
	DROP CONSTRAINT FK_ChequeRecAct_Customer
GO
ALTER TABLE dbo.ChequeRecs
	DROP CONSTRAINT FK_ChequeRec_Customer
GO
ALTER TABLE dbo.Factors
	DROP CONSTRAINT FK_Factors_CustomersVisitor
GO
ALTER TABLE dbo.ChequeRecs
	DROP CONSTRAINT FK_ChequeRec_tbl_Customer_tbl
GO
ALTER TABLE dbo.Factors
	DROP CONSTRAINT FK_FactorBuy_Customer
GO
ALTER TABLE dbo.Costuses
	DROP CONSTRAINT FK_Costus_tbl_Customer_tbl
GO
DROP TABLE dbo.Customers
GO
EXECUTE sp_rename N'dbo.Tmp_Customers', N'Customers', 'OBJECT' 
GO
ALTER TABLE dbo.Customers ADD CONSTRAINT
	PK_Customer_tbl PRIMARY KEY CLUSTERED 
	(
	ID
	) WITH( STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]

GO
ALTER TABLE dbo.Customers ADD CONSTRAINT
	FK_Customers_DocHeader FOREIGN KEY
	(
	DocID
	) REFERENCES dbo.DocHeader
	(
	ID
	) ON UPDATE  NO ACTION 
	 ON DELETE  NO ACTION 
	
GO
ALTER TABLE dbo.Customers ADD CONSTRAINT
	FK_Customers_ItemGroup1 FOREIGN KEY
	(
	TypeRef
	) REFERENCES dbo.ItemGroup
	(
	ID
	) ON UPDATE  NO ACTION 
	 ON DELETE  NO ACTION 
	
GO
ALTER TABLE dbo.Customers ADD CONSTRAINT
	FK_Customers_Customers FOREIGN KEY
	(
	VisitorRef
	) REFERENCES dbo.Customers
	(
	ID
	) ON UPDATE  NO ACTION 
	 ON DELETE  NO ACTION 
	
GO
ALTER TABLE dbo.Customers ADD CONSTRAINT
	FK_Customers_ItemGroup FOREIGN KEY
	(
	ItemGroupRef
	) REFERENCES dbo.ItemGroup
	(
	ID
	) ON UPDATE  NO ACTION 
	 ON DELETE  NO ACTION 
	
GO
ALTER TABLE dbo.Customers ADD CONSTRAINT
	FK_Customers_Accounts FOREIGN KEY
	(
	AccountRef
	) REFERENCES dbo.DetailAccounts
	(
	ID
	) ON UPDATE  NO ACTION 
	 ON DELETE  NO ACTION 
	
GO
ALTER TABLE dbo.Customers ADD CONSTRAINT
	FK_Customers_Transaction FOREIGN KEY
	(
	FirstTransactionRef
	) REFERENCES dbo.[Transaction]
	(
	ID
	) ON UPDATE  NO ACTION 
	 ON DELETE  NO ACTION 
	
GO
COMMIT
select Has_Perms_By_Name(N'dbo.Customers', 'Object', 'ALTER') as ALT_Per, Has_Perms_By_Name(N'dbo.Customers', 'Object', 'VIEW DEFINITION') as View_def_Per, Has_Perms_By_Name(N'dbo.Customers', 'Object', 'CONTROL') as Contr_Per BEGIN TRANSACTION
GO
ALTER TABLE dbo.Costuses WITH NOCHECK ADD CONSTRAINT
	FK_Costus_tbl_Customer_tbl FOREIGN KEY
	(
	CustomerRef
	) REFERENCES dbo.Customers
	(
	ID
	) ON UPDATE  NO ACTION 
	 ON DELETE  NO ACTION 
	
GO
ALTER TABLE dbo.Costuses SET (LOCK_ESCALATION = TABLE)
GO
COMMIT
select Has_Perms_By_Name(N'dbo.Costuses', 'Object', 'ALTER') as ALT_Per, Has_Perms_By_Name(N'dbo.Costuses', 'Object', 'VIEW DEFINITION') as View_def_Per, Has_Perms_By_Name(N'dbo.Costuses', 'Object', 'CONTROL') as Contr_Per BEGIN TRANSACTION
GO
ALTER TABLE dbo.Factors ADD CONSTRAINT
	FK_Factors_CustomersVisitor FOREIGN KEY
	(
	VisitorRef
	) REFERENCES dbo.Customers
	(
	ID
	) ON UPDATE  NO ACTION 
	 ON DELETE  NO ACTION 
	
GO
ALTER TABLE dbo.Factors WITH NOCHECK ADD CONSTRAINT
	FK_FactorBuy_Customer FOREIGN KEY
	(
	CustomerRef
	) REFERENCES dbo.Customers
	(
	ID
	) ON UPDATE  NO ACTION 
	 ON DELETE  NO ACTION 
	
GO
ALTER TABLE dbo.Factors SET (LOCK_ESCALATION = TABLE)
GO
COMMIT
select Has_Perms_By_Name(N'dbo.Factors', 'Object', 'ALTER') as ALT_Per, Has_Perms_By_Name(N'dbo.Factors', 'Object', 'VIEW DEFINITION') as View_def_Per, Has_Perms_By_Name(N'dbo.Factors', 'Object', 'CONTROL') as Contr_Per BEGIN TRANSACTION
GO
ALTER TABLE dbo.ChequeRecs WITH NOCHECK ADD CONSTRAINT
	FK_ChequeRec_Customer FOREIGN KEY
	(
	VagozarbeShakhs
	) REFERENCES dbo.Customers
	(
	ID
	) ON UPDATE  NO ACTION 
	 ON DELETE  NO ACTION 
	
GO
ALTER TABLE dbo.ChequeRecs WITH NOCHECK ADD CONSTRAINT
	FK_ChequeRec_tbl_Customer_tbl FOREIGN KEY
	(
	CustomerRef
	) REFERENCES dbo.Customers
	(
	ID
	) ON UPDATE  NO ACTION 
	 ON DELETE  NO ACTION 
	
GO
ALTER TABLE dbo.ChequeRecs SET (LOCK_ESCALATION = TABLE)
GO
COMMIT
select Has_Perms_By_Name(N'dbo.ChequeRecs', 'Object', 'ALTER') as ALT_Per, Has_Perms_By_Name(N'dbo.ChequeRecs', 'Object', 'VIEW DEFINITION') as View_def_Per, Has_Perms_By_Name(N'dbo.ChequeRecs', 'Object', 'CONTROL') as Contr_Per BEGIN TRANSACTION
GO
ALTER TABLE dbo.ChequeRecActs WITH NOCHECK ADD CONSTRAINT
	FK_ChequeRecAct_Customer FOREIGN KEY
	(
	CustomerRef
	) REFERENCES dbo.Customers
	(
	ID
	) ON UPDATE  NO ACTION 
	 ON DELETE  NO ACTION 
	
GO
ALTER TABLE dbo.ChequeRecActs SET (LOCK_ESCALATION = TABLE)
GO
COMMIT
select Has_Perms_By_Name(N'dbo.ChequeRecActs', 'Object', 'ALTER') as ALT_Per, Has_Perms_By_Name(N'dbo.ChequeRecActs', 'Object', 'VIEW DEFINITION') as View_def_Per, Has_Perms_By_Name(N'dbo.ChequeRecActs', 'Object', 'CONTROL') as Contr_Per BEGIN TRANSACTION
GO
ALTER TABLE dbo.ChequePays WITH NOCHECK ADD CONSTRAINT
	FK_ChequePay_Customer FOREIGN KEY
	(
	CustomerRef
	) REFERENCES dbo.Customers
	(
	ID
	) ON UPDATE  NO ACTION 
	 ON DELETE  NO ACTION 
	
GO
ALTER TABLE dbo.ChequePays SET (LOCK_ESCALATION = TABLE)
GO
COMMIT
select Has_Perms_By_Name(N'dbo.ChequePays', 'Object', 'ALTER') as ALT_Per, Has_Perms_By_Name(N'dbo.ChequePays', 'Object', 'VIEW DEFINITION') as View_def_Per, Has_Perms_By_Name(N'dbo.ChequePays', 'Object', 'CONTROL') as Contr_Per BEGIN TRANSACTION
GO
ALTER TABLE dbo.Assets ADD CONSTRAINT
	FK_Assets_Customers FOREIGN KEY
	(
	BuyCustomerRef
	) REFERENCES dbo.Customers
	(
	ID
	) ON UPDATE  NO ACTION 
	 ON DELETE  NO ACTION 
	
GO
ALTER TABLE dbo.Assets ADD CONSTRAINT
	FK_Assets_Customers1 FOREIGN KEY
	(
	SellCustomerRef
	) REFERENCES dbo.Customers
	(
	ID
	) ON UPDATE  NO ACTION 
	 ON DELETE  NO ACTION 
	
GO
ALTER TABLE dbo.Assets SET (LOCK_ESCALATION = TABLE)
GO
COMMIT
select Has_Perms_By_Name(N'dbo.Assets', 'Object', 'ALTER') as ALT_Per, Has_Perms_By_Name(N'dbo.Assets', 'Object', 'VIEW DEFINITION') as View_def_Per, Has_Perms_By_Name(N'dbo.Assets', 'Object', 'CONTROL') as Contr_Per BEGIN TRANSACTION
GO
ALTER TABLE dbo.InOuts ADD CONSTRAINT
	FK_InOuts_Customers FOREIGN KEY
	(
	CustomerRef
	) REFERENCES dbo.Customers
	(
	ID
	) ON UPDATE  NO ACTION 
	 ON DELETE  NO ACTION 
	
GO
ALTER TABLE dbo.InOuts SET (LOCK_ESCALATION = TABLE)
GO
COMMIT
select Has_Perms_By_Name(N'dbo.InOuts', 'Object', 'ALTER') as ALT_Per, Has_Perms_By_Name(N'dbo.InOuts', 'Object', 'VIEW DEFINITION') as View_def_Per, Has_Perms_By_Name(N'dbo.InOuts', 'Object', 'CONTROL') as Contr_Per BEGIN TRANSACTION
GO
ALTER TABLE dbo.Cashs WITH NOCHECK ADD CONSTRAINT
	FK_Cash_Customer FOREIGN KEY
	(
	CustomerRef
	) REFERENCES dbo.Customers
	(
	ID
	) ON UPDATE  NO ACTION 
	 ON DELETE  NO ACTION 
	
GO
ALTER TABLE dbo.Cashs SET (LOCK_ESCALATION = TABLE)
GO
COMMIT
select Has_Perms_By_Name(N'dbo.Cashs', 'Object', 'ALTER') as ALT_Per, Has_Perms_By_Name(N'dbo.Cashs', 'Object', 'VIEW DEFINITION') as View_def_Per, Has_Perms_By_Name(N'dbo.Cashs', 'Object', 'CONTROL') as Contr_Per BEGIN TRANSACTION
GO
ALTER TABLE dbo.FishRecs WITH NOCHECK ADD CONSTRAINT
	FK_FishRec_tbl_Customer_tbl FOREIGN KEY
	(
	CustomerRef
	) REFERENCES dbo.Customers
	(
	ID
	) ON UPDATE  NO ACTION 
	 ON DELETE  NO ACTION 
	
GO
ALTER TABLE dbo.FishRecs SET (LOCK_ESCALATION = TABLE)
GO
COMMIT
select Has_Perms_By_Name(N'dbo.FishRecs', 'Object', 'ALTER') as ALT_Per, Has_Perms_By_Name(N'dbo.FishRecs', 'Object', 'VIEW DEFINITION') as View_def_Per, Has_Perms_By_Name(N'dbo.FishRecs', 'Object', 'CONTROL') as Contr_Per BEGIN TRANSACTION
GO
ALTER TABLE dbo.FishPays WITH NOCHECK ADD CONSTRAINT
	FK_FishPay_Customer FOREIGN KEY
	(
	CustomerRef
	) REFERENCES dbo.Customers
	(
	ID
	) ON UPDATE  NO ACTION 
	 ON DELETE  NO ACTION 
	
GO
ALTER TABLE dbo.FishPays SET (LOCK_ESCALATION = TABLE)
GO
COMMIT
select Has_Perms_By_Name(N'dbo.FishPays', 'Object', 'ALTER') as ALT_Per, Has_Perms_By_Name(N'dbo.FishPays', 'Object', 'VIEW DEFINITION') as View_def_Per, Has_Perms_By_Name(N'dbo.FishPays', 'Object', 'CONTROL') as Contr_Per 

