USE [RoboAccDB]
GO

/*Delete all (decimal) from code*/

SELECT table_name [Table Name], column_name [Column Name] , COLUMN_DEFAULT , IS_NULLABLE ,data_type
FROM information_schema.columns where ( data_type = 'money' or data_type = 'decimal' ) and IS_NULLABLE='YES'

-- /////////////////////////////////////////////////////////// 

ALTER TABLE [dbo].[Assets]
	 ADD 
	  DEFAULT 0 FOR [Amount],
	  DEFAULT 0 FOR [BuyAmount],
	  DEFAULT 0 FOR [BuyPayAmount],
	  DEFAULT 0 FOR [SellAmount],
	  DEFAULT 0 FOR [SellRecAmount]
GO

UPDATE [dbo].[Assets] SET [Amount] = 0 WHERE [Amount] is NULL
UPDATE [dbo].[Assets] SET [BuyAmount] = 0 WHERE [BuyAmount] is NULL
UPDATE [dbo].[Assets] SET [BuyPayAmount] = 0 WHERE [BuyPayAmount] is NULL
UPDATE [dbo].[Assets] SET [SellAmount] = 0 WHERE [SellAmount] is NULL
UPDATE [dbo].[Assets] SET [SellRecAmount] = 0 WHERE [SellRecAmount] is NULL
GO

ALTER TABLE [dbo].[Assets] ALTER COLUMN  [Amount] money NOT NULL 
ALTER TABLE [dbo].[Assets] ALTER COLUMN  [BuyAmount] money NOT NULL 
ALTER TABLE [dbo].[Assets] ALTER COLUMN  [BuyPayAmount] money NOT NULL 
ALTER TABLE [dbo].[Assets] ALTER COLUMN  [SellAmount] money NOT NULL 
ALTER TABLE [dbo].[Assets] ALTER COLUMN  [SellRecAmount] money NOT NULL 
GO

-- /////////////////////////////////////////////////////////// 

ALTER TABLE [dbo].[CashBox]
	 ADD DEFAULT 0 FOR Amount,
		DEFAULT 0 FOR FirstAmount,
		DEFAULT 0 FOR CurrencyFirstAmount,
		DEFAULT 0 FOR CurrencyAmount
GO

UPDATE [dbo].[CashBox] SET [Amount] = 0 WHERE [Amount] is NULL
UPDATE [dbo].[CashBox] SET FirstAmount = 0 WHERE FirstAmount is NULL
UPDATE [dbo].[CashBox] SET CurrencyFirstAmount = 0 WHERE CurrencyFirstAmount is NULL
UPDATE [dbo].[CashBox] SET CurrencyAmount = 0 WHERE CurrencyAmount is NULL
GO

ALTER TABLE [dbo].[CashBox]	ALTER COLUMN  Amount money NOT NULL 
ALTER TABLE [dbo].[CashBox]	ALTER COLUMN  FirstAmount money NOT NULL 
ALTER TABLE [dbo].[CashBox]	ALTER COLUMN  CurrencyFirstAmount money NOT NULL 
ALTER TABLE [dbo].[CashBox]	ALTER COLUMN  CurrencyAmount money NOT NULL 
GO

-- /////////////////////////////////////////////////////////// 

ALTER TABLE [dbo].[InformationHistory]
	 ADD DEFAULT 0 FOR Sell	,
	  DEFAULT 0 FOR Profit	,
	  DEFAULT 0 FOR Recive	
	--  DEFAULT 0 FOR Income	,
	--  DEFAULT 0 FOR Outgo	
Go

UPDATE [dbo].[InformationHistory] SET Sell = 0 WHERE Sell is NULL
UPDATE [dbo].[InformationHistory] SET Profit = 0 WHERE Profit is NULL
UPDATE [dbo].[InformationHistory] SET Recive = 0 WHERE Recive is NULL
UPDATE [dbo].[InformationHistory] SET Income = 0 WHERE Income is NULL
UPDATE [dbo].[InformationHistory] SET Outgo = 0 WHERE Outgo is NULL
GO

ALTER TABLE [dbo].[InformationHistory]	 ALTER COLUMN   Sell	money NOT NULL 
ALTER TABLE [dbo].[InformationHistory]	 ALTER COLUMN   Profit	money NOT NULL 
ALTER TABLE [dbo].[InformationHistory]	 ALTER COLUMN   Recive	money NOT NULL 
ALTER TABLE [dbo].[InformationHistory]	 ALTER COLUMN   Income	money NOT NULL 
ALTER TABLE [dbo].[InformationHistory]	 ALTER COLUMN   Outgo	money NOT NULL 
GO

-- /////////////////////////////////////////////////////////// 

ALTER TABLE [dbo].[CostusItems]
	 ADD DEFAULT 0 FOR AmountRecive		
Go

UPDATE [dbo].[CostusItems] SET AmountRecive = 0 WHERE AmountRecive is NULL
GO

ALTER TABLE [dbo].[CostusItems]
	 ALTER COLUMN   AmountRecive	money NOT NULL 
GO

-- /////////////////////////////////////////////////////////// 

ALTER TABLE [dbo].[InOuts]
	 ADD DEFAULT 0 FOR RecPayAmount		
Go

UPDATE [dbo].[InOuts] SET RecPayAmount = 0 WHERE RecPayAmount is NULL
GO

ALTER TABLE [dbo].[InOuts]
	 ALTER COLUMN   RecPayAmount	money NOT NULL 
GO

-- /////////////////////////////////////////////////////////// 

ALTER TABLE [dbo].[Factors]
	 ADD DEFAULT 0 FOR 	ProductSumPrice,
	 /* DEFAULT 0 FOR 	DiscountPercent ,*/
	  DEFAULT 0 FOR 	DiscountPrice,
	  DEFAULT 0 FOR 	RealSum ,
	  DEFAULT 0 FOR 	Profit ,
	  DEFAULT 0 FOR 	RecPayAmount ,
	  DEFAULT 0 FOR 	Tax ,
	  DEFAULT 0 FOR 	RemainAmount ,
	  DEFAULT 0 FOR 	VisitorAmount ,
	  DEFAULT 0 FOR 	VisitorPercent ,
	  DEFAULT 0 FOR 	CurrencyValue ,
	  DEFAULT 0 FOR 	TaxPercent
GO

UPDATE [dbo].[Factors] SET ProductSumPrice	 = 0 WHERE ProductSumPrice	is NULL
UPDATE [dbo].[Factors] SET DiscountPercent	 = 0 WHERE DiscountPercent	is NULL
UPDATE [dbo].[Factors] SET DiscountPrice	 = 0 WHERE DiscountPrice	is NULL
UPDATE [dbo].[Factors] SET RealSum			 = 0 WHERE RealSum			is NULL
UPDATE [dbo].[Factors] SET Profit			 = 0 WHERE Profit			is NULL
UPDATE [dbo].[Factors] SET RecPayAmount		 = 0 WHERE RecPayAmount		is NULL
UPDATE [dbo].[Factors] SET Tax 				 = 0 WHERE Tax 				is NULL
UPDATE [dbo].[Factors] SET RemainAmount 	 = 0 WHERE RemainAmount 	is NULL
UPDATE [dbo].[Factors] SET VisitorAmount 	 = 0 WHERE VisitorAmount 	is NULL
UPDATE [dbo].[Factors] SET VisitorPercent 	 = 0 WHERE VisitorPercent 	is NULL
UPDATE [dbo].[Factors] SET CurrencyValue 	 = 0 WHERE CurrencyValue 	is NULL
UPDATE [dbo].[Factors] SET TaxPercent		 = 0 WHERE TaxPercent		is NULL

ALTER TABLE [dbo].[Factors]  ALTER COLUMN 	ProductSumPrice money NOT NULL
ALTER TABLE [dbo].[Factors]  ALTER COLUMN 	DiscountPercent decimal(5, 2) NOT NULL 
ALTER TABLE [dbo].[Factors]  ALTER COLUMN 	DiscountPrice money NOT NULL
ALTER TABLE [dbo].[Factors]  ALTER COLUMN 	RealSum money NOT NULL
ALTER TABLE [dbo].[Factors]  ALTER COLUMN 	Profit money NOT NULL
ALTER TABLE [dbo].[Factors]  ALTER COLUMN 	RecPayAmount money NOT NULL
ALTER TABLE [dbo].[Factors]  ALTER COLUMN 	Tax money NOT NULL
ALTER TABLE [dbo].[Factors]  ALTER COLUMN 	RemainAmount money NOT NULL
ALTER TABLE [dbo].[Factors]  ALTER COLUMN 	VisitorAmount money NOT NULL
ALTER TABLE [dbo].[Factors]  ALTER COLUMN 	VisitorPercent decimal(5, 2) NOT NULL 
ALTER TABLE [dbo].[Factors]  ALTER COLUMN 	CurrencyValue money NOT NULL
ALTER TABLE [dbo].[Factors]  ALTER COLUMN 	TaxPercent decimal(5, 2) NOT NULL 
GO

-- /////////////////////////////////////////////////////////// 

ALTER TABLE [dbo].[ProductCardex]
  ADD DEFAULT 0 FOR [ValueR],
	  DEFAULT 0 FOR [FeeR],
	  DEFAULT 0 FOR [SumR],
	  DEFAULT 0 FOR [BuySellRef],
	  DEFAULT 0 FOR [Covered]
GO


UPDATE [dbo].[ProductCardex] SET [ValueR]	 = 0 WHERE [ValueR]	is NULL
UPDATE [dbo].[ProductCardex] SET [FeeR]	 = 0 WHERE [FeeR]	is NULL
UPDATE [dbo].[ProductCardex] SET [SumR] = 0 WHERE [SumR]	is NULL
UPDATE [dbo].[ProductCardex] SET [BuySellRef]	 = 0 WHERE [BuySellRef]			is NULL
UPDATE [dbo].[ProductCardex] SET [Covered] = 0 WHERE [Covered]			is NULL
GO

ALTER TABLE [dbo].[ProductCardex]	 ALTER COLUMN  [ValueR] decimal(15, 2) NOT NULL 	  
ALTER TABLE [dbo].[ProductCardex]	 ALTER COLUMN  [FeeR] money NOT NULL 	  
ALTER TABLE [dbo].[ProductCardex]	 ALTER COLUMN  [SumR] money NOT NULL 	  
ALTER TABLE [dbo].[ProductCardex]	 ALTER COLUMN  [BuySellRef] int NOT NULL 
ALTER TABLE [dbo].[ProductCardex]	 ALTER COLUMN  [Covered] decimal(15, 2) NOT NULL 		  
GO

--/////////////////////////////////////////////////////////// 

ALTER TABLE [dbo].[ProductItems]
  ADD DEFAULT 0 FOR [Profit],
	  DEFAULT 0 FOR [SellPrice],
	  DEFAULT 0 FOR [DiscountPrice]
	  --DEFAULT 0 FOR [VisitorPercent],
	  --DEFAULT 0 FOR [DiscountPercent],
	  --DEFAULT 0 FOR [TaxPercent],
	  --DEFAULT 0 FOR [VisitorPrice],
	 -- DEFAULT 0 FOR [TaxPrice]
GO

UPDATE [dbo].[ProductItems] SET [Profit] = 0 WHERE [Profit]	is NULL
UPDATE [dbo].[ProductItems] SET [SellPrice] = 0 WHERE [SellPrice]	is NULL
UPDATE [dbo].[ProductItems] SET [DiscountPrice] = 0 WHERE [DiscountPrice]	is NULL
UPDATE [dbo].[ProductItems] SET [DiscountPercent] = 0 WHERE [DiscountPercent]	is NULL
UPDATE [dbo].[ProductItems] SET [VisitorPercent] = 0 WHERE [VisitorPercent]			is NULL
UPDATE [dbo].[ProductItems] SET [TaxPercent] = 0 WHERE [TaxPercent]			is NULL
UPDATE [dbo].[ProductItems] SET [VisitorPrice]	 = 0 WHERE [VisitorPrice]		is NULL
UPDATE [dbo].[ProductItems] SET [TaxPrice]	 = 0 WHERE [TaxPrice] 				is NULL
GO


ALTER TABLE [dbo].[ProductItems] ALTER COLUMN  [Profit]  money NOT NULL 	  
ALTER TABLE [dbo].[ProductItems] ALTER COLUMN  [SellPrice] money NOT NULL 	  
ALTER TABLE [dbo].[ProductItems] ALTER COLUMN  [DiscountPrice] money NOT NULL 	  
ALTER TABLE [dbo].[ProductItems] ALTER COLUMN  [DiscountPercent] decimal(5, 2) NOT NULL 		 
ALTER TABLE [dbo].[ProductItems] ALTER COLUMN  [VisitorPercent] decimal(5, 2) NOT NULL 		 
ALTER TABLE [dbo].[ProductItems] ALTER COLUMN  [TaxPercent]	   decimal(5, 2) NOT NULL 		 
ALTER TABLE [dbo].[ProductItems] ALTER COLUMN  [VisitorPrice] money NOT NULL 	  
ALTER TABLE [dbo].[ProductItems] ALTER COLUMN  [TaxPrice] money NOT NULL 	  
GO

-- /////////////////////////////////////////////////////////// 

ALTER TABLE [dbo].[Products]
	 ADD DEFAULT 0 FOR 	 CurValue,
	  DEFAULT 0 FOR 	 CurPrice,
	  DEFAULT 0 FOR 	 FirstValue	,
	  DEFAULT 0 FOR 	 PurchasePrice	,	
	  DEFAULT 0 FOR 	 LastPurchasePrice	,	
	  DEFAULT 0 FOR 	 FirstPurchasePrice	,	
	  DEFAULT 0 FOR 	 SalePrice2	,	
	  DEFAULT 0 FOR 	 SalePrice3	,	
	  DEFAULT 0 FOR 	 [Type]			
GO

UPDATE [dbo].[Products] SET CurValue = 0 WHERE CurValue	is NULL
UPDATE [dbo].[Products] SET CurPrice = 0 WHERE CurPrice	is NULL
UPDATE [dbo].[Products] SET FirstValue	 = 0 WHERE FirstValue	is NULL
UPDATE [dbo].[Products] SET PurchasePrice		 = 0 WHERE PurchasePrice		is NULL
UPDATE [dbo].[Products] SET LastPurchasePrice		 = 0 WHERE LastPurchasePrice	is NULL
UPDATE [dbo].[Products] SET FirstPurchasePrice		 = 0 WHERE FirstPurchasePrice	is NULL
UPDATE [dbo].[Products] SET SalePrice2		 = 0 WHERE SalePrice2		is NULL
UPDATE [dbo].[Products] SET SalePrice3		 = 0 WHERE SalePrice3		is NULL
UPDATE [dbo].[Products] SET [Type]			 = 0 WHERE [Type]		is NULL
GO

ALTER TABLE [dbo].[Products]	  ALTER COLUMN 	 CurValue decimal(15, 2) NOT NULL 		
ALTER TABLE [dbo].[Products]	  ALTER COLUMN 	 CurPrice  money NOT NULL 	  
ALTER TABLE [dbo].[Products]	  ALTER COLUMN 	 FirstValue	 decimal(15, 2) NOT NULL 		
ALTER TABLE [dbo].[Products]	  ALTER COLUMN 	 PurchasePrice	  money NOT NULL 	  	
ALTER TABLE [dbo].[Products]	  ALTER COLUMN 	 LastPurchasePrice	  money NOT NULL 	  	
ALTER TABLE [dbo].[Products]	  ALTER COLUMN 	 FirstPurchasePrice	  money NOT NULL 	  	
ALTER TABLE [dbo].[Products]	  ALTER COLUMN 	 SalePrice2		  money NOT NULL 	  
ALTER TABLE [dbo].[Products]	  ALTER COLUMN 	 SalePrice3		  money NOT NULL 	  
ALTER TABLE [dbo].[Products]	  ALTER COLUMN 	 [Type]		int NOT NULL   	
GO


-- /////////////////////////////////////////////////////////// 

ALTER TABLE [dbo].[ProductUnits]
	 ADD DEFAULT 0 FOR 	 SalePrice,
	  DEFAULT 0 FOR 	 SalePrice2,
	  DEFAULT 0 FOR 	 SalePrice3	
GO

UPDATE [dbo].[ProductUnits] SET SalePrice	 = 0 WHERE SalePrice	is NULL
UPDATE [dbo].[ProductUnits] SET SalePrice2	 = 0 WHERE SalePrice2	is NULL
UPDATE [dbo].[ProductUnits] SET SalePrice3		 = 0 WHERE SalePrice3		is NULL

ALTER TABLE [dbo].[ProductUnits]	  ALTER COLUMN 	 SalePrice money NOT NULL
ALTER TABLE [dbo].[ProductUnits]	  ALTER COLUMN 	 SalePrice2 money NOT NULL
ALTER TABLE [dbo].[ProductUnits]	  ALTER COLUMN 	 SalePrice3	 money NOT NULL
GO

-- /////////////////////////////////////////////////////////// 

ALTER TABLE [dbo].[Customers]
ADD 
 [SumBuy]	money	 NOT NULL  DEFAULT(0),
 [Rank]		int		 NOT NULL  DEFAULT(0),
 [Credit]	money	 NOT NULL  DEFAULT(0)
GO

UPDATE [dbo].[Customers]
	SET [dbo].[Customers].[SumBuy] = ISNULL((Select sum([RealSum]) from Factors where Factors.[TypeRef]=3 and Factors.CustomerRef=[dbo].[Customers].ID),0)
								-ISNULL((Select sum([RealSum]) from Factors where Factors.[TypeRef]=4 and Factors.CustomerRef=[dbo].[Customers].ID),0)

GO

ALTER TABLE [dbo].[Customers]
	 ADD DEFAULT 0 FOR [FirstPrice]
GO

UPDATE [dbo].[Customers] SET [FirstPrice]	 = 0 WHERE [FirstPrice]	is NULL
GO

ALTER TABLE [dbo].[Customers]
	 ALTER COLUMN  [FirstPrice] money NOT NULL 	  
GO
/*end customer */


-- //////////////////////////////////////////////////////////////////// 

ALTER TABLE [dbo].[FishPays]
ADD 
 [CashBoxRef] int	 NOT NULL  DEFAULT(1)
GO

ALTER TABLE [dbo].[FishPays]  WITH CHECK ADD  CONSTRAINT [FK_FishPays_CashBox] FOREIGN KEY([CashBoxRef])
REFERENCES [dbo].[CashBox] ([ID])
GO

-- /////////////////////////////////////////////////////////// 
  
CREATE TABLE [dbo].[DocHeader](
	[ID] [int] NOT NULL,
	[RefTable] [tinyint] NULL,
	[RefID] [int] NULL,
	[Date] [datetime]  NULL,
	[Subject] [nvarchar](50) NULL,
	[Bed] [money] NOT NULL,
	[Bes] [money] NOT NULL,
 CONSTRAINT [PK_Header] PRIMARY KEY CLUSTERED 
(
	[ID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]

GO

-- /////////////////////////////////////////////////////////// 


ALTER TABLE [dbo].Accounts		 ADD [DocID]	int	 NULL
CREATE INDEX [DocIDIndex]	ON [dbo].Accounts ([DocID]);

ALTER TABLE [dbo].CashBox		 ADD [DocID]	int	 NULL
CREATE INDEX [DocIDIndex]	ON [dbo].CashBox ([DocID]);
								
ALTER TABLE [dbo].BankMovements	 ADD [DocID]	int	 NULL
CREATE INDEX [DocIDIndex]	ON [dbo].BankMovements ([DocID]);

ALTER TABLE [dbo].BankActs		 ADD [DocID]	int	 NULL
CREATE INDEX [DocIDIndex]	ON [dbo].BankActs ([DocID]);

ALTER TABLE [dbo].Capitals		 ADD [DocID]	int	 NULL
CREATE INDEX [DocIDIndex]	ON [dbo].Capitals ([DocID]);
								
ALTER TABLE [dbo].Cashs			 ADD [DocID]	int	 NULL
CREATE INDEX [DocIDIndex]	ON [dbo].Cashs ([DocID]);
ALTER TABLE [dbo].ChequePays	 ADD [DocID]	int	 NULL
CREATE INDEX [DocIDIndex]	ON [dbo].ChequePays ([DocID]);
ALTER TABLE [dbo].ChequeRecs	 ADD [DocID]	int	 NULL
CREATE INDEX [DocIDIndex]	ON [dbo].ChequeRecs ([DocID]);
ALTER TABLE [dbo].ChequeRecs	 ADD [DocID2]	int	 NULL
CREATE INDEX [DocIDIndex2]	ON [dbo].ChequeRecs ([DocID2]);
ALTER TABLE [dbo].Costuses		 ADD [DocID]	int	 NULL
CREATE INDEX [DocIDIndex]	ON [dbo].Costuses ([DocID]);
ALTER TABLE [dbo].CostusItems	 ADD [DocID]	int	 NULL
CREATE INDEX [DocIDIndex]	ON [dbo].CostusItems ([DocID]);
ALTER TABLE [dbo].FishPays		 ADD [DocID]	int	 NULL
CREATE INDEX [DocIDIndex]	ON [dbo].FishPays ([DocID]);
ALTER TABLE [dbo].FishRecs		 ADD [DocID]	int	 NULL
CREATE INDEX [DocIDIndex]	ON [dbo].FishRecs ([DocID]);
								
ALTER TABLE [dbo].Assets		 ADD [DocID]	int	 NULL
CREATE INDEX [DocIDIndex]	ON [dbo].Assets ([DocID]);
ALTER TABLE [dbo].Assets		 ADD [DocIDSell]	int	 NULL
CREATE INDEX [DocIDSellIndex]	ON [dbo].Assets ([DocIDSell]);
ALTER TABLE [dbo].Factors		 ADD [DocID]	int	 NULL
CREATE INDEX [DocIDIndex]	ON [dbo].Factors ([DocID]);
ALTER TABLE [dbo].InOuts		 ADD [DocID]	int	 NULL
CREATE INDEX [DocIDIndex]	ON [dbo].InOuts ([DocID]);
ALTER TABLE [dbo].Wastages		 ADD [DocID]	int	 NULL
CREATE INDEX [DocIDIndex]	ON [dbo].Wastages ([DocID]);


GO

-- /////////////////////////////////////////////////////////// 



INSERT INTO [dbo].[DocHeader]
           ([ID]
           ,[RefTable]
           ,[RefID]
           ,[Date]           
           ,[Bed]
           ,[Bes]
		   )
     Select            
		    (SELECT ISNULL(MAX( [dbo].[DocHeader].ID ),0) FROM [dbo].[DocHeader])+ row_number() over (order by id)
           ,[TypeRef]
           ,[ID]
           ,[Date]           
           ,0
           ,0		   
	from [dbo].[Factors] where  not EXISTS (select 1 from [DocHeader] where [DocHeader].RefTable = [Factors].[TypeRef] and [DocHeader].RefID = [Factors].[ID] )
	GO

INSERT INTO [dbo].[DocHeader]
           ([ID]
           ,[RefTable]
           ,[RefID]
           ,[Date]           
           ,[Bed]
           ,[Bes]
		   )
     Select            
		    (SELECT ISNULL(MAX( [dbo].[DocHeader].ID ),0) FROM [dbo].[DocHeader])+ row_number() over (order by id)
           ,14-[Type]
           ,[ID]
           ,[Date]           
           ,0
           ,0		   
	from [dbo].[InOuts] where  not EXISTS (select 1 from [DocHeader] where [DocHeader].RefTable = 14-[Type] and [DocHeader].RefID = [InOuts].[ID] )
	GO

	INSERT INTO [dbo].[DocHeader]
           ([ID]
           ,[RefTable]
           ,[RefID]
           ,[Date]           
           ,[Bed]
           ,[Bes]
		   )
     Select            
		    (SELECT ISNULL(MAX( [dbo].[DocHeader].ID ),0) FROM [dbo].[DocHeader])+ row_number() over (order by id)
           ,IIF ( BuyCustomerRef is not NULL , 6, IIF ( SellCustomerRef is not NULL , 7, 6))
           ,[ID]
           ,[Date]           
           ,0
           ,0		   
	from [dbo].[Assets] where  not EXISTS (select 1 from [DocHeader] where [DocHeader].RefTable = IIF ( BuyCustomerRef is not NULL , 6, IIF ( SellCustomerRef is not NULL , 7, 7)) and [DocHeader].RefID = [Assets].[ID] )
	GO

	INSERT INTO [dbo].[DocHeader]
           ([ID]
           ,[RefTable]
           ,[RefID]
           ,[Date]           
           ,[Bed]
           ,[Bes]
		   )
     Select            
		    (SELECT ISNULL(MAX( [dbo].[DocHeader].ID ),0) FROM [dbo].[DocHeader])+ row_number() over (order by id)
           ,12
           ,[ID]
           ,[RecDate]          
           ,0
           ,0		   
	from [dbo].[CostusItems]  where  not EXISTS (select 1 from [DocHeader] where [DocHeader].RefTable = 12 and [DocHeader].RefID = [CostusItems].[ID] )

	GO

-- /////////////////////////////////////////////////////////// 

UPDATE [dbo].[Factors]
   SET 
      [DocID] =  ISNULL(( SELECT [ID] FROM [dbo].[DocHeader] Where [dbo].[DocHeader].[RefID]=[dbo].[Factors].[ID] and [dbo].[DocHeader].[RefTable] = [dbo].[Factors].[TypeRef] ),0)
GO


UPDATE [dbo].[InOuts]
   SET 
      [DocID] =  ISNULL(( SELECT [ID] FROM [dbo].[DocHeader] Where [dbo].[DocHeader].[RefID]=[dbo].[InOuts].[ID] and [dbo].[DocHeader].[RefTable] in (13,14) ),0)
GO


UPDATE [dbo].[Assets]
   SET 
      [DocID] =  ISNULL(( SELECT [ID] FROM [dbo].[DocHeader] Where [dbo].[DocHeader].[RefID]=[dbo].[Assets].[ID] and [dbo].[DocHeader].[RefTable] in (6,7) ),0)
GO

UPDATE [dbo].[CostusItems]
   SET 
      [DocID] =  ISNULL(( SELECT [ID] FROM [dbo].[DocHeader] Where [dbo].[DocHeader].[RefID]=[dbo].[CostusItems].[ID] and [dbo].[DocHeader].[RefTable] in (12) ),0)
GO

-- /////////////////////////////////////////////////////////// 

UPDATE [dbo].[ChequeRecs]
   SET [DocID2] = 
   (
	SELECT [ID]     
	FROM [dbo].[DocHeader]
	WHERE [RefTable]=[ChequeRecs].[RefTablePerson] AND [RefID]=[ChequeRecs].[RefIDPerson]
	)
 WHERE ([RefTable] is not NULL and [RefID] is not NULL)
GO


DECLARE @Str NVARCHAR(MAX)
SET @Str = ',ChequePays,ChequeRecs,Costuses,Cashs,FishPays,FishRecs,'
DECLARE @Part NVARCHAR(MAX)
DECLARE @sqlText nvarchar(MAX);
DECLARE @tablename nvarchar(MAX);
DECLARE @IND    INT
SET @IND = CHARINDEX(',',@Str)
DECLARE @EIND INT set @EIND = 0
WHILE(@IND != LEN(@STR))

BEGIN
    SET  @EIND = ISNULL(((CHARINDEX(',', @Str, @IND + 1)) - @IND - 1), 0)
	SET  @tablename = (SUBSTRING(@Str, (@IND  + 1),  @EIND))
    SET @sqlText = 'UPDATE [dbo].'+@tablename+' 
					   SET [DocID] = 
					   (
						SELECT [ID]     
						FROM [dbo].[DocHeader]
						WHERE [RefTable]=['+@tablename+'].[RefTable] AND [RefID]=['+@tablename+'].[RefID]
						)
					 WHERE ([RefTable] is not NULL and [RefID] is not NULL)'
	print @sqlText
	Exec sp_executesql @sqlText
    SELECT @IND = ISNULL(CHARINDEX(',', @STR, @IND + 1), 0)
END
GO

-- /////////////////////////////////////////////////////////// 

DECLARE @Str NVARCHAR(MAX)
DECLARE @Part NVARCHAR(MAX)
DECLARE @sqlText nvarchar(MAX);
DECLARE @tablename nvarchar(MAX);
DECLARE @IND    INT
DECLARE @EIND INT 

SET @Str = ',Accounts,CashBox,BankMovements,BankActs,Capitals,Cashs,ChequePays,ChequeRecs,Costuses,CostusItems,FishPays,FishRecs,Assets,Factors,InOuts,Wastages,'
SET @IND = CHARINDEX(',',@Str)
SET @EIND = 0
WHILE(@IND != LEN(@STR))
BEGIN
    SET  @EIND = ISNULL(((CHARINDEX(',', @Str, @IND + 1)) - @IND - 1), 0)
	SET  @tablename = (SUBSTRING(@Str, (@IND  + 1),  @EIND))
    SET @sqlText = 'ALTER TABLE [dbo].['+@tablename+']  WITH CHECK ADD  CONSTRAINT [FK_'+@tablename+'_DocHeader] FOREIGN KEY([DocID])
					REFERENCES [dbo].[DocHeader] ([ID])'		   
			
	print @sqlText
	Exec sp_executesql @sqlText
    SELECT @IND = ISNULL(CHARINDEX(',', @STR, @IND + 1), 0)
END


ALTER TABLE [dbo].[ChequeRecs]  WITH CHECK ADD  CONSTRAINT [FK_ChequeRecs2_DocHeader] FOREIGN KEY([DocID2])
REFERENCES [dbo].[DocHeader] ([ID])
GO

ALTER TABLE [dbo].[Assets]  WITH CHECK ADD  CONSTRAINT [FK_CashsSell_DocHeader] FOREIGN KEY([DocIDSell])
REFERENCES [dbo].[DocHeader] ([ID])
GO

-- /////////////////////////////////////////////////////////// 

ALTER TABLE [ChequeRecs] DROP COLUMN  [RefTablePerson]
ALTER TABLE [ChequeRecs] DROP COLUMN  [RefIDPerson]
GO

DROP INDEX ChequeRecs.IX_ChequeRecs_2;
DROP INDEX ChequePays.IX_ChequePays_2;
DROP INDEX Costuses.IX_Costuses_2;
DROP INDEX Cashs.IX_Cashs;
GO

ALTER TABLE FishRecs DROP CONSTRAINT DF_FishRec_RefID;
ALTER TABLE Cashs DROP CONSTRAINT DF_CashRec_RefID;
ALTER TABLE FishPays DROP CONSTRAINT DF_FishPay_RefID;
ALTER TABLE Costuses DROP CONSTRAINT DF_Costus_RefID;
GO

DECLARE @Str NVARCHAR(MAX)
DECLARE @IND    INT
DECLARE @EIND INT set @EIND = 0
DECLARE @tablename nvarchar(MAX);
DECLARE @sqlText nvarchar(MAX);
DECLARE @Part NVARCHAR(MAX)

SET @Str = ',ChequePays,ChequeRecs,FishRecs,Costuses,Cashs,FishPays,InOuts,'
SET @IND = CHARINDEX(',',@Str)
WHILE(@IND != LEN(@STR))

BEGIN
    SET  @EIND = ISNULL(((CHARINDEX(',', @Str, @IND + 1)) - @IND - 1), 0)
	SET  @tablename = (SUBSTRING(@Str, (@IND  + 1),  @EIND))
    SET @sqlText = 'ALTER TABLE '+@tablename+' DROP COLUMN  [RefTable]'
	Exec sp_executesql @sqlText
	SET @sqlText = 'ALTER TABLE '+@tablename+' DROP COLUMN  [RefID]'
	Exec sp_executesql @sqlText
    SELECT @IND = ISNULL(CHARINDEX(',', @STR, @IND + 1), 0)
END


--RefTable	Cashs
--RefTable	ChequePays
--RefTable	ChequeRecs
--RefTablePerson	ChequeRecs
--RefTable	Costuses
--RefTable	FishPays
--RefTable	FishRecs
--RefTable	InOuts

GO

--/////////////////////////////////////////////////////////// 

ALTER TABLE [dbo].Products DROP CONSTRAINT DF_Products_DiscountPercent;
ALTER TABLE [dbo].Products DROP COLUMN [DiscountPercent];
Go

ALTER TABLE [dbo].Products	ADD 
	 [Discount]	[money] NOT NULL  DEFAULT(0),
	 [DiscountEndDate]	datetime	 NULL
Go

-- /////////////////////////////////////////////////////////// 

UPDATE [dbo].[Cache]   SET [value] = '3'  Where name='company_ShowShortcutMenu'
UPDATE [dbo].[Cache]   SET [value] = '2.0.33'  Where name='VersionDatabase'
GO


