
USE [RoboAccDB]
GO

CREATE TABLE [dbo].[Production](
    [ID] [int] IDENTITY(1,1) NOT NULL,
    [ProuductBase] [int] NOT NULL,
    [ProductRef] [int] NOT NULL,
    [UnitRef] [int] NOT NULL,
    [Value] [decimal](15, 2) NULL,
CONSTRAINT [PK_Produce] PRIMARY KEY CLUSTERED
(
    [ID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]

GO

ALTER TABLE [dbo].[Production]  WITH CHECK ADD  CONSTRAINT [FK_Produce_Units] FOREIGN KEY([UnitRef])
REFERENCES [dbo].[Units] ([ID])
GO

ALTER TABLE [dbo].[Production] CHECK CONSTRAINT [FK_Produce_Units]
GO

ALTER TABLE [dbo].[Production]  WITH CHECK ADD  CONSTRAINT [FK_ProductionBase_ProductsID] FOREIGN KEY([ProuductBase])
REFERENCES [dbo].[Products] ([ID])
GO

ALTER TABLE [dbo].[Production] CHECK CONSTRAINT [FK_ProductionBase_ProductsID]
GO

ALTER TABLE [dbo].[Production]  WITH CHECK ADD  CONSTRAINT [FK_ProductionRef_ProductsID] FOREIGN KEY([ProductRef])
REFERENCES [dbo].[Products] ([ID])
GO

ALTER TABLE [dbo].[Production] CHECK CONSTRAINT [FK_ProductionRef_ProductsID]
GO

ALTER TABLE dbo.Wastages
add [RefID] INT NULL
GO

ALTER TABLE Products
add [Production] [bit] NULL
GO

ALTER TABLE Products
add [Type] INT NULL
GO


DROP TABLE dbo.Users
GO
/****** Object:  Table [dbo].[GroupPermission]    Script Date: 2016/03/13 03:21:15 . ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[GroupPermission](
    [ID] [int] IDENTITY(1,1) NOT NULL,
    [GroupRef] [int] NOT NULL,
    [PartRef] [int] NOT NULL,
    [View] [bit] NOT NULL,
    [Edit] [bit] NOT NULL,
    [Del] [bit] NOT NULL,
    [New] [bit] NOT NULL,
    [Description] [nvarchar](max) NULL,
CONSTRAINT [PK_UserPremission] PRIMARY KEY CLUSTERED
(
    [ID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]

GO
/****** Object:  Table [dbo].[Groups]    Script Date: 2016/03/13 03:21:15 . ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[Groups](
    [ID] [int] IDENTITY(1,1) NOT NULL,
    [Name] [nvarchar](max) NOT NULL,
    [Description] [nvarchar](max) NULL,
CONSTRAINT [PK_Groups] PRIMARY KEY CLUSTERED
(
    [ID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]

GO
/****** Object:  Table [dbo].[Parts]    Script Date: 2016/03/13 03:21:15 . ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[Parts](
    [ID] [int] IDENTITY(1,1) NOT NULL,
    [Name] [nvarchar](max) NOT NULL,
    [Description] [nvarchar](max) NULL,
CONSTRAINT [PK_Parts] PRIMARY KEY CLUSTERED
(
    [ID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]

GO
/****** Object:  Table [dbo].[UserGroups]    Script Date: 2016/03/13 03:21:15 . ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[UserGroups](
    [ID] [int] IDENTITY(1,1) NOT NULL,
    [UserRef] [int] NOT NULL,
    [GroupRef] [int] NOT NULL,
    [Description] [nvarchar](max) NULL,
CONSTRAINT [PK_UserGroups] PRIMARY KEY CLUSTERED
(
    [ID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]

GO
/****** Object:  Table [dbo].[Users]    Script Date: 2016/03/13 03:21:15 . ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[Users](
    [ID] [int] IDENTITY(1,1) NOT NULL,
    [UserName] [nvarchar](max) NOT NULL,
    [Password] [nvarchar](max) NULL,
    [Role] [nvarchar](max) NULL,
    [Description] [nvarchar](max) NULL,
CONSTRAINT [PK_Users] PRIMARY KEY CLUSTERED
(
    [ID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]

GO
ALTER TABLE [dbo].[GroupPermission]  WITH CHECK ADD  CONSTRAINT [FK_GroupPermission_Groups1] FOREIGN KEY([GroupRef])
REFERENCES [dbo].[Groups] ([ID])
GO
ALTER TABLE [dbo].[GroupPermission] CHECK CONSTRAINT [FK_GroupPermission_Groups1]
GO
ALTER TABLE [dbo].[GroupPermission]  WITH CHECK ADD  CONSTRAINT [FK_UserPermission_Parts] FOREIGN KEY([PartRef])
REFERENCES [dbo].[Parts] ([ID])
GO
ALTER TABLE [dbo].[GroupPermission] CHECK CONSTRAINT [FK_UserPermission_Parts]
GO
ALTER TABLE [dbo].[UserGroups]  WITH CHECK ADD  CONSTRAINT [FK_UserGroups_Groups] FOREIGN KEY([GroupRef])
REFERENCES [dbo].[Groups] ([ID])
GO
ALTER TABLE [dbo].[UserGroups] CHECK CONSTRAINT [FK_UserGroups_Groups]
GO
ALTER TABLE [dbo].[UserGroups]  WITH CHECK ADD  CONSTRAINT [FK_UserGroups_Users] FOREIGN KEY([UserRef])
REFERENCES [dbo].[Users] ([ID])
GO
ALTER TABLE [dbo].[UserGroups] CHECK CONSTRAINT [FK_UserGroups_Users]
GO
SET IDENTITY_INSERT [dbo].[Users] ON
GO
INSERT [dbo].[Users] ([ID], [UserName], [Password], [Role], [Description]) VALUES (1, N'admin', N'aQosBJSbLrMFuVBeZ6ct6yijhhvtEsSD10z9zVc2olwZPLWpAI91HOmqz0/ngGnDFyKzDeHP6ms6GJQ/b+jZgA==', N'Admin     ', NULL)
GO
SET IDENTITY_INSERT [dbo].[Users] OFF
GO